/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.runtime.ErrorPageAction;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.TemplateHtmlBuilder;
import io.quarkus.runtime.logging.DecorateStackUtil;
import io.quarkus.security.AuthenticationCompletionException;
import io.quarkus.security.AuthenticationException;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.ForbiddenException;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.vertx.http.runtime.VertxHttpConfig;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.vertx.core.Handler;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.ParsableMIMEValue;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class QuarkusErrorHandler
implements Handler<RoutingContext> {
    private static final Logger log = Logger.getLogger(QuarkusErrorHandler.class);
    private static final String NL = "\n";
    private static final String TAB = "\t";
    private static final String HEADING = "500 - Internal Server Error";
    private static final AtomicLong ERROR_COUNT = new AtomicLong();
    private final boolean showStack;
    private final boolean decorateStack;
    private final Optional<VertxHttpConfig.PayloadHint> contentTypeDefault;
    private final List<ErrorPageAction> actions;
    private final List<String> knowClasses;
    private final String srcMainJava;

    public QuarkusErrorHandler(boolean showStack, boolean decorateStack, Optional<VertxHttpConfig.PayloadHint> contentTypeDefault) {
        this(showStack, decorateStack, contentTypeDefault, null, List.of(), List.of());
    }

    public QuarkusErrorHandler(boolean showStack, boolean decorateStack, Optional<VertxHttpConfig.PayloadHint> contentTypeDefault, String srcMainJava, List<String> knowClasses, List<ErrorPageAction> actions) {
        this.showStack = showStack;
        this.decorateStack = decorateStack;
        this.contentTypeDefault = contentTypeDefault;
        this.srcMainJava = srcMainJava;
        this.knowClasses = knowClasses;
        this.actions = actions;
    }

    public void handle(final RoutingContext event) {
        String details;
        Throwable exception = event.failure();
        try {
            if (exception == null) {
                event.response().setStatusCode(event.statusCode());
                event.response().end();
                return;
            }
            if (exception instanceof UnauthorizedException) {
                HttpAuthenticator authenticator = (HttpAuthenticator)event.get(HttpAuthenticator.class.getName());
                if (authenticator != null) {
                    authenticator.sendChallenge(event).subscribe().with((Consumer)new Consumer<Boolean>(){

                        @Override
                        public void accept(Boolean aBoolean) {
                            event.response().end();
                        }
                    }, (Consumer)new Consumer<Throwable>(){

                        @Override
                        public void accept(Throwable throwable) {
                            event.fail(throwable);
                        }
                    });
                } else {
                    event.response().setStatusCode(HttpResponseStatus.UNAUTHORIZED.code()).end();
                }
                return;
            }
            if (exception instanceof ForbiddenException) {
                event.response().setStatusCode(HttpResponseStatus.FORBIDDEN.code()).end();
                return;
            }
            if (exception instanceof AuthenticationException) {
                if (event.response().getStatusCode() == HttpResponseStatus.OK.code()) {
                    event.response().setStatusCode(HttpResponseStatus.UNAUTHORIZED.code());
                }
                if ((exception instanceof AuthenticationCompletionException || exception instanceof AuthenticationFailedException && event.response().getStatusCode() == 401) && exception.getMessage() != null && LaunchMode.isDev()) {
                    event.response().end(exception.getMessage());
                } else {
                    event.response().end();
                }
                return;
            }
            if (exception instanceof RejectedExecutionException) {
                log.warn((Object)"Worker thread pool exhaustion, no more worker threads available - returning a `503 - SERVICE UNAVAILABLE` response.");
                event.response().setStatusCode(HttpResponseStatus.SERVICE_UNAVAILABLE.code()).end();
                return;
            }
        }
        catch (IllegalStateException e) {
            if (!event.response().ended()) {
                event.response().end();
            }
            return;
        }
        if (!event.response().headWritten()) {
            event.response().setStatusCode(event.statusCode() > 0 ? event.statusCode() : 500);
        }
        String uuid = LazyHolder.BASE_ID + ERROR_COUNT.incrementAndGet();
        String stack = "";
        String responseContentType = null;
        try {
            responseContentType = ContentTypes.pickFirstSupportedAndAcceptedContentType(event);
        }
        catch (RuntimeException e) {
            exception.addSuppressed(e);
        }
        if (this.showStack && exception != null) {
            details = QuarkusErrorHandler.generateHeaderMessage(exception, uuid);
            stack = QuarkusErrorHandler.generateStackTrace(exception);
        } else {
            details = QuarkusErrorHandler.generateHeaderMessage(uuid);
        }
        if (exception instanceof IOException) {
            log.debugf(exception, "IOError processing HTTP request to %s failed, the client likely terminated the connection. Error id: %s", (Object)event.request().uri(), (Object)uuid);
        } else {
            log.errorf(exception, "HTTP Request to %s failed, error id: %s", (Object)event.request().uri(), (Object)uuid);
        }
        if (event.response().ended()) {
            return;
        }
        if (event.response().headWritten()) {
            event.response().end();
            return;
        }
        if (responseContentType == null) {
            responseContentType = "";
        }
        block11 : switch (responseContentType) {
            case "text/html": 
            case "application/xhtml+xml": 
            case "application/xml": 
            case "text/xml": {
                this.htmlResponse(event, details, exception);
                break;
            }
            case "application/json": 
            case "text/json": {
                this.jsonResponse(event, responseContentType, details, stack, exception);
                break;
            }
            case "text/plain": {
                this.textResponse(event, details, stack, exception);
                break;
            }
            default: {
                if (this.contentTypeDefault.isPresent()) {
                    switch (this.contentTypeDefault.get()) {
                        case HTML: {
                            this.htmlResponse(event, details, exception);
                            break block11;
                        }
                        case JSON: {
                            this.jsonResponse(event, "application/json", details, stack, exception);
                            break block11;
                        }
                        case TEXT: {
                            this.textResponse(event, details, stack, exception);
                            break block11;
                        }
                    }
                    this.defaultResponse(event, details, stack, exception);
                    break;
                }
                this.defaultResponse(event, details, stack, exception);
            }
        }
    }

    private void defaultResponse(RoutingContext event, String details, String stack, Throwable throwable) {
        String userAgent = event.request().getHeader("User-Agent");
        if (userAgent != null && (userAgent.toLowerCase(Locale.ROOT).startsWith("wget/") || userAgent.toLowerCase(Locale.ROOT).startsWith("curl/"))) {
            this.textResponse(event, details, stack, throwable);
        } else {
            this.jsonResponse(event, "application/json", details, stack, throwable);
        }
    }

    private void textResponse(RoutingContext event, String details, String stack, Throwable throwable) {
        event.response().headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"text/plain; charset=utf-8");
        String decoratedString = null;
        if (this.decorateStack && throwable != null) {
            decoratedString = DecorateStackUtil.getDecoratedString((Throwable)throwable, (String)this.srcMainJava, this.knowClasses);
        }
        try (StringWriter sw = new StringWriter();){
            sw.write("\n500 - Internal Server Error\n");
            sw.write("---------------------------\n");
            sw.write(NL);
            sw.write("Details:");
            sw.write(NL);
            sw.write(TAB + details);
            sw.write(NL);
            if (decoratedString != null) {
                sw.write("Decorate (Source code):");
                sw.write(NL);
                sw.write(TAB + decoratedString);
                sw.write(NL);
            }
            sw.write("Stack:");
            sw.write(NL);
            sw.write(TAB + stack);
            sw.write(NL);
            this.writeResponse(event, sw.toString());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private void jsonResponse(RoutingContext event, String contentType, String details, String stack, Throwable throwable) {
        event.response().headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)(contentType + "; charset=utf-8"));
        String escapedDetails = QuarkusErrorHandler.escapeJsonString(details);
        String escapedStack = QuarkusErrorHandler.escapeJsonString(stack);
        String decoratedString = null;
        if (this.decorateStack && throwable != null) {
            decoratedString = DecorateStackUtil.getDecoratedString((Throwable)throwable, (String)this.srcMainJava, this.knowClasses);
        }
        StringBuilder jsonPayload = new StringBuilder("{\"details\":\"").append(escapedDetails);
        if (decoratedString != null) {
            jsonPayload = jsonPayload.append("\",\"decorate\":\"").append(QuarkusErrorHandler.escapeJsonString(decoratedString));
        }
        jsonPayload = jsonPayload.append("\",\"stack\":\"").append(escapedStack).append("\"}");
        this.writeResponse(event, jsonPayload.toString());
    }

    private void htmlResponse(RoutingContext event, String details, Throwable exception) {
        event.response().headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"text/html; charset=utf-8");
        TemplateHtmlBuilder htmlBuilder = new TemplateHtmlBuilder(this.showStack, "Internal Server Error", details, details, this.actions);
        if (this.decorateStack && exception != null) {
            htmlBuilder.decorate(exception, this.srcMainJava, this.knowClasses);
        }
        if (this.showStack && exception != null) {
            htmlBuilder.stack(exception, this.knowClasses);
        }
        this.writeResponse(event, htmlBuilder.toString());
    }

    private void writeResponse(RoutingContext event, String output) {
        if (!event.response().ended()) {
            event.response().end(output);
        }
    }

    private static String generateStackTrace(Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString().trim();
    }

    private static String generateHeaderMessage(Throwable exception, String uuid) {
        return String.format("Error id %s, %s: %s", uuid, exception.getClass().getName(), QuarkusErrorHandler.extractFirstLine(exception.getMessage()));
    }

    private static String generateHeaderMessage(String uuid) {
        return String.format("Error id %s", uuid);
    }

    private static String extractFirstLine(String message) {
        if (null == message) {
            return "";
        }
        String[] lines = message.split("\\r?\\n");
        return lines[0].trim();
    }

    static String escapeJsonString(String text) {
        StringBuilder sb = new StringBuilder();
        block9: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private static class LazyHolder {
        private static final String BASE_ID = String.valueOf(UUID.randomUUID()) + "-";

        private LazyHolder() {
        }
    }

    private static final class ContentTypes {
        private static final String APPLICATION_JSON = "application/json";
        private static final String TEXT_JSON = "text/json";
        private static final String TEXT_HTML = "text/html";
        private static final String TEXT_PLAIN = "text/plain";
        private static final String APPLICATION_XHTML = "application/xhtml+xml";
        private static final String APPLICATION_XML = "application/xml";
        private static final String TEXT_XML = "text/xml";
        private static final List<MIMEHeader> BASE_HEADERS = List.of(ContentTypes.createParsableMIMEValue("application/json"), ContentTypes.createParsableMIMEValue("text/json"), ContentTypes.createParsableMIMEValue("text/html"), ContentTypes.createParsableMIMEValue("application/xhtml+xml"), ContentTypes.createParsableMIMEValue("application/xml"), ContentTypes.createParsableMIMEValue("text/xml"));
        private static final Collection<MIMEHeader> SUPPORTED = ContentTypes.createSupported();
        private static final Collection<MIMEHeader> SUPPORTED_CURL = ContentTypes.createSupportedCurl();

        private ContentTypes() {
        }

        private static Collection<MIMEHeader> createSupported() {
            ArrayList<Object> supported = new ArrayList<Object>(BASE_HEADERS.size() + 1);
            supported.addAll(BASE_HEADERS);
            supported.add(ContentTypes.createParsableMIMEValue(TEXT_PLAIN));
            return Collections.unmodifiableCollection(supported);
        }

        private static Collection<MIMEHeader> createSupportedCurl() {
            ArrayList<Object> supportedCurl = new ArrayList<Object>(BASE_HEADERS.size() + 1);
            supportedCurl.add(ContentTypes.createParsableMIMEValue(TEXT_PLAIN));
            supportedCurl.addAll(BASE_HEADERS);
            return Collections.unmodifiableCollection(supportedCurl);
        }

        private static ParsableMIMEValue createParsableMIMEValue(String applicationJson) {
            return new ParsableMIMEValue(applicationJson).forceParse();
        }

        static String pickFirstSupportedAndAcceptedContentType(RoutingContext context) {
            List acceptableTypes = context.parsedHeaders().accept();
            String userAgent = context.request().getHeader("User-Agent");
            if (userAgent != null && (userAgent.toLowerCase(Locale.ROOT).startsWith("wget/") || userAgent.toLowerCase(Locale.ROOT).startsWith("curl/"))) {
                MIMEHeader result = context.parsedHeaders().findBestUserAcceptedIn(acceptableTypes, SUPPORTED_CURL);
                return result == null ? null : result.value();
            }
            MIMEHeader result = context.parsedHeaders().findBestUserAcceptedIn(acceptableTypes, SUPPORTED);
            return result == null ? null : result.value();
        }
    }
}

