#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.42
visibility:           public
id:                   hledger-web-1.42-9Fb2dHRs5MHIFKfs6WxesX
key:                  hledger-web-1.42-9Fb2dHRs5MHIFKfs6WxesX
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  fb9ccd879767bd621aa9214c3a28afd4
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.42
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.42-9Fb2dHRs5MHIFKfs6WxesX
depends:
    Decimal-0.5.2-DeXkGpxcOYSFP5ByuNCgAq
    aeson-2.1.2.1-25X5lEqka86CxkXK2BMN9E base-4.17.2.1
    base-compat-0.14.0-D6ySGt5shRqHRPQXrHl9Oo
    base64-1.0-D4mu4WS9AGIAu890aE7NA
    blaze-html-0.9.2.0-AcUIY0JSEhx2Asds2f6X2X
    blaze-markup-0.8.3.0-65ZtuCuNbQD3EQRkgrMobs bytestring-0.11.5.3
    case-insensitive-1.2.1.0-EW9gF4gHig7HSWPJPd5ucb
    clientsession-0.9.3.0-BXWw7RMWRyF1PbraM9SeJG
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-J00hYgNuunyCAFL5MVxXYN
    conduit-extra-1.3.8-GPVjRxS109sGYDwHsMhjAb containers-0.6.7
    data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd directory-1.3.7.1
    extra-1.7.16-DedLaMdyNo8JhhbUq8RBU3 filepath-1.4.2.2
    githash-0.1.6.3-5nQf0PyKAyv5qIlWDyr7Nf
    hjsmin-0.2.1-KRBYvisItJ740L2kjhnmNu
    hledger-1.42-1Bf44kTm2sCCLkqTpC2v3M
    hledger-lib-1.42-6D2W1Q6Gwxh2rJ1bT0w89s
    hspec-2.11.1-DI30zddK0gR6BRfFwb7HtY
    http-client-0.7.19-Kz39wcB8QBJAc4yHR1PeVc
    http-conduit-2.3.9.1-9jrOaD4KMs3DpKqhiE79kU
    http-types-0.12.4-EwpVc2W1Y3M7oAuA2rwQwG
    megaparsec-9.7.0-JOqeKsXL95c1CDbf8BIVid mtl-2.2.2
    network-3.1.4.0-4q2nDdk2jYz5m5sp4PhmqQ
    safe-0.3.21-IyrA7K5ohwh1bwsZPWGLKL
    shakespeare-2.1.4-7sl7NNTl6kp9BbiHD6pu7D template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-CvhiqG4EGgD965QomVBmUt
    unordered-containers-0.2.20-DjNgsRwGYvfHy5WsKzKUzR
    utf8-string-1.0.2-9Em8uVxkJRhLhA62Ke5gub
    wai-3.2.4-Comuze1gXYWISk7kSVTjVQ
    wai-cors-0.2.7-6wGS84MZ7xFJWym1SwBMqO
    wai-extra-3.1.18-6v0GuSXVTNzCwydF3MlXZv
    wai-handler-launch-3.0.3.1-G3FKD5FkBYvJn0bx41zCvI
    warp-3.3.31-AFjtRrmm20A7xK9twGSdmw
    yaml-0.11.11.2-fHVyAj12mF6BeJWlDmLdf
    yesod-1.6.2.1-7E5vJ7rU7O2LTWlEHLQNTv
    yesod-core-1.6.27.1-BBBv8HSr0GUHNdR5iEzriI
    yesod-form-1.7.9-CjCtvLMl9Mx4ZZc9X5XF1
    yesod-static-1.6.1.0-Hsw9px9697u2lIe2o7LiLG
    yesod-test-1.6.23-G4YexracF2s12SCdP2wnit

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

