/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ant;

import groovyjarjarasm.asm.ClassReader;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.tree.AbstractInsnNode;
import groovyjarjarasm.asm.tree.ClassNode;
import groovyjarjarasm.asm.tree.MethodNode;
import groovyjarjarasm.asm.tree.analysis.Analyzer;
import groovyjarjarasm.asm.tree.analysis.Interpreter;
import groovyjarjarasm.asm.tree.analysis.SimpleVerifier;
import groovyjarjarasm.asm.util.CheckClassAdapter;
import groovyjarjarasm.asm.util.TraceMethodVisitor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class VerifyClass
extends MatchingTask {
    private String topDir = null;
    private boolean verbose = false;

    public void execute() throws BuildException {
        if (this.topDir == null) {
            throw new BuildException("no dir attribute is set");
        }
        File top = new File(this.topDir);
        if (!top.exists()) {
            throw new BuildException("the directory " + top + " does not exist");
        }
        this.log("top dir is " + top);
        int fails = this.execute(top);
        if (fails == 0) {
            this.log("no bytecode problems found");
        } else {
            this.log("found " + fails + " failing classes");
        }
    }

    public void setDir(String dir) throws BuildException {
        this.topDir = dir;
    }

    public void setVerbose(boolean v) {
        this.verbose = v;
    }

    private int execute(File dir) {
        int fails = 0;
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    fails += this.execute(f);
                    continue;
                }
                if (!f.getName().endsWith(".class")) continue;
                try {
                    boolean ok = this.readClass(f.getCanonicalPath());
                    if (ok) continue;
                    ++fails;
                }
                catch (IOException ioe) {
                    this.log(ioe.getMessage());
                    throw new BuildException((Throwable)ioe);
                }
            }
        }
        return fails;
    }

    private boolean readClass(String clazz) throws IOException {
        ClassNode ca;
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(clazz));){
            ClassReader cr = new ClassReader((InputStream)inputStream);
            ca = new ClassNode(){

                public void visitEnd() {
                }
            };
            cr.accept((ClassVisitor)new CheckClassAdapter((ClassVisitor)ca), 1);
        }
        boolean failed = false;
        List methods = ca.methods;
        for (MethodNode method : methods) {
            if (method.instructions.size() <= 0) continue;
            Analyzer a = new Analyzer((Interpreter)new SimpleVerifier());
            try {
                a.analyze(ca.name, method);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!failed) {
                    failed = true;
                    this.log("verifying of class " + clazz + " failed");
                }
                if (this.verbose) {
                    this.log(method.name + method.desc);
                }
                TraceMethodVisitor mv = new TraceMethodVisitor(null);
                for (int j = 0; j < method.instructions.size(); ++j) {
                    AbstractInsnNode insn = method.instructions.get(j);
                    if (insn != null) {
                        insn.accept((MethodVisitor)mv);
                        continue;
                    }
                    mv.visitLabel(null);
                }
                mv.visitMaxs(0, 0);
            }
        }
        return !failed;
    }
}

