/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.connectors;

import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.freeplane.core.extension.Configurable;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.features.link.ConnectorArrows;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.ConnectorShape;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinkModel;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeRelativePath;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.plugin.codeexplorer.connectors.CodeConnectorFilter;
import org.freeplane.plugin.codeexplorer.connectors.CodeConnectorModel;
import org.freeplane.plugin.codeexplorer.dependencies.CodeDependency;
import org.freeplane.plugin.codeexplorer.dependencies.DependencyVerdict;
import org.freeplane.plugin.codeexplorer.map.CodeNode;
import org.freeplane.plugin.codeexplorer.map.SelectedNodeDependencies;
import org.freeplane.view.swing.map.MapView;

public class CodeLinkController
extends LinkController {
    private static final EnumMap<DependencyVerdict, Color> connectorColors = new EnumMap(DependencyVerdict.class);
    private static final EnumMap<DependencyVerdict, Point> backwardsConnectorStartInclinations;
    private static final EnumMap<DependencyVerdict, Point> upwardsConnectorStartInclinations;
    private static final EnumMap<DependencyVerdict, Point> backwardsConnectorEndInclinations;
    private static final EnumMap<DependencyVerdict, Point> upwardsConnectorEndInclinations;
    private final CodeConnectorFilter connectorFilter = new CodeConnectorFilter();
    private ConnectorModel lastCheckedConnector = null;
    private boolean isLastCheckedConnectorSelected = false;

    public CodeLinkController(ModeController modeController) {
        super(modeController);
    }

    public Color getColor(ConnectorModel connector) {
        if (this.isConnectorSelected(connector)) {
            DependencyVerdict dependencyVerdict = ((CodeConnectorModel)connector).dependencyVerdict();
            Color color = connectorColors.get((Object)dependencyVerdict);
            return UITools.isLightLookAndFeelInstalled() ? color.darker() : color.brighter();
        }
        return this.getMapDefaultNodeTextColor(connector);
    }

    private Color getMapDefaultNodeTextColor(ConnectorModel connector) {
        return ((NodeStyleModel)MapStyleModel.getExtension((MapModel)connector.getSource().getMap()).getDefaultStyleNode().getExtension(NodeStyleModel.class)).getColor();
    }

    public int[] getDashArray(ConnectorModel connector) {
        return this.getStandardDashArray();
    }

    public int getWidth(ConnectorModel connector) {
        CodeConnectorModel codeConnector = (CodeConnectorModel)connector;
        return codeConnector.dependencyVerdict() != DependencyVerdict.IGNORED && this.isConnectorSelected(codeConnector) ? 1 + (int)(3.0 * Math.log10(codeConnector.weight())) : 1;
    }

    public int getOpacity(ConnectorModel connector) {
        CodeConnectorModel codeConnector = (CodeConnectorModel)connector;
        return codeConnector.dependencyVerdict() != DependencyVerdict.IGNORED && this.isConnectorSelected(codeConnector) ? 128 : 30;
    }

    public String getMiddleLabel(ConnectorModel connector) {
        return this.isConnectorSelected(connector) ? Integer.toString(((CodeConnectorModel)connector).weight()) : "";
    }

    private boolean isConnectorSelected(ConnectorModel connector) {
        if (this.lastCheckedConnector == connector) {
            return this.isLastCheckedConnectorSelected;
        }
        this.lastCheckedConnector = null;
        Controller controller = Controller.getCurrentController();
        if (controller.getModeController().getModeName() != "CodeExplorer") {
            return false;
        }
        IMapSelection selection = controller.getSelection();
        if (selection == null) {
            return false;
        }
        this.lastCheckedConnector = connector;
        if (this.connectorFilter.isActive()) {
            this.isLastCheckedConnectorSelected = this.connectorFilter.isFiltered((CodeConnectorModel)connector);
            return this.isLastCheckedConnectorSelected;
        }
        this.isLastCheckedConnectorSelected = this.isConnectorSelected((CodeConnectorModel)connector, selection);
        return this.isLastCheckedConnectorSelected;
    }

    private boolean isConnectorSelected(CodeConnectorModel connector, IMapSelection selection) {
        CodeNode source = connector.getSource();
        CodeNode target = connector.getTarget();
        boolean connectorSelected = new SelectedNodeDependencies(selection).isConnectorSelected(source, target);
        return connectorSelected;
    }

    public String getSourceLabel(ConnectorModel connector) {
        return "";
    }

    public String getTargetLabel(ConnectorModel connector) {
        return "";
    }

    public String getLabelFontFamily(ConnectorModel connector) {
        return this.getStandardLabelFontFamily();
    }

    public int getLabelFontSize(ConnectorModel connector) {
        return 8;
    }

    public int getLabelFontStyle(ConnectorModel connector) {
        return 1;
    }

    public Color getLabelColor(ConnectorModel connector) {
        return this.getMapDefaultNodeTextColor(connector);
    }

    public ConnectorShape getShape(ConnectorModel connector) {
        return ConnectorShape.CUBIC_CURVE;
    }

    public ConnectorArrows getArrows(ConnectorModel connector) {
        return this.isConnectorSelected(connector) ? ConnectorArrows.FORWARD : ConnectorArrows.NONE;
    }

    public String getLinkShortText(NodeModel node) {
        return null;
    }

    public boolean hasNodeLinks(MapModel map, JComponent component) {
        return true;
    }

    public Collection<? extends NodeLinkModel> getLinksTo(NodeModel node, Configurable component) {
        IMapSelection selection = ((MapView)component).getMapSelection();
        if (node.isLeaf() || selection.isFolded(node)) {
            SelectedNodeDependencies selectedNodeDependencies = new SelectedNodeDependencies(selection);
            CodeNode codeNode = (CodeNode)node;
            Stream<CodeDependency> codeDependencies = codeNode.incomingCodeDependenciesWithKnownOrigins().filter(dep -> selectedNodeDependencies.getVisibleNode(dep.getTargetClass()) != null);
            Map<DependencyVerdict, Map<CodeNode, Long>> countedDependencies = this.countCodeDependencies(codeNode, selectedNodeDependencies, codeDependencies, CodeDependency::getOriginClass);
            List connectors = countedDependencies.entrySet().stream().flatMap(targetsByVerdict -> ((Map)targetsByVerdict.getValue()).entrySet().stream().map(countedTargets -> this.createConnector((CodeNode)((Object)((Object)((Object)countedTargets.getKey()))), node.getID(), (DependencyVerdict)((Object)((Object)((Object)targetsByVerdict.getKey()))), ((Long)countedTargets.getValue()).intValue()))).collect(Collectors.toList());
            return connectors;
        }
        return Collections.emptyList();
    }

    public Collection<? extends NodeLinkModel> getLinksFrom(NodeModel node, Configurable component) {
        IMapSelection selection = ((MapView)component).getMapSelection();
        if (node.isLeaf() || selection.isFolded(node)) {
            SelectedNodeDependencies selectedNodeDependencies = new SelectedNodeDependencies(selection);
            CodeNode codeNode = (CodeNode)node;
            Stream<CodeDependency> codeDependencies = codeNode.outgoingCodeDependenciesWithKnownTargets().filter(dep -> selectedNodeDependencies.getVisibleNode(dep.getOriginClass()) != null);
            Map<DependencyVerdict, Map<CodeNode, Long>> countedDependencies = this.countCodeDependencies(codeNode, selectedNodeDependencies, codeDependencies, CodeDependency::getTargetClass);
            List connectors = countedDependencies.entrySet().stream().flatMap(targetsByVerdict -> ((Map)targetsByVerdict.getValue()).entrySet().stream().map(countedTargets -> this.createConnector(codeNode, ((CodeNode)((Object)((Object)((Object)countedTargets.getKey())))).getID(), (DependencyVerdict)((Object)((Object)((Object)targetsByVerdict.getKey()))), ((Long)countedTargets.getValue()).intValue()))).collect(Collectors.toList());
            return connectors;
        }
        return Collections.emptyList();
    }

    private Map<DependencyVerdict, Map<CodeNode, Long>> countCodeDependencies(CodeNode node, SelectedNodeDependencies selectedNodeDependencies, Stream<CodeDependency> codeDependencies, Function<CodeDependency, JavaClass> dependencyToJavaClass) {
        Map<DependencyVerdict, Map<CodeNode, Long>> countedDependencies = codeDependencies.map(dep -> new AbstractMap.SimpleEntry<DependencyVerdict, CodeNode>(dep.dependencyVerdict(), selectedNodeDependencies.getVisibleNode((JavaClass)dependencyToJavaClass.apply((CodeDependency)dep)))).filter(e -> e.getValue() != null && !((Object)((Object)((CodeNode)((Object)((Object)e.getValue()))))).equals((Object)node)).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.groupingBy(Map.Entry::getValue, Collectors.counting())));
        return countedDependencies;
    }

    public Component getPopupForModel(Object obj) {
        if (obj instanceof CodeConnectorModel) {
            return new JLabel("To be done");
        }
        return null;
    }

    public Icon getLinkIcon(Hyperlink link, NodeModel model) {
        return null;
    }

    public Point getStartInclination(ConnectorModel connector) {
        CodeConnectorModel codeConnector = (CodeConnectorModel)connector;
        return (codeConnector.goesUp() ? upwardsConnectorStartInclinations : backwardsConnectorStartInclinations).get((Object)codeConnector.dependencyVerdict());
    }

    public Point getEndInclination(ConnectorModel connector) {
        CodeConnectorModel codeConnector = (CodeConnectorModel)connector;
        return (codeConnector.goesUp() ? upwardsConnectorEndInclinations : backwardsConnectorEndInclinations).get((Object)codeConnector.dependencyVerdict());
    }

    private CodeConnectorModel createConnector(CodeNode source, String targetId, DependencyVerdict verdict, int weight) {
        NodeModel target = source.getMap().getNodeForID(targetId);
        NodeRelativePath nodeRelativePath = new NodeRelativePath((NodeModel)source, target);
        boolean goesUp = nodeRelativePath.compareNodePositions() > 0;
        return new CodeConnectorModel(source, targetId, weight, verdict, goesUp);
    }

    public void updateFilteredDependencies(Set<Dependency> filteredDependencies) {
        this.lastCheckedConnector = null;
        this.isLastCheckedConnectorSelected = false;
        this.connectorFilter.setFilteredDependencies(filteredDependencies);
    }

    static {
        connectorColors.put(DependencyVerdict.ALLOWED, Color.GREEN);
        connectorColors.put(DependencyVerdict.FORBIDDEN, Color.RED);
        connectorColors.put(DependencyVerdict.IGNORED, Color.GRAY);
        backwardsConnectorStartInclinations = new EnumMap(DependencyVerdict.class);
        backwardsConnectorStartInclinations.put(DependencyVerdict.ALLOWED, new Point(150, 5));
        backwardsConnectorStartInclinations.put(DependencyVerdict.FORBIDDEN, new Point(200, 5));
        backwardsConnectorStartInclinations.put(DependencyVerdict.IGNORED, new Point(250, 5));
        upwardsConnectorStartInclinations = new EnumMap(DependencyVerdict.class);
        backwardsConnectorEndInclinations = new EnumMap(DependencyVerdict.class);
        upwardsConnectorEndInclinations = new EnumMap(DependencyVerdict.class);
        for (Map.Entry<DependencyVerdict, Point> entry : backwardsConnectorStartInclinations.entrySet()) {
            DependencyVerdict verdict = entry.getKey();
            Point backwardsConnectorStartInclination = entry.getValue();
            Point upwardsConnectorStartInclination = new Point(-backwardsConnectorStartInclination.x, -backwardsConnectorStartInclination.y);
            Point backwardsConnectorEndInclination = new Point(backwardsConnectorStartInclination.x, -backwardsConnectorStartInclination.y);
            Point upwardsConnectorEndInclination = new Point(upwardsConnectorStartInclination.x, -upwardsConnectorStartInclination.y);
            upwardsConnectorStartInclinations.put(verdict, upwardsConnectorStartInclination);
            backwardsConnectorEndInclinations.put(verdict, backwardsConnectorEndInclination);
            upwardsConnectorEndInclinations.put(verdict, upwardsConnectorEndInclination);
        }
    }
}

