/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.AllValue;
import net.sf.jsqlparser.expression.AnalyticExpression;
import net.sf.jsqlparser.expression.AnalyticType;
import net.sf.jsqlparser.expression.AnyComparisonExpression;
import net.sf.jsqlparser.expression.ArrayConstructor;
import net.sf.jsqlparser.expression.ArrayExpression;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.BooleanValue;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.CastExpression;
import net.sf.jsqlparser.expression.CollateExpression;
import net.sf.jsqlparser.expression.ConnectByPriorOperator;
import net.sf.jsqlparser.expression.ConnectByRootOperator;
import net.sf.jsqlparser.expression.DateTimeLiteralExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExtractExpression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.HexValue;
import net.sf.jsqlparser.expression.HighExpression;
import net.sf.jsqlparser.expression.IntervalExpression;
import net.sf.jsqlparser.expression.Inverse;
import net.sf.jsqlparser.expression.JdbcNamedParameter;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.JsonAggregateFunction;
import net.sf.jsqlparser.expression.JsonExpression;
import net.sf.jsqlparser.expression.JsonFunction;
import net.sf.jsqlparser.expression.KeepExpression;
import net.sf.jsqlparser.expression.LambdaExpression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.LowExpression;
import net.sf.jsqlparser.expression.MySQLGroupConcat;
import net.sf.jsqlparser.expression.NextValExpression;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.NumericBind;
import net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import net.sf.jsqlparser.expression.OracleHint;
import net.sf.jsqlparser.expression.OracleNamedFunctionParameter;
import net.sf.jsqlparser.expression.OverlapsCondition;
import net.sf.jsqlparser.expression.RangeExpression;
import net.sf.jsqlparser.expression.RowConstructor;
import net.sf.jsqlparser.expression.RowGetExpression;
import net.sf.jsqlparser.expression.SignedExpression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.StructType;
import net.sf.jsqlparser.expression.TimeKeyExpression;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.TimezoneExpression;
import net.sf.jsqlparser.expression.TranscodingFunction;
import net.sf.jsqlparser.expression.TrimFunction;
import net.sf.jsqlparser.expression.UserVariable;
import net.sf.jsqlparser.expression.VariableAssignment;
import net.sf.jsqlparser.expression.WhenClause;
import net.sf.jsqlparser.expression.WindowElement;
import net.sf.jsqlparser.expression.XMLSerializeExpr;
import net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseLeftShift;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseRightShift;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import net.sf.jsqlparser.expression.operators.arithmetic.Concat;
import net.sf.jsqlparser.expression.operators.arithmetic.Division;
import net.sf.jsqlparser.expression.operators.arithmetic.IntegerDivision;
import net.sf.jsqlparser.expression.operators.arithmetic.Modulo;
import net.sf.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.conditional.XorExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.ContainedBy;
import net.sf.jsqlparser.expression.operators.relational.Contains;
import net.sf.jsqlparser.expression.operators.relational.CosineSimilarity;
import net.sf.jsqlparser.expression.operators.relational.DoubleAnd;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExcludesExpression;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.FullTextSearch;
import net.sf.jsqlparser.expression.operators.relational.GeometryDistance;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IncludesExpression;
import net.sf.jsqlparser.expression.operators.relational.IsBooleanExpression;
import net.sf.jsqlparser.expression.operators.relational.IsDistinctExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.IsUnknownExpression;
import net.sf.jsqlparser.expression.operators.relational.JsonOperator;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.Matches;
import net.sf.jsqlparser.expression.operators.relational.MemberOfExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.expression.operators.relational.OldOracleJoinBinaryExpression;
import net.sf.jsqlparser.expression.operators.relational.Plus;
import net.sf.jsqlparser.expression.operators.relational.PriorTo;
import net.sf.jsqlparser.expression.operators.relational.RegExpMatchOperator;
import net.sf.jsqlparser.expression.operators.relational.SimilarToExpression;
import net.sf.jsqlparser.expression.operators.relational.TSQLLeftJoin;
import net.sf.jsqlparser.expression.operators.relational.TSQLRightJoin;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.create.table.ColDataType;
import net.sf.jsqlparser.statement.piped.FromQuery;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FunctionAllColumns;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;
import net.sf.jsqlparser.util.deparser.ExpressionListDeParser;
import net.sf.jsqlparser.util.deparser.LimitDeparser;
import net.sf.jsqlparser.util.deparser.OrderByDeParser;

public class ExpressionDeParser
extends AbstractDeParser<Expression>
implements ExpressionVisitor<StringBuilder> {
    private static final String NOT = "NOT ";
    private SelectVisitor<StringBuilder> selectVisitor;
    private OrderByDeParser orderByDeParser = new OrderByDeParser();

    public ExpressionDeParser() {
        super(new StringBuilder());
    }

    public ExpressionDeParser(SelectVisitor<StringBuilder> selectVisitor, StringBuilder buffer) {
        this(selectVisitor, buffer, new OrderByDeParser());
    }

    ExpressionDeParser(SelectVisitor<StringBuilder> selectVisitor, StringBuilder buffer, OrderByDeParser orderByDeParser) {
        super(buffer);
        this.selectVisitor = selectVisitor;
        this.orderByDeParser = orderByDeParser;
    }

    @Override
    public <S> StringBuilder visit(Addition addition, S context) {
        this.deparse(addition, " + ", null);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(AndExpression andExpression, S context) {
        this.deparse(andExpression, andExpression.isUseOperator() ? " && " : " AND ", null);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Between between, S context) {
        between.getLeftExpression().accept(this, context);
        if (between.isNot()) {
            this.builder.append(" NOT");
        }
        this.builder.append(" BETWEEN ");
        between.getBetweenExpressionStart().accept(this, context);
        this.builder.append(" AND ");
        between.getBetweenExpressionEnd().accept(this, context);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(OverlapsCondition overlapsCondition, S context) {
        this.builder.append(overlapsCondition.toString());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(EqualsTo equalsTo, S context) {
        this.deparse(equalsTo, " = ", null);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Division division, S context) {
        this.deparse(division, " / ", null);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(IntegerDivision division, S context) {
        this.deparse(division, " DIV ", null);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(DoubleValue doubleValue, S context) {
        this.builder.append(doubleValue.toString());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(HexValue hexValue, S context) {
        this.builder.append(hexValue.toString());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(NotExpression notExpr, S context) {
        if (notExpr.isExclamationMark()) {
            this.builder.append("! ");
        } else {
            this.builder.append(NOT);
        }
        notExpr.getExpression().accept(this, context);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(BitwiseRightShift expr, S context) {
        this.deparse(expr, " >> ", null);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(BitwiseLeftShift expr, S context) {
        this.deparse(expr, " << ", null);
        return this.builder;
    }

    public <S> StringBuilder deparse(OldOracleJoinBinaryExpression expression, String operator, S context) {
        expression.getLeftExpression().accept(this, context);
        if (expression.getOldOracleJoinSyntax() == 1) {
            this.builder.append("(+)");
        }
        this.builder.append(operator);
        expression.getRightExpression().accept(this, context);
        if (expression.getOldOracleJoinSyntax() == 2) {
            this.builder.append("(+)");
        }
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(GreaterThan greaterThan, S context) {
        this.deparse(greaterThan, " > ", null);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(GreaterThanEquals greaterThanEquals, S context) {
        this.deparse(greaterThanEquals, " >= ", null);
        return this.builder;
    }

    @Override
    public void visit(Addition addition) {
        this.visit(addition, (Object)null);
    }

    @Override
    public void visit(AndExpression andExpression) {
        this.visit(andExpression, (Object)null);
    }

    @Override
    public void visit(Between between) {
        this.visit(between, (Object)null);
    }

    @Override
    public void visit(OverlapsCondition overlapsCondition) {
        this.visit(overlapsCondition, (Object)null);
    }

    @Override
    public void visit(EqualsTo equalsTo) {
        this.visit(equalsTo, (Object)null);
    }

    @Override
    public void visit(Division division) {
        this.visit(division, (Object)null);
    }

    @Override
    public void visit(IntegerDivision division) {
        this.visit(division, (Object)null);
    }

    @Override
    public void visit(DoubleValue doubleValue) {
        this.visit(doubleValue, (Object)null);
    }

    @Override
    public void visit(HexValue hexValue) {
        this.visit(hexValue, (Object)null);
    }

    @Override
    public void visit(NotExpression notExpr) {
        this.visit(notExpr, (Object)null);
    }

    @Override
    public void visit(BitwiseRightShift expr) {
        this.visit(expr, (Object)null);
    }

    @Override
    public void visit(BitwiseLeftShift expr) {
        this.visit(expr, (Object)null);
    }

    @Override
    public <S> StringBuilder visit(InExpression inExpression, S context) {
        inExpression.getLeftExpression().accept(this, context);
        if (inExpression.getOldOracleJoinSyntax() == 1) {
            this.builder.append("(+)");
        }
        if (inExpression.isGlobal()) {
            this.builder.append(" GLOBAL");
        }
        if (inExpression.isNot()) {
            this.builder.append(" NOT");
        }
        this.builder.append(" IN ");
        inExpression.getRightExpression().accept(this, context);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(IncludesExpression includesExpression, S context) {
        includesExpression.getLeftExpression().accept(this, context);
        this.builder.append(" INCLUDES ");
        includesExpression.getRightExpression().accept(this, context);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(ExcludesExpression excludesExpression, S context) {
        excludesExpression.getLeftExpression().accept(this, context);
        this.builder.append(" EXCLUDES ");
        excludesExpression.getRightExpression().accept(this, context);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(FullTextSearch fullTextSearch, S context) {
        StringBuilder columnsListCommaSeperated = new StringBuilder();
        Iterator iterator = fullTextSearch.getMatchColumns().iterator();
        while (iterator.hasNext()) {
            Column col = (Column)iterator.next();
            columnsListCommaSeperated.append(col.getFullyQualifiedName());
            if (!iterator.hasNext()) continue;
            columnsListCommaSeperated.append(",");
        }
        this.builder.append("MATCH (").append((CharSequence)columnsListCommaSeperated).append(") AGAINST (").append(fullTextSearch.getAgainstValue()).append((String)(fullTextSearch.getSearchModifier() != null ? " " + fullTextSearch.getSearchModifier() : "")).append(")");
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(SignedExpression signedExpression, S context) {
        this.builder.append(signedExpression.getSign());
        signedExpression.getExpression().accept(this, context);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(IsNullExpression isNullExpression, S context) {
        isNullExpression.getLeftExpression().accept(this, context);
        if (isNullExpression.isUseNotNull()) {
            this.builder.append(" NOTNULL");
        } else if (isNullExpression.isUseIsNull()) {
            if (isNullExpression.isNot()) {
                this.builder.append(" NOT ISNULL");
            } else {
                this.builder.append(" ISNULL");
            }
        } else if (isNullExpression.isNot()) {
            this.builder.append(" IS NOT NULL");
        } else {
            this.builder.append(" IS NULL");
        }
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(IsBooleanExpression isBooleanExpression, S context) {
        isBooleanExpression.getLeftExpression().accept(this, context);
        if (isBooleanExpression.isTrue()) {
            if (isBooleanExpression.isNot()) {
                this.builder.append(" IS NOT TRUE");
            } else {
                this.builder.append(" IS TRUE");
            }
        } else if (isBooleanExpression.isNot()) {
            this.builder.append(" IS NOT FALSE");
        } else {
            this.builder.append(" IS FALSE");
        }
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(IsUnknownExpression isUnknownExpression, S context) {
        isUnknownExpression.getLeftExpression().accept(this, context);
        if (isUnknownExpression.isNot()) {
            this.builder.append(" IS NOT UNKNOWN");
        } else {
            this.builder.append(" IS UNKNOWN");
        }
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(JdbcParameter jdbcParameter, S context) {
        this.builder.append(jdbcParameter.getParameterCharacter());
        if (jdbcParameter.isUseFixedIndex()) {
            this.builder.append(jdbcParameter.getIndex());
        }
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(LikeExpression likeExpression, S context) {
        String keywordStr = likeExpression.getLikeKeyWord() == LikeExpression.KeyWord.SIMILAR_TO ? " SIMILAR TO" : likeExpression.getLikeKeyWord().toString();
        likeExpression.getLeftExpression().accept(this, context);
        this.builder.append(" ");
        if (likeExpression.isNot()) {
            this.builder.append(NOT);
        }
        this.builder.append(keywordStr).append(" ");
        if (likeExpression.isUseBinary()) {
            this.builder.append("BINARY ");
        }
        likeExpression.getRightExpression().accept(this, context);
        Expression escape = likeExpression.getEscape();
        if (escape != null) {
            this.builder.append(" ESCAPE ");
            likeExpression.getEscape().accept(this, context);
        }
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(ExistsExpression existsExpression, S context) {
        if (existsExpression.isNot()) {
            this.builder.append("NOT EXISTS ");
        } else {
            this.builder.append("EXISTS ");
        }
        existsExpression.getRightExpression().accept(this, context);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(MemberOfExpression memberOfExpression, S context) {
        memberOfExpression.getLeftExpression().accept(this, context);
        if (memberOfExpression.isNot()) {
            this.builder.append(" NOT MEMBER OF ");
        } else {
            this.builder.append(" MEMBER OF ");
        }
        memberOfExpression.getRightExpression().accept(this, context);
        return this.builder;
    }

    @Override
    public void visit(InExpression inExpression) {
        this.visit(inExpression, (Object)null);
    }

    @Override
    public void visit(IncludesExpression includesExpression) {
        this.visit(includesExpression, (Object)null);
    }

    @Override
    public void visit(ExcludesExpression excludesExpression) {
        this.visit(excludesExpression, (Object)null);
    }

    @Override
    public void visit(FullTextSearch fullTextSearch) {
        this.visit(fullTextSearch, (Object)null);
    }

    @Override
    public void visit(SignedExpression signedExpression) {
        this.visit(signedExpression, (Object)null);
    }

    @Override
    public void visit(IsNullExpression isNullExpression) {
        this.visit(isNullExpression, (Object)null);
    }

    @Override
    public void visit(IsBooleanExpression isBooleanExpression) {
        this.visit(isBooleanExpression, (Object)null);
    }

    @Override
    public void visit(IsUnknownExpression isUnknownExpression) {
        this.visit(isUnknownExpression, (Object)null);
    }

    @Override
    public void visit(JdbcParameter jdbcParameter) {
        this.visit(jdbcParameter, (Object)null);
    }

    @Override
    public void visit(LikeExpression likeExpression) {
        this.visit(likeExpression, (Object)null);
    }

    @Override
    public void visit(ExistsExpression existsExpression) {
        this.visit(existsExpression, (Object)null);
    }

    @Override
    public void visit(MemberOfExpression memberOfExpression) {
        this.visit(memberOfExpression, (Object)null);
    }

    @Override
    public <S> StringBuilder visit(LongValue longValue, S context) {
        this.builder.append(longValue.getStringValue());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(MinorThan minorThan, S context) {
        this.deparse(minorThan, " < ", null);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(MinorThanEquals minorThanEquals, S context) {
        this.deparse(minorThanEquals, " <= ", null);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Multiplication multiplication, S context) {
        this.deparse(multiplication, " * ", null);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(NotEqualsTo notEqualsTo, S context) {
        this.deparse(notEqualsTo, " " + notEqualsTo.getStringExpression() + " ", null);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(DoubleAnd doubleAnd, S context) {
        this.deparse(doubleAnd, " " + doubleAnd.getStringExpression() + " ", null);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Contains contains, S context) {
        this.deparse(contains, " " + contains.getStringExpression() + " ", null);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(ContainedBy containedBy, S context) {
        this.deparse(containedBy, " " + containedBy.getStringExpression() + " ", null);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(NullValue nullValue, S context) {
        this.builder.append(nullValue.toString());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(OrExpression orExpression, S context) {
        this.deparse(orExpression, " OR ", null);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(XorExpression xorExpression, S context) {
        this.deparse(xorExpression, " XOR ", null);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(StringValue stringValue, S context) {
        if (stringValue.getPrefix() != null) {
            this.builder.append(stringValue.getPrefix());
        }
        this.builder.append("'").append(stringValue.getValue()).append("'");
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(BooleanValue booleanValue, S context) {
        this.builder.append(booleanValue.getValue());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Subtraction subtraction, S context) {
        this.deparse(subtraction, " - ", null);
        return this.builder;
    }

    protected <S> void deparse(BinaryExpression binaryExpression, String operator, S context) {
        binaryExpression.getLeftExpression().accept(this, context);
        this.builder.append(operator);
        binaryExpression.getRightExpression().accept(this, context);
    }

    @Override
    public <S> StringBuilder visit(Select select, S context) {
        if (this.selectVisitor != null) {
            if (select.getWithItemsList() != null) {
                this.builder.append("WITH ");
                Iterator<WithItem<?>> iter = select.getWithItemsList().iterator();
                while (iter.hasNext()) {
                    iter.next().accept(this.selectVisitor, null);
                    if (iter.hasNext()) {
                        this.builder.append(", ");
                    }
                    this.builder.append(" ");
                }
                this.builder.append(" ");
            }
            select.accept(this.selectVisitor, null);
        }
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(TranscodingFunction transcodingFunction, S context) {
        if (transcodingFunction.isTranscodeStyle()) {
            this.builder.append("CONVERT( ");
            transcodingFunction.getExpression().accept(this, context);
            this.builder.append(" USING ").append(transcodingFunction.getTranscodingName()).append(" )");
        } else {
            this.builder.append("CONVERT( ").append(transcodingFunction.getColDataType()).append(", ");
            transcodingFunction.getExpression().accept(this, context);
            String transCodingName = transcodingFunction.getTranscodingName();
            if (transCodingName != null && !transCodingName.isEmpty()) {
                this.builder.append(", ").append(transCodingName);
            }
            this.builder.append(" )");
        }
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(TrimFunction trimFunction, S context) {
        this.builder.append("Trim(");
        if (trimFunction.getTrimSpecification() != null) {
            this.builder.append(" ").append((Object)trimFunction.getTrimSpecification());
        }
        if (trimFunction.getExpression() != null) {
            this.builder.append(" ");
            trimFunction.getExpression().accept(this, context);
        }
        if (trimFunction.getFromExpression() != null) {
            this.builder.append(trimFunction.isUsingFromKeyword() ? " FROM " : ", ");
            trimFunction.getFromExpression().accept(this, context);
        }
        this.builder.append(" )");
        return this.builder;
    }

    @Override
    public void visit(LongValue longValue) {
        this.visit(longValue, (Object)null);
    }

    @Override
    public void visit(MinorThan minorThan) {
        this.visit(minorThan, (Object)null);
    }

    @Override
    public void visit(MinorThanEquals minorThanEquals) {
        this.visit(minorThanEquals, (Object)null);
    }

    @Override
    public void visit(Multiplication multiplication) {
        this.visit(multiplication, (Object)null);
    }

    @Override
    public void visit(NotEqualsTo notEqualsTo) {
        this.visit(notEqualsTo, (Object)null);
    }

    @Override
    public void visit(DoubleAnd doubleAnd) {
        this.visit(doubleAnd, (Object)null);
    }

    @Override
    public void visit(Contains contains) {
        this.visit(contains, (Object)null);
    }

    @Override
    public void visit(ContainedBy containedBy) {
        this.visit(containedBy, (Object)null);
    }

    @Override
    public void visit(NullValue nullValue) {
        this.visit(nullValue, (Object)null);
    }

    @Override
    public void visit(OrExpression orExpression) {
        this.visit(orExpression, (Object)null);
    }

    @Override
    public void visit(XorExpression xorExpression) {
        this.visit(xorExpression, (Object)null);
    }

    @Override
    public void visit(StringValue stringValue) {
        this.visit(stringValue, (Object)null);
    }

    @Override
    public void visit(BooleanValue booleanValue) {
        this.visit(booleanValue, (Object)null);
    }

    @Override
    public void visit(Subtraction subtraction) {
        this.visit(subtraction, (Object)null);
    }

    public void visit(Select select) {
        this.visit(select, (Object)null);
    }

    @Override
    public void visit(TranscodingFunction transcodingFunction) {
        this.visit(transcodingFunction, (Object)null);
    }

    @Override
    public void visit(TrimFunction trimFunction) {
        this.visit(trimFunction, (Object)null);
    }

    @Override
    public <S> StringBuilder visit(RangeExpression rangeExpression, S context) {
        rangeExpression.getStartExpression().accept(this, context);
        this.builder.append(":");
        rangeExpression.getEndExpression().accept(this, context);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Column tableColumn, S context) {
        Table table = tableColumn.getTable();
        String tableName = null;
        if (table != null) {
            tableName = table.getAlias() != null ? table.getAlias().getName() : table.getFullyQualifiedName();
        }
        if (tableName != null && !tableName.isEmpty()) {
            this.builder.append(tableName).append(tableColumn.getTableDelimiter());
        }
        this.builder.append(tableColumn.getColumnName());
        if (tableColumn.getArrayConstructor() != null) {
            tableColumn.getArrayConstructor().accept(this, context);
        }
        if (tableColumn.getCommentText() != null) {
            this.builder.append(" /* ").append(tableColumn.getCommentText()).append("*/ ");
        }
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Function function, S context) {
        if (function.isEscaped()) {
            this.builder.append("{fn ");
        }
        this.builder.append(function.getName());
        if (function.getParameters() == null && function.getNamedParameters() == null) {
            this.builder.append("()");
        } else {
            Function.HavingClause havingClause;
            this.builder.append("(");
            if (function.isDistinct()) {
                this.builder.append("DISTINCT ");
            } else if (function.isAllColumns()) {
                this.builder.append("ALL ");
            } else if (function.isUnique()) {
                this.builder.append("UNIQUE ");
            }
            if (function.getExtraKeyword() != null) {
                this.builder.append(function.getExtraKeyword()).append(" ");
            }
            if (function.getNamedParameters() != null) {
                function.getNamedParameters().accept(this, context);
            }
            if (function.getParameters() != null) {
                function.getParameters().accept(this, context);
            }
            if ((havingClause = function.getHavingClause()) != null) {
                this.builder.append(" HAVING ").append((Object)havingClause.getHavingType()).append(" ");
                havingClause.getExpression().accept(this, context);
            }
            if (function.getNullHandling() != null && !function.isIgnoreNullsOutside()) {
                switch (function.getNullHandling()) {
                    case IGNORE_NULLS: {
                        this.builder.append(" IGNORE NULLS");
                        break;
                    }
                    case RESPECT_NULLS: {
                        this.builder.append(" RESPECT NULLS");
                    }
                }
            }
            if (function.getOrderByElements() != null) {
                this.builder.append(" ORDER BY ");
                boolean comma = false;
                this.orderByDeParser.setExpressionVisitor(this);
                this.orderByDeParser.setBuilder(this.builder);
                for (OrderByElement orderByElement : function.getOrderByElements()) {
                    if (comma) {
                        this.builder.append(", ");
                    } else {
                        comma = true;
                    }
                    this.orderByDeParser.deParseElement(orderByElement);
                }
            }
            if (function.getOnOverflowTruncate() != null) {
                this.builder.append(" ON OVERFLOW ").append(function.getOnOverflowTruncate());
            }
            if (function.getLimit() != null) {
                new LimitDeparser(this, this.builder).deParse(function.getLimit());
            }
            this.builder.append(")");
        }
        if (function.getNullHandling() != null && function.isIgnoreNullsOutside()) {
            switch (function.getNullHandling()) {
                case IGNORE_NULLS: {
                    this.builder.append(" IGNORE NULLS");
                    break;
                }
                case RESPECT_NULLS: {
                    this.builder.append(" RESPECT NULLS");
                }
            }
        }
        if (function.getAttribute() != null) {
            this.builder.append(".").append(function.getAttribute());
        }
        if (function.getKeep() != null) {
            this.builder.append(" ").append(function.getKeep());
        }
        if (function.isEscaped()) {
            this.builder.append("}");
        }
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(ParenthesedSelect selectBody, S context) {
        selectBody.getSelect().accept(this, context);
        return this.builder;
    }

    public SelectVisitor<StringBuilder> getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setSelectVisitor(SelectVisitor<StringBuilder> visitor) {
        this.selectVisitor = visitor;
    }

    @Override
    public <S> StringBuilder visit(DateValue dateValue, S context) {
        this.builder.append("{d '").append(dateValue.getValue().toString()).append("'}");
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(TimestampValue timestampValue, S context) {
        this.builder.append("{ts '").append(timestampValue.getValue().toString()).append("'}");
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(TimeValue timeValue, S context) {
        this.builder.append("{t '").append(timeValue.getValue().toString()).append("'}");
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(CaseExpression caseExpression, S context) {
        this.builder.append(caseExpression.isUsingBrackets() ? "(" : "").append("CASE ");
        Expression switchExp = caseExpression.getSwitchExpression();
        if (switchExp != null) {
            switchExp.accept(this, context);
            this.builder.append(" ");
        }
        for (Expression expression : caseExpression.getWhenClauses()) {
            expression.accept(this, context);
        }
        Expression elseExp = caseExpression.getElseExpression();
        if (elseExp != null) {
            this.builder.append("ELSE ");
            elseExp.accept(this, context);
            this.builder.append(" ");
        }
        this.builder.append("END").append(caseExpression.isUsingBrackets() ? ")" : "");
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(WhenClause whenClause, S context) {
        this.builder.append("WHEN ");
        whenClause.getWhenExpression().accept(this, context);
        this.builder.append(" THEN ");
        whenClause.getThenExpression().accept(this, context);
        this.builder.append(" ");
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(AnyComparisonExpression anyComparisonExpression, S context) {
        this.builder.append(anyComparisonExpression.getAnyType().name());
        anyComparisonExpression.getSelect().accept(this, context);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Concat concat, S context) {
        this.deparse(concat, " || ", null);
        return this.builder;
    }

    @Override
    public void visit(RangeExpression rangeExpression) {
        this.visit(rangeExpression, (Object)null);
    }

    @Override
    public void visit(Column tableColumn) {
        this.visit(tableColumn, (Object)null);
    }

    @Override
    public void visit(Function function) {
        this.visit(function, (Object)null);
    }

    public void visit(ParenthesedSelect selectBody) {
        this.visit(selectBody, (Object)null);
    }

    @Override
    public void visit(DateValue dateValue) {
        this.visit(dateValue, (Object)null);
    }

    @Override
    public void visit(TimestampValue timestampValue) {
        this.visit(timestampValue, (Object)null);
    }

    @Override
    public void visit(TimeValue timeValue) {
        this.visit(timeValue, (Object)null);
    }

    @Override
    public void visit(CaseExpression caseExpression) {
        this.visit(caseExpression, (Object)null);
    }

    @Override
    public void visit(WhenClause whenClause) {
        this.visit(whenClause, (Object)null);
    }

    @Override
    public void visit(AnyComparisonExpression anyComparisonExpression) {
        this.visit(anyComparisonExpression, (Object)null);
    }

    @Override
    public void visit(Concat concat) {
        this.visit(concat, (Object)null);
    }

    @Override
    public <S> StringBuilder visit(Matches matches, S context) {
        this.deparse(matches, " @@ ", null);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(BitwiseAnd bitwiseAnd, S context) {
        this.deparse(bitwiseAnd, " & ", null);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(BitwiseOr bitwiseOr, S context) {
        this.deparse(bitwiseOr, " | ", null);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(BitwiseXor bitwiseXor, S context) {
        this.deparse(bitwiseXor, " ^ ", null);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(CastExpression cast, S context) {
        if (cast.isImplicitCast()) {
            this.builder.append(cast.getColDataType()).append(" ");
            cast.getLeftExpression().accept(this, context);
        } else if (cast.isUseCastKeyword()) {
            String formatStr = cast.getFormat() != null && !cast.getFormat().isEmpty() ? " FORMAT " + cast.getFormat() : "";
            this.builder.append(cast.keyword).append("(");
            cast.getLeftExpression().accept(this, context);
            this.builder.append(" AS ");
            this.builder.append((String)(cast.getColumnDefinitions().size() > 1 ? "ROW(" + Select.getStringList(cast.getColumnDefinitions()) + ")" : cast.getColDataType().toString()));
            this.builder.append(formatStr);
            this.builder.append(")");
        } else {
            cast.getLeftExpression().accept(this, context);
            this.builder.append("::");
            this.builder.append(cast.getColDataType());
        }
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Modulo modulo, S context) {
        this.deparse(modulo, " % ", null);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(AnalyticExpression analyticExpression, S context) {
        Function.HavingClause havingClause;
        String name = analyticExpression.getName();
        Expression expression = analyticExpression.getExpression();
        Expression offset = analyticExpression.getOffset();
        Expression defaultValue = analyticExpression.getDefaultValue();
        boolean isAllColumns = analyticExpression.isAllColumns();
        KeepExpression keep = analyticExpression.getKeep();
        ExpressionList<?> partitionExpressionList = analyticExpression.getPartitionExpressionList();
        List<OrderByElement> orderByElements = analyticExpression.getOrderByElements();
        WindowElement windowElement = analyticExpression.getWindowElement();
        this.builder.append(name).append("(");
        if (analyticExpression.isDistinct()) {
            this.builder.append("DISTINCT ");
        }
        if (analyticExpression.isUnique()) {
            this.builder.append("UNIQUE ");
        }
        if (expression != null) {
            expression.accept(this, context);
            if (offset != null) {
                this.builder.append(", ");
                offset.accept(this, context);
                if (defaultValue != null) {
                    this.builder.append(", ");
                    defaultValue.accept(this, context);
                }
            }
        } else if (isAllColumns) {
            this.builder.append("*");
        }
        if ((havingClause = analyticExpression.getHavingClause()) != null) {
            this.builder.append(" HAVING ").append((Object)havingClause.getHavingType()).append(" ");
            havingClause.getExpression().accept(this, context);
        }
        if (analyticExpression.getNullHandling() != null && !analyticExpression.isIgnoreNullsOutside()) {
            switch (analyticExpression.getNullHandling()) {
                case IGNORE_NULLS: {
                    this.builder.append(" IGNORE NULLS");
                    break;
                }
                case RESPECT_NULLS: {
                    this.builder.append(" RESPECT NULLS");
                }
            }
        }
        if (analyticExpression.getFuncOrderBy() != null) {
            this.builder.append(" ORDER BY ");
            this.builder.append(analyticExpression.getFuncOrderBy().stream().map(OrderByElement::toString).collect(Collectors.joining(", ")));
        }
        if (analyticExpression.getOnOverflowTruncate() != null) {
            this.builder.append(" ON OVERFLOW ").append(analyticExpression.getOnOverflowTruncate());
        }
        if (analyticExpression.getLimit() != null) {
            new LimitDeparser(this, this.builder).deParse(analyticExpression.getLimit());
        }
        this.builder.append(") ");
        if (keep != null) {
            keep.accept(this, context);
            this.builder.append(" ");
        }
        if (analyticExpression.getFilterExpression() != null) {
            this.builder.append("FILTER (WHERE ");
            analyticExpression.getFilterExpression().accept(this, context);
            this.builder.append(")");
            if (analyticExpression.getType() != AnalyticType.FILTER_ONLY) {
                this.builder.append(" ");
            }
        }
        if (analyticExpression.getNullHandling() != null && analyticExpression.isIgnoreNullsOutside()) {
            switch (analyticExpression.getNullHandling()) {
                case IGNORE_NULLS: {
                    this.builder.append(" IGNORE NULLS ");
                    break;
                }
                case RESPECT_NULLS: {
                    this.builder.append(" RESPECT NULLS ");
                }
            }
        }
        switch (analyticExpression.getType()) {
            case FILTER_ONLY: {
                return null;
            }
            case WITHIN_GROUP: {
                this.builder.append("WITHIN GROUP");
                break;
            }
            case WITHIN_GROUP_OVER: {
                this.builder.append("WITHIN GROUP (");
                analyticExpression.getWindowDefinition().getOrderBy().toStringOrderByElements(this.builder);
                this.builder.append(") OVER (");
                analyticExpression.getWindowDefinition().getPartitionBy().toStringPartitionBy(this.builder);
                this.builder.append(")");
                break;
            }
            default: {
                this.builder.append("OVER");
            }
        }
        if (analyticExpression.getWindowName() != null) {
            this.builder.append(" ").append(analyticExpression.getWindowName());
        } else if (analyticExpression.getType() != AnalyticType.WITHIN_GROUP_OVER) {
            int i;
            this.builder.append(" (");
            if (partitionExpressionList != null && !partitionExpressionList.isEmpty()) {
                this.builder.append("PARTITION BY ");
                if (analyticExpression.isPartitionByBrackets()) {
                    this.builder.append("(");
                }
                for (i = 0; i < partitionExpressionList.size(); ++i) {
                    if (i > 0) {
                        this.builder.append(", ");
                    }
                    ((Expression)partitionExpressionList.get(i)).accept(this, context);
                }
                if (analyticExpression.isPartitionByBrackets()) {
                    this.builder.append(")");
                }
                this.builder.append(" ");
            }
            if (orderByElements != null && !orderByElements.isEmpty()) {
                this.builder.append("ORDER BY ");
                this.orderByDeParser.setExpressionVisitor(this);
                this.orderByDeParser.setBuilder(this.builder);
                for (i = 0; i < orderByElements.size(); ++i) {
                    if (i > 0) {
                        this.builder.append(", ");
                    }
                    this.orderByDeParser.deParseElement(orderByElements.get(i));
                }
            }
            if (windowElement != null) {
                if (orderByElements != null && !orderByElements.isEmpty()) {
                    this.builder.append(' ');
                }
                this.builder.append(windowElement);
            }
            this.builder.append(")");
        }
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(ExtractExpression extractExpression, S context) {
        this.builder.append("EXTRACT(").append(extractExpression.getName());
        this.builder.append(" FROM ");
        extractExpression.getExpression().accept(this, context);
        this.builder.append(')');
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(IntervalExpression intervalExpression, S context) {
        if (intervalExpression.isUsingIntervalKeyword()) {
            this.builder.append("INTERVAL ");
        }
        if (intervalExpression.getExpression() != null) {
            intervalExpression.getExpression().accept(this, context);
        } else {
            this.builder.append(intervalExpression.getParameter());
        }
        if (intervalExpression.getIntervalType() != null) {
            this.builder.append(" ").append(intervalExpression.getIntervalType());
        }
        return this.builder;
    }

    @Override
    public void visit(Matches matches) {
        this.visit(matches, (Object)null);
    }

    @Override
    public void visit(BitwiseAnd bitwiseAnd) {
        this.visit(bitwiseAnd, (Object)null);
    }

    @Override
    public void visit(BitwiseOr bitwiseOr) {
        this.visit(bitwiseOr, (Object)null);
    }

    @Override
    public void visit(BitwiseXor bitwiseXor) {
        this.visit(bitwiseXor, (Object)null);
    }

    @Override
    public void visit(CastExpression cast) {
        this.visit(cast, (Object)null);
    }

    @Override
    public void visit(AnalyticExpression analyticExpression) {
        this.visit(analyticExpression, (Object)null);
    }

    @Override
    public void visit(ExtractExpression extractExpression) {
        this.visit(extractExpression, (Object)null);
    }

    @Override
    public void visit(IntervalExpression intervalExpression) {
        this.visit(intervalExpression, (Object)null);
    }

    @Override
    public <S> StringBuilder visit(JdbcNamedParameter jdbcNamedParameter, S context) {
        this.builder.append(jdbcNamedParameter.toString());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(OracleHierarchicalExpression hierarchicalExpression, S context) {
        this.builder.append(hierarchicalExpression.toString());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(RegExpMatchOperator regExpMatchOperator, S context) {
        this.deparse(regExpMatchOperator, " " + regExpMatchOperator.getStringExpression() + " ", null);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(JsonExpression jsonExpr, S context) {
        this.builder.append(jsonExpr.toString());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(JsonOperator jsonExpr, S context) {
        this.deparse(jsonExpr, " " + jsonExpr.getStringExpression() + " ", null);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(UserVariable var, S context) {
        this.builder.append(var.toString());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(NumericBind bind, S context) {
        this.builder.append(bind.toString());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(KeepExpression keepExpression, S context) {
        this.builder.append(keepExpression.toString());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(MySQLGroupConcat groupConcat, S context) {
        this.builder.append(groupConcat.toString());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(ExpressionList<? extends Expression> expressionList, S context) {
        ExpressionListDeParser expressionListDeParser = new ExpressionListDeParser(this, this.builder);
        expressionListDeParser.deParse(expressionList);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(RowConstructor<?> rowConstructor, S context) {
        if (rowConstructor.getName() != null) {
            this.builder.append(rowConstructor.getName());
        }
        ExpressionListDeParser expressionListDeParser = new ExpressionListDeParser(this, this.builder);
        expressionListDeParser.deParse((ExpressionList<?>)rowConstructor);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(RowGetExpression rowGetExpression, S context) {
        rowGetExpression.getExpression().accept(this, context);
        this.builder.append(".").append(rowGetExpression.getColumnName());
        return null;
    }

    @Override
    public <S> StringBuilder visit(OracleHint hint, S context) {
        this.builder.append(hint.toString());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(TimeKeyExpression timeKeyExpression, S context) {
        this.builder.append(timeKeyExpression.toString());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(DateTimeLiteralExpression literal, S context) {
        this.builder.append(literal.toString());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(NextValExpression nextVal, S context) {
        this.builder.append(nextVal.isUsingNextValueFor() ? "NEXT VALUE FOR " : "NEXTVAL FOR ").append(nextVal.getName());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(CollateExpression col, S context) {
        this.builder.append(col.getLeftExpression().toString()).append(" COLLATE ").append(col.getCollate());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(SimilarToExpression expr, S context) {
        this.deparse(expr, (expr.isNot() ? " NOT" : "") + " SIMILAR TO ", null);
        return this.builder;
    }

    @Override
    public void visit(JdbcNamedParameter jdbcNamedParameter) {
        this.visit(jdbcNamedParameter, (Object)null);
    }

    @Override
    public void visit(OracleHierarchicalExpression hierarchicalExpression) {
        this.visit(hierarchicalExpression, (Object)null);
    }

    @Override
    public void visit(RegExpMatchOperator regExpMatchOperator) {
        this.visit(regExpMatchOperator, (Object)null);
    }

    @Override
    public void visit(JsonExpression jsonExpr) {
        this.visit(jsonExpr, (Object)null);
    }

    @Override
    public void visit(JsonOperator jsonExpr) {
        this.visit(jsonExpr, (Object)null);
    }

    @Override
    public void visit(UserVariable userVariable) {
        this.visit(userVariable, (Object)null);
    }

    @Override
    public void visit(NumericBind numericBind) {
        this.visit(numericBind, (Object)null);
    }

    @Override
    public void visit(KeepExpression keepExpression) {
        this.visit(keepExpression, (Object)null);
    }

    @Override
    public void visit(MySQLGroupConcat groupConcat) {
        this.visit(groupConcat, (Object)null);
    }

    @Override
    public void visit(ExpressionList<?> expressionList) {
        this.visit(expressionList, (Object)null);
    }

    @Override
    public void visit(RowConstructor<?> rowConstructor) {
        this.visit((RowConstructor)rowConstructor, (Object)null);
    }

    @Override
    public void visit(RowGetExpression rowGetExpression) {
        this.visit(rowGetExpression, (Object)null);
    }

    @Override
    public void visit(OracleHint hint) {
        this.visit(hint, (Object)null);
    }

    @Override
    public void visit(TimeKeyExpression timeKeyExpression) {
        this.visit(timeKeyExpression, (Object)null);
    }

    @Override
    public void visit(DateTimeLiteralExpression literal) {
        this.visit(literal, (Object)null);
    }

    @Override
    public void visit(NextValExpression nextVal) {
        this.visit(nextVal, (Object)null);
    }

    @Override
    public void visit(CollateExpression col) {
        this.visit(col, (Object)null);
    }

    @Override
    public void visit(SimilarToExpression expr) {
        this.visit(expr, (Object)null);
    }

    @Override
    public <S> StringBuilder visit(ArrayExpression array, S context) {
        array.getObjExpression().accept(this, context);
        this.builder.append("[");
        if (array.getIndexExpression() != null) {
            array.getIndexExpression().accept(this, context);
        } else {
            if (array.getStartIndexExpression() != null) {
                array.getStartIndexExpression().accept(this, context);
            }
            this.builder.append(":");
            if (array.getStopIndexExpression() != null) {
                array.getStopIndexExpression().accept(this, context);
            }
        }
        this.builder.append("]");
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(ArrayConstructor arrayConstructor, S context) {
        if (arrayConstructor.isArrayKeyword()) {
            this.builder.append("ARRAY");
            ColDataType dataType = arrayConstructor.getDataType();
            if (dataType != null) {
                this.builder.append("<").append(dataType).append(">");
            }
        }
        this.builder.append("[");
        boolean first = true;
        for (Expression expression : arrayConstructor.getExpressions()) {
            if (!first) {
                this.builder.append(", ");
            } else {
                first = false;
            }
            expression.accept(this, context);
        }
        this.builder.append("]");
        return this.builder;
    }

    @Override
    void deParse(Expression statement) {
        statement.accept(this, null);
    }

    @Override
    public <S> StringBuilder visit(VariableAssignment var, S context) {
        var.getVariable().accept(this, context);
        this.builder.append(" ").append(var.getOperation()).append(" ");
        var.getExpression().accept(this, context);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(XMLSerializeExpr expr, S context) {
        this.builder.append("xmlserialize(xmlagg(xmltext(");
        expr.getExpression().accept(this, context);
        this.builder.append(")");
        if (expr.getOrderByElements() != null) {
            this.builder.append(" ORDER BY ");
            Iterator<OrderByElement> i = expr.getOrderByElements().iterator();
            while (i.hasNext()) {
                this.builder.append(i.next().toString());
                if (!i.hasNext()) continue;
                this.builder.append(", ");
            }
        }
        this.builder.append(") AS ").append(expr.getDataType()).append(")");
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(TimezoneExpression var, S context) {
        var.getLeftExpression().accept(this, context);
        for (Expression expr : var.getTimezoneExpressions()) {
            this.builder.append(" AT TIME ZONE ");
            expr.accept(this, context);
        }
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(JsonAggregateFunction expression, S context) {
        expression.append(this.builder);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(JsonFunction expression, S context) {
        expression.append(this.builder);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(ConnectByRootOperator connectByRootOperator, S context) {
        this.builder.append("CONNECT_BY_ROOT ");
        connectByRootOperator.getColumn().accept(this, context);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(ConnectByPriorOperator connectByPriorOperator, S context) {
        this.builder.append("PRIOR ");
        connectByPriorOperator.getColumn().accept(this, context);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(OracleNamedFunctionParameter oracleNamedFunctionParameter, S context) {
        this.builder.append(oracleNamedFunctionParameter.getName()).append(" => ");
        oracleNamedFunctionParameter.getExpression().accept(this, context);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(AllColumns allColumns, S context) {
        this.builder.append(allColumns.toString());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(AllTableColumns allTableColumns, S context) {
        this.builder.append(allTableColumns.toString());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(FunctionAllColumns functionAllColumns, S context) {
        this.builder.append(functionAllColumns.toString());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(AllValue allValue, S context) {
        this.builder.append(allValue);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(IsDistinctExpression isDistinctExpression, S context) {
        this.builder.append(isDistinctExpression.getLeftExpression()).append(isDistinctExpression.getStringExpression()).append(isDistinctExpression.getRightExpression());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(GeometryDistance geometryDistance, S context) {
        this.deparse(geometryDistance, " " + geometryDistance.getStringExpression() + " ", null);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(TSQLLeftJoin tsqlLeftJoin, S context) {
        this.deparse(tsqlLeftJoin, " *= ", null);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(TSQLRightJoin tsqlRightJoin, S context) {
        this.deparse(tsqlRightJoin, " =* ", null);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(StructType structType, S context) {
        int i;
        if (structType.getDialect() != StructType.Dialect.DUCKDB && structType.getKeyword() != null) {
            this.builder.append(structType.getKeyword());
        }
        if (structType.getDialect() != StructType.Dialect.DUCKDB && structType.getParameters() != null && !structType.getParameters().isEmpty()) {
            this.builder.append("<");
            i = 0;
            for (Map.Entry<String, ColDataType> entry : structType.getParameters()) {
                if (0 < i++) {
                    this.builder.append(",");
                }
                if (entry.getKey() != null && !entry.getKey().isEmpty()) {
                    this.builder.append(entry.getKey()).append(" ");
                }
                this.builder.append(entry.getValue());
            }
            this.builder.append(">");
        }
        if (structType.getArguments() != null && !structType.getArguments().isEmpty()) {
            if (structType.getDialect() == StructType.Dialect.DUCKDB) {
                this.builder.append("{ ");
                i = 0;
                for (SelectItem selectItem : structType.getArguments()) {
                    if (0 < i++) {
                        this.builder.append(",");
                    }
                    this.builder.append(selectItem.getAlias().getName());
                    this.builder.append(" : ");
                    selectItem.getExpression().accept(this, context);
                }
                this.builder.append(" }");
            } else {
                this.builder.append("(");
                i = 0;
                for (SelectItem selectItem : structType.getArguments()) {
                    if (0 < i++) {
                        this.builder.append(",");
                    }
                    selectItem.getExpression().accept(this, context);
                    if (selectItem.getAlias() == null) continue;
                    this.builder.append(" as ");
                    this.builder.append(selectItem.getAlias().getName());
                }
                this.builder.append(")");
            }
        }
        if (structType.getDialect() == StructType.Dialect.DUCKDB && structType.getParameters() != null && !structType.getParameters().isEmpty()) {
            this.builder.append("::STRUCT( ");
            i = 0;
            for (Map.Entry entry : structType.getParameters()) {
                if (0 < i++) {
                    this.builder.append(",");
                }
                this.builder.append((String)entry.getKey()).append(" ");
                this.builder.append(entry.getValue());
            }
            this.builder.append(")");
        }
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(LambdaExpression lambdaExpression, S context) {
        if (lambdaExpression.getIdentifiers().size() == 1) {
            this.builder.append(lambdaExpression.getIdentifiers().get(0));
        } else {
            int i = 0;
            this.builder.append("( ");
            for (String s : lambdaExpression.getIdentifiers()) {
                this.builder.append(i++ > 0 ? ", " : "").append(s);
            }
            this.builder.append(" )");
        }
        this.builder.append(" -> ");
        lambdaExpression.getExpression().accept(this, context);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(HighExpression highExpression, S context) {
        return this.builder.append(highExpression.toString());
    }

    @Override
    public <S> StringBuilder visit(LowExpression lowExpression, S context) {
        return this.builder.append(lowExpression.toString());
    }

    @Override
    public <S> StringBuilder visit(Plus plus, S context) {
        return this.builder.append(plus.toString());
    }

    @Override
    public <S> StringBuilder visit(PriorTo priorTo, S context) {
        return this.builder.append(priorTo.toString());
    }

    @Override
    public <S> StringBuilder visit(Inverse inverse, S context) {
        return this.builder.append(inverse.toString());
    }

    @Override
    public <S> StringBuilder visit(CosineSimilarity cosineSimilarity, S context) {
        this.deparse(cosineSimilarity, " " + cosineSimilarity.getStringExpression() + " ", context);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(FromQuery fromQuery, S context) {
        return null;
    }
}

