/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionBootstrap;
import org.jkiss.dbeaver.model.exec.DBCCachedContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class SQLServerExecutionContext
extends JDBCExecutionContext
implements DBCExecutionContextDefaults<SQLServerDatabase, SQLServerSchema> {
    private static final Log log = Log.getLog(SQLServerExecutionContext.class);
    private String activeDatabaseName;
    private String activeSchemaName;
    private String currentUser;

    SQLServerExecutionContext(@NotNull JDBCRemoteInstance instance, String purpose) {
        super(instance, purpose);
    }

    @NotNull
    public SQLServerDataSource getDataSource() {
        return (SQLServerDataSource)super.getDataSource();
    }

    @NotNull
    public SQLServerExecutionContext getContextDefaults() {
        return this;
    }

    public String getActiveDatabaseName() {
        return this.activeDatabaseName;
    }

    public SQLServerDatabase getDefaultCatalog() {
        return this.getDataSource().getDatabase(this.activeDatabaseName);
    }

    @Nullable
    public SQLServerSchema getDefaultSchema() {
        SQLServerDatabase defaultCatalog;
        block5: {
            if (CommonUtils.isEmpty((String)this.activeSchemaName)) {
                return null;
            }
            try {
                defaultCatalog = this.getDefaultCatalog();
                if (defaultCatalog != null) break block5;
                return null;
            }
            catch (DBException e) {
                log.error((Object)e);
                return null;
            }
        }
        SQLServerSchema schema = defaultCatalog.getSchema((DBRProgressMonitor)new VoidProgressMonitor(), this.activeSchemaName);
        if (schema == null) {
            schema = defaultCatalog.getSchema((DBRProgressMonitor)new VoidProgressMonitor(), "dbo");
        }
        return schema;
    }

    public boolean supportsCatalogChange() {
        return true;
    }

    public boolean supportsSchemaChange() {
        return false;
    }

    public void setDefaultCatalog(DBRProgressMonitor monitor, SQLServerDatabase catalog, @Nullable SQLServerSchema schema) throws DBCException {
        if (this.activeDatabaseName != null && this.activeDatabaseName.equals(catalog.getName())) {
            return;
        }
        SQLServerDatabase oldActiveDatabase = this.getDefaultCatalog();
        if (!this.setCurrentDatabase(monitor, catalog)) {
            return;
        }
        try {
            catalog.getSchemas(monitor);
        }
        catch (DBException e) {
            log.debug((Object)"Error caching database schemas", (Throwable)e);
        }
        this.activeDatabaseName = catalog.getName();
        DBUtils.fireObjectSelectionChange((DBSObject)oldActiveDatabase, (DBSObject)catalog, (DBCExecutionContext)this);
        if (schema != null) {
            this.setDefaultSchema(monitor, schema);
        }
    }

    public void setDefaultSchema(DBRProgressMonitor monitor, SQLServerSchema schema) throws DBCException {
        if (this.activeSchemaName != null && this.activeSchemaName.equals(schema.getName())) {
            return;
        }
        SQLServerSchema oldActiveSchema = this.getDefaultSchema();
        this.activeSchemaName = schema.getName();
        DBUtils.fireObjectSelectionChange((DBSObject)oldActiveSchema, (DBSObject)schema, (DBCExecutionContext)this);
    }

    public boolean refreshDefaults(DBRProgressMonitor monitor, boolean useBootstrapSettings) throws DBException {
        boolean refreshed = false;
        Throwable throwable = null;
        Object var5_6 = null;
        try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.META, "Query active schema and database");){
            DBPConnectionBootstrap bootstrap;
            String currentDatabase = null;
            String currentSchema = null;
            try {
                Throwable throwable2 = null;
                Object var10_14 = null;
                try (JDBCStatement dbStat = session.createStatement();){
                    String query = "SELECT db_name(), schema_name(), original_login()";
                    if (SQLServerUtils.isDriverBabelfish(session.getDataSource().getContainer().getDriver())) {
                        query = "SELECT db_name(), s.name AS schema_name, session_user AS original_login FROM sys.schemas s";
                    }
                    Throwable throwable3 = null;
                    Object var14_20 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery(query);){
                        dbResult.next();
                        currentDatabase = dbResult.getString(1);
                        currentSchema = dbResult.getString(2);
                        this.currentUser = dbResult.getString(3);
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable e) {
                log.debug((Object)("Error getting current user: " + e.getMessage()));
            }
            if (!(CommonUtils.isEmpty(currentDatabase) || this.activeDatabaseName != null && CommonUtils.equalObjects(currentDatabase, (Object)this.activeDatabaseName))) {
                this.activeDatabaseName = currentDatabase;
                refreshed = true;
            }
            if (CommonUtils.isEmpty(currentSchema)) {
                currentSchema = "dbo";
            }
            if (this.activeSchemaName == null || !CommonUtils.equalObjects((Object)currentSchema, (Object)this.activeSchemaName)) {
                this.activeSchemaName = currentSchema;
                refreshed = true;
            }
            if (useBootstrapSettings && !CommonUtils.isEmpty((String)(bootstrap = this.getBootstrapSettings()).getDefaultCatalogName()) && this.supportsCatalogChange() && !CommonUtils.equalObjects((Object)bootstrap.getDefaultCatalogName(), (Object)this.activeDatabaseName)) {
                this.setCurrentDatabase(monitor, bootstrap.getDefaultCatalogName());
                refreshed = true;
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
        return refreshed;
    }

    boolean setCurrentDatabase(DBRProgressMonitor monitor, SQLServerDatabase object) throws DBCException {
        if (object == null) {
            log.debug((Object)"Null current schema");
            return false;
        }
        String databaseName = object.getName();
        return this.setCurrentDatabase(monitor, databaseName);
    }

    private boolean setCurrentDatabase(DBRProgressMonitor monitor, String databaseName) {
        block12: {
            Throwable throwable = null;
            Object var4_6 = null;
            JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active database");
            try {
                SQLServerUtils.setCurrentDatabase(session, databaseName);
                this.activeDatabaseName = databaseName;
                if (session == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (session != null) {
                            session.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    log.error((Object)e);
                    return false;
                }
            }
            session.close();
        }
        return true;
    }

    @NotNull
    public DBCCachedContextDefaults getCachedDefault() {
        return new DBCCachedContextDefaults(this.activeDatabaseName, this.activeSchemaName);
    }
}

