/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import javax.swing.text.TabExpander;
import org.fife.ui.rsyntaxtextarea.DefaultTokenPainter;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;

public class VisibleWhitespaceTokenPainter
extends DefaultTokenPainter {
    @Override
    protected float paintImpl(Token token, Graphics2D g, float x, float y, RSyntaxTextArea host, TabExpander e, float clipStart, boolean selected, boolean useSTC) {
        int origX = (int)x;
        int textOffs = token.getTextOffset();
        char[] text = token.getTextArray();
        int end = textOffs + token.length();
        float nextX = x;
        int flushLen = 0;
        int flushIndex = textOffs;
        Color fg = useSTC ? host.getSelectedTextColor() : host.getForegroundForToken(token);
        Color bg = selected ? null : host.getBackgroundForToken(token);
        g.setFont(host.getFontForToken(token));
        FontMetrics fm = host.getFontMetricsForToken(token);
        int ascent = fm.getAscent();
        int height = fm.getHeight();
        block4: for (int i = textOffs; i < end; ++i) {
            switch (text[i]) {
                case '\t': {
                    nextX = x + (float)fm.charsWidth(text, flushIndex, flushLen);
                    float nextTabStop = e.nextTabStop(nextX, 0);
                    if (bg != null) {
                        this.paintBackground(x, y, nextTabStop - x, height, g, ascent, host, bg);
                    }
                    g.setColor(fg);
                    if (flushLen > 0) {
                        g.drawChars(text, flushIndex, flushLen, (int)x, (int)y);
                        flushLen = 0;
                    }
                    flushIndex = i + 1;
                    this.paintTabText(g, nextX, y, nextTabStop, ascent, height);
                    x = nextTabStop;
                    continue block4;
                }
                case ' ': {
                    nextX = x + (float)fm.charsWidth(text, flushIndex, flushLen + 1);
                    int width = fm.charWidth(' ');
                    if (bg != null) {
                        this.paintBackground(x, y, nextX - x, height, g, ascent, host, bg);
                    }
                    g.setColor(fg);
                    if (flushLen > 0) {
                        g.drawChars(text, flushIndex, flushLen, (int)x, (int)y);
                        flushLen = 0;
                    }
                    this.paintSpaceText(g, nextX, y, ascent, width, height);
                    flushIndex = i + 1;
                    x = nextX;
                    continue block4;
                }
                default: {
                    ++flushLen;
                }
            }
        }
        nextX = x + (float)fm.charsWidth(text, flushIndex, flushLen);
        if (flushLen > 0 && nextX >= clipStart) {
            if (bg != null) {
                this.paintBackground(x, y, nextX - x, height, g, ascent, host, bg);
            }
            g.setColor(fg);
            g.drawChars(text, flushIndex, flushLen, (int)x, (int)y);
        }
        if (host.getUnderlineForToken(token)) {
            g.setColor(fg);
            int y2 = (int)(y + 1.0f);
            g.drawLine(origX, y2, (int)nextX, y2);
        }
        if (host.getPaintTabLines() && origX == host.getMargin().left) {
            this.paintTabLines(token, origX, (int)y, (int)nextX, g, e, host);
        }
        return nextX;
    }

    protected void paintSpaceText(Graphics2D g, float x, float y, int ascent, int width, int height) {
        int dotX = (int)(x - (float)width / 2.0f);
        int dotY = (int)(y - (float)ascent + (float)height / 2.0f);
        g.drawLine(dotX, dotY, dotX, dotY);
    }

    protected void paintTabText(Graphics2D g, float x, float y, float nextTabStop, int ascent, int height) {
        int x2 = (int)nextTabStop - 3;
        if (x2 >= (int)x) {
            int halfHeight = height / 2;
            int ymid = (int)y - ascent + halfHeight;
            g.drawLine((int)x, ymid, x2, ymid);
        }
    }
}

