/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.exception;

import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;

@ExportLibrary(value=InteropLibrary.class)
final class InteropList
implements TruffleObject {
    private final Object[] items;

    InteropList(Object[] items) {
        this.items = items;
    }

    @ExportMessage
    boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    long getArraySize() {
        return this.items.length;
    }

    @ExportMessage
    boolean isArrayElementReadable(long index) {
        return index >= 0L && index < (long)this.items.length;
    }

    @ExportMessage
    Object readArrayElement(long index) throws InvalidArrayIndexException {
        if (index < 0L || index >= (long)this.items.length) {
            throw InvalidArrayIndexException.create(index);
        }
        return this.items[(int)index];
    }
}

