/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.graph;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import us.fatehi.utility.graph.DirectedEdge;
import us.fatehi.utility.graph.DirectedGraph;
import us.fatehi.utility.graph.Vertex;

public class TarjanStronglyConnectedComponentFinder<T extends Comparable<? super T>> {
    private static final String ATTRIBUTE_INDEX = "index";
    private static final String ATTRIBUTE_LOWLINK = "lowlink";
    private final DirectedGraph<T> graph;
    private final Deque<Vertex<T>> stack;
    private final Collection<List<T>> stronglyConnectedComponents;

    public TarjanStronglyConnectedComponentFinder(DirectedGraph<T> graph) {
        this.graph = Objects.requireNonNull(graph, "No diagram provided");
        this.stronglyConnectedComponents = new HashSet<List<T>>();
        this.stack = new ArrayDeque<Vertex<T>>();
    }

    public Collection<List<T>> detectCycles() {
        for (Vertex<T> vertex : this.graph.vertexSet()) {
            if (vertex.hasAttribute(ATTRIBUTE_INDEX)) continue;
            this.strongConnect(vertex, 0);
        }
        return this.stronglyConnectedComponents;
    }

    private void strongConnect(Vertex<T> vertexFrom, int index) {
        vertexFrom.putAttribute(ATTRIBUTE_INDEX, index);
        vertexFrom.putAttribute(ATTRIBUTE_LOWLINK, index);
        this.stack.push(vertexFrom);
        for (DirectedEdge<T> edge : this.graph.getOutgoingEdges(vertexFrom)) {
            Vertex<T> vertexTo = edge.getTo();
            if (!vertexTo.hasAttribute(ATTRIBUTE_INDEX)) {
                this.strongConnect(vertexTo, index + 1);
                vertexFrom.putAttribute(ATTRIBUTE_LOWLINK, Math.min((Integer)vertexFrom.getAttribute(ATTRIBUTE_LOWLINK), (Integer)vertexTo.getAttribute(ATTRIBUTE_LOWLINK)));
                continue;
            }
            if (!this.stack.contains(vertexTo)) continue;
            vertexFrom.putAttribute(ATTRIBUTE_LOWLINK, Math.min((Integer)vertexFrom.getAttribute(ATTRIBUTE_LOWLINK), (Integer)vertexTo.getAttribute(ATTRIBUTE_INDEX)));
        }
        if (vertexFrom.getAttribute(ATTRIBUTE_LOWLINK) == vertexFrom.getAttribute(ATTRIBUTE_INDEX)) {
            Vertex<T> sccVertex;
            LinkedList<Comparable> scc = new LinkedList<Comparable>();
            do {
                sccVertex = this.stack.pop();
                scc.addFirst((Comparable)sccVertex.getValue());
            } while (!vertexFrom.equals(sccVertex));
            if (scc.size() > 1) {
                this.stronglyConnectedComponents.add(scc);
            }
        }
    }
}

