/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.nfi.ConvertTypeNode;
import com.oracle.truffle.nfi.LongDoubleUtil;
import com.oracle.truffle.nfi.NFIPointer;
import com.oracle.truffle.nfi.NFIType;
import com.oracle.truffle.nfi.SimpleTypeCachedStateFactory;
import com.oracle.truffle.nfi.api.SerializableLibrary;
import com.oracle.truffle.nfi.backend.spi.BackendNativePointerLibrary;
import com.oracle.truffle.nfi.backend.spi.types.NativeSimpleType;

final class SimpleTypeCachedState {
    private static final NFIType.TypeCachedState nopCachedState;
    private static final NFIType.TypeCachedState injectedCachedState;
    private static final NFIType.TypeCachedState[] simpleCachedState;

    SimpleTypeCachedState() {
    }

    public static NFIType.TypeCachedState get(NativeSimpleType type) {
        return simpleCachedState[type.ordinal()];
    }

    public static NFIType.TypeCachedState nop() {
        return nopCachedState;
    }

    public static NFIType.TypeCachedState injected() {
        return injectedCachedState;
    }

    static {
        NFIType.TypeCachedState[] c = new NFIType.TypeCachedState[NativeSimpleType.values().length];
        nopCachedState = new NFIType.TypeCachedState(1, SimpleTypeCachedStateFactory.NopConvertFactory.getInstance(), SimpleTypeCachedStateFactory.NopConvertFactory.getInstance(), NFIPointer.nullPtr());
        injectedCachedState = new NFIType.TypeCachedState(0, SimpleTypeCachedStateFactory.InjectedFactory.getInstance(), SimpleTypeCachedStateFactory.NothingFactory.getInstance(), NFIPointer.nullPtr());
        c[NativeSimpleType.VOID.ordinal()] = new NFIType.TypeCachedState(1, SimpleTypeCachedStateFactory.NothingFactory.getInstance(), SimpleTypeCachedStateFactory.NopConvertFactory.getInstance(), NFIPointer.nullPtr());
        c[NativeSimpleType.SINT8.ordinal()] = new NFIType.TypeCachedState(1, SimpleTypeCachedStateFactory.ToInt8Factory.getInstance(), SimpleTypeCachedStateFactory.NopConvertFactory.getInstance(), (byte)0);
        c[NativeSimpleType.SINT16.ordinal()] = new NFIType.TypeCachedState(1, SimpleTypeCachedStateFactory.ToInt16Factory.getInstance(), SimpleTypeCachedStateFactory.NopConvertFactory.getInstance(), (short)0);
        c[NativeSimpleType.SINT32.ordinal()] = new NFIType.TypeCachedState(1, SimpleTypeCachedStateFactory.ToInt32Factory.getInstance(), SimpleTypeCachedStateFactory.NopConvertFactory.getInstance(), 0);
        c[NativeSimpleType.SINT64.ordinal()] = new NFIType.TypeCachedState(1, SimpleTypeCachedStateFactory.ToInt64Factory.getInstance(), SimpleTypeCachedStateFactory.NopConvertFactory.getInstance(), 0L);
        c[NativeSimpleType.UINT8.ordinal()] = new NFIType.TypeCachedState(1, SimpleTypeCachedStateFactory.ToInt8Factory.getInstance(), SimpleTypeCachedStateFactory.FromUInt8Factory.getInstance(), (byte)0);
        c[NativeSimpleType.UINT16.ordinal()] = new NFIType.TypeCachedState(1, SimpleTypeCachedStateFactory.ToInt16Factory.getInstance(), SimpleTypeCachedStateFactory.FromUInt16Factory.getInstance(), (short)0);
        c[NativeSimpleType.UINT32.ordinal()] = new NFIType.TypeCachedState(1, SimpleTypeCachedStateFactory.ToInt32Factory.getInstance(), SimpleTypeCachedStateFactory.FromUInt32Factory.getInstance(), 0);
        c[NativeSimpleType.UINT64.ordinal()] = c[NativeSimpleType.SINT64.ordinal()];
        c[NativeSimpleType.FLOAT.ordinal()] = new NFIType.TypeCachedState(1, SimpleTypeCachedStateFactory.ToFloatFactory.getInstance(), SimpleTypeCachedStateFactory.NopConvertFactory.getInstance(), Float.valueOf(0.0f));
        c[NativeSimpleType.DOUBLE.ordinal()] = new NFIType.TypeCachedState(1, SimpleTypeCachedStateFactory.ToDoubleFactory.getInstance(), SimpleTypeCachedStateFactory.NopConvertFactory.getInstance(), 0.0);
        c[NativeSimpleType.FP80.ordinal()] = new NFIType.TypeCachedState(1, SimpleTypeCachedStateFactory.ToFP80Factory.getInstance(), SimpleTypeCachedStateFactory.FromFP80Factory.getInstance(), LongDoubleUtil.interopToFP80(0));
        c[NativeSimpleType.FP128.ordinal()] = new NFIType.TypeCachedState(1, SimpleTypeCachedStateFactory.ToFP128Factory.getInstance(), SimpleTypeCachedStateFactory.FromFP128Factory.getInstance(), LongDoubleUtil.interopToFP128(0));
        c[NativeSimpleType.POINTER.ordinal()] = new NFIType.TypeCachedState(1, SimpleTypeCachedStateFactory.NopConvertFactory.getInstance(), SimpleTypeCachedStateFactory.PointerFromNativeFactory.getInstance(), NFIPointer.nullPtr());
        c[NativeSimpleType.NULLABLE.ordinal()] = new NFIType.TypeCachedState(1, SimpleTypeCachedStateFactory.NullableToNativeFactory.getInstance(), SimpleTypeCachedStateFactory.PointerFromNativeFactory.getInstance(), NFIPointer.nullPtr());
        c[NativeSimpleType.STRING.ordinal()] = new NFIType.TypeCachedState(1, SimpleTypeCachedStateFactory.NopConvertFactory.getInstance(), SimpleTypeCachedStateFactory.PointerFromNativeFactory.getInstance(), NFIPointer.nullPtr());
        c[NativeSimpleType.OBJECT.ordinal()] = nopCachedState;
        simpleCachedState = c;
    }

    @GenerateUncached
    @GenerateNodeFactory
    @GenerateInline(value=false)
    static abstract class FromFP128
    extends ConvertTypeNode {
        FromFP128() {
        }

        @Specialization(limit="1", guards={"interop.hasBufferElements(arg)", "!interop.isNumber(arg)"})
        @GenerateAOT.Exclude
        Object doBuffer(NFIType type, Object arg, @CachedLibrary(value="arg") InteropLibrary interop) {
            assert (interop.hasBufferElements(arg));
            return LongDoubleUtil.fp128ToNumber(arg);
        }

        @Fallback
        Object doOther(NFIType type, Object arg) {
            return arg;
        }
    }

    @GenerateUncached
    @GenerateNodeFactory
    @GenerateInline(value=false)
    static abstract class ToFP128
    extends ConvertTypeNode {
        ToFP128() {
        }

        @Specialization(limit="3", guards={"interop.isNumber(arg)"})
        @GenerateAOT.Exclude
        Object doNumber(NFIType type, Object arg, @CachedLibrary(value="arg") InteropLibrary interop) {
            assert (interop.fitsInLong(arg) || interop.fitsInDouble(arg));
            return LongDoubleUtil.interopToFP128(arg);
        }

        @Specialization(limit="3", guards={"serialize.isSerializable(arg)"})
        Object doSerializable(NFIType type, Object arg, @CachedLibrary(value="arg") SerializableLibrary serialize) {
            assert (serialize.isSerializable(arg));
            return arg;
        }

        @Fallback
        byte doFail(NFIType type, Object arg) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{arg});
        }
    }

    @GenerateUncached
    @GenerateNodeFactory
    @GenerateInline(value=false)
    static abstract class FromFP80
    extends ConvertTypeNode {
        FromFP80() {
        }

        @Specialization(limit="1", guards={"interop.hasBufferElements(arg)", "!interop.isNumber(arg)"})
        @GenerateAOT.Exclude
        Object doBuffer(NFIType type, Object arg, @CachedLibrary(value="arg") InteropLibrary interop) {
            assert (interop.hasBufferElements(arg));
            return LongDoubleUtil.fp80ToNumber(arg);
        }

        @Fallback
        Object doOther(NFIType type, Object arg) {
            return arg;
        }
    }

    @GenerateUncached
    @GenerateNodeFactory
    @GenerateInline(value=false)
    static abstract class ToFP80
    extends ConvertTypeNode {
        ToFP80() {
        }

        @Specialization(limit="3", guards={"interop.isNumber(arg)"})
        @GenerateAOT.Exclude
        Object doNumber(NFIType type, Object arg, @CachedLibrary(value="arg") InteropLibrary interop) {
            assert (interop.fitsInLong(arg) || interop.fitsInDouble(arg));
            return LongDoubleUtil.interopToFP80(arg);
        }

        @Specialization(limit="3", guards={"serialize.isSerializable(arg)"})
        Object doSerializable(NFIType type, Object arg, @CachedLibrary(value="arg") SerializableLibrary serialize) {
            assert (serialize.isSerializable(arg));
            return arg;
        }

        @Fallback
        byte doFail(NFIType type, Object arg) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{arg});
        }
    }

    @GenerateUncached
    @GenerateNodeFactory
    @GenerateInline(value=false)
    static abstract class ToDouble
    extends ConvertTypeNode {
        ToDouble() {
        }

        @Specialization
        double doPrimitive(NFIType type, double arg) {
            return arg;
        }

        @Specialization(limit="3", replaces={"doPrimitive"}, guards={"interop.fitsInDouble(arg)"}, rewriteOn={UnsupportedMessageException.class})
        @GenerateAOT.Exclude
        double doDouble(NFIType type, Object arg, @CachedLibrary(value="arg") InteropLibrary interop) throws UnsupportedMessageException {
            return interop.asDouble(arg);
        }

        @Specialization(limit="3", replaces={"doDouble"}, guards={"interop.isNumber(arg)"})
        @GenerateAOT.Exclude
        static double doNumber(NFIType type, Object arg, @CachedLibrary(value="arg") InteropLibrary interop, @Bind Node node, @Cached InlinedBranchProfile exception) throws UnsupportedTypeException {
            try {
                if (interop.fitsInDouble(arg)) {
                    return interop.asDouble(arg);
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            exception.enter(node);
            throw UnsupportedTypeException.create((Object[])new Object[]{arg});
        }

        @Specialization(limit="3", guards={"interop.isBoolean(arg)"})
        @GenerateAOT.Exclude
        double doBoolean(NFIType type, Object arg, @CachedLibrary(value="arg") InteropLibrary interop) {
            try {
                return interop.asBoolean(arg) ? 1.0 : 0.0;
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }

        @Fallback
        byte doFail(NFIType type, Object arg) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{arg});
        }
    }

    @GenerateUncached
    @GenerateNodeFactory
    @GenerateInline(value=false)
    static abstract class ToFloat
    extends ConvertTypeNode {
        ToFloat() {
        }

        @Specialization
        float doPrimitive(NFIType type, float arg) {
            return arg;
        }

        @Specialization
        float doPrimitive(NFIType type, double arg) {
            return (float)arg;
        }

        @Specialization(limit="3", replaces={"doPrimitive"}, guards={"interop.fitsInFloat(arg)"}, rewriteOn={UnsupportedMessageException.class})
        @GenerateAOT.Exclude
        float doFloat(NFIType type, Object arg, @CachedLibrary(value="arg") InteropLibrary interop) throws UnsupportedMessageException {
            return interop.asFloat(arg);
        }

        @Specialization(limit="3", replaces={"doFloat"}, guards={"interop.isNumber(arg)"})
        @GenerateAOT.Exclude
        static float doNumber(NFIType type, Object arg, @CachedLibrary(value="arg") InteropLibrary interop, @Bind Node node, @Cached InlinedBranchProfile exception) throws UnsupportedTypeException {
            try {
                if (interop.fitsInDouble(arg)) {
                    return (float)interop.asDouble(arg);
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            exception.enter(node);
            throw UnsupportedTypeException.create((Object[])new Object[]{arg});
        }

        @Specialization(limit="3", guards={"interop.isBoolean(arg)"})
        @GenerateAOT.Exclude
        float doBoolean(NFIType type, Object arg, @CachedLibrary(value="arg") InteropLibrary interop) {
            try {
                return interop.asBoolean(arg) ? 1.0f : 0.0f;
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }

        @Fallback
        byte doFail(NFIType type, Object arg) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{arg});
        }
    }

    @GenerateUncached
    @GenerateNodeFactory
    @GenerateInline(value=false)
    static abstract class ToInt64
    extends ConvertTypeNode {
        ToInt64() {
        }

        @Specialization
        long doPrimitive(NFIType type, long arg) {
            return arg;
        }

        @Specialization(limit="3", replaces={"doPrimitive"}, guards={"interop.fitsInLong(arg)"}, rewriteOn={UnsupportedMessageException.class})
        @GenerateAOT.Exclude
        long doLong(NFIType type, Object arg, @CachedLibrary(value="arg") InteropLibrary interop) throws UnsupportedMessageException {
            return interop.asLong(arg);
        }

        @Specialization(limit="3", replaces={"doLong"}, guards={"interop.isNumber(arg)"})
        @GenerateAOT.Exclude
        static long doNumber(NFIType type, Object arg, @CachedLibrary(value="arg") InteropLibrary interop, @Bind Node node, @Cached InlinedBranchProfile exception) throws UnsupportedTypeException {
            try {
                if (interop.fitsInLong(arg)) {
                    return interop.asLong(arg);
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            exception.enter(node);
            throw UnsupportedTypeException.create((Object[])new Object[]{arg});
        }

        @Specialization(limit="3", guards={"interop.isBoolean(arg)"})
        @GenerateAOT.Exclude
        long doBoolean(NFIType type, Object arg, @CachedLibrary(value="arg") InteropLibrary interop) {
            try {
                return interop.asBoolean(arg) ? 1L : 0L;
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }

        @Fallback
        byte doFail(NFIType type, Object arg) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{arg});
        }
    }

    @GenerateUncached
    @GenerateNodeFactory
    @GenerateInline(value=false)
    static abstract class FromUInt32
    extends ConvertTypeNode {
        FromUInt32() {
        }

        @Specialization
        long doPrimitive(NFIType type, int arg) {
            return (long)arg & 0xFFFFFFFFL;
        }

        @Fallback
        Object doOther(NFIType type, Object arg) {
            return arg;
        }
    }

    @GenerateUncached
    @GenerateNodeFactory
    @GenerateInline(value=false)
    static abstract class ToInt32
    extends ConvertTypeNode {
        ToInt32() {
        }

        @Specialization
        int doPrimitive(NFIType type, int arg) {
            return arg;
        }

        @Specialization(limit="3", replaces={"doPrimitive"}, guards={"interop.fitsInInt(arg)"}, rewriteOn={UnsupportedMessageException.class})
        @GenerateAOT.Exclude
        int doInt(NFIType type, Object arg, @CachedLibrary(value="arg") InteropLibrary interop) throws UnsupportedMessageException {
            return interop.asInt(arg);
        }

        @Specialization(limit="3", replaces={"doInt"}, guards={"interop.isNumber(arg)"})
        @GenerateAOT.Exclude
        static int doNumber(NFIType type, Object arg, @CachedLibrary(value="arg") InteropLibrary interop, @Bind Node node, @Cached InlinedBranchProfile exception) throws UnsupportedTypeException {
            try {
                long val;
                if (interop.fitsInInt(arg)) {
                    return interop.asInt(arg);
                }
                if (interop.fitsInLong(arg) && Long.compareUnsigned(val = interop.asLong(arg), 0x100000000L) < 0) {
                    return (int)val;
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            exception.enter(node);
            throw UnsupportedTypeException.create((Object[])new Object[]{arg});
        }

        @Specialization(limit="3", guards={"interop.isBoolean(arg)"})
        @GenerateAOT.Exclude
        int doBoolean(NFIType type, Object arg, @CachedLibrary(value="arg") InteropLibrary interop) {
            try {
                return interop.asBoolean(arg) ? 1 : 0;
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }

        @Fallback
        byte doFail(NFIType type, Object arg) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{arg});
        }
    }

    @GenerateUncached
    @GenerateNodeFactory
    @GenerateInline(value=false)
    static abstract class FromUInt16
    extends ConvertTypeNode {
        FromUInt16() {
        }

        @Specialization
        int doPrimitive(NFIType type, short arg) {
            return arg & 0xFFFF;
        }

        @Fallback
        Object doOther(NFIType type, Object arg) {
            return arg;
        }
    }

    @GenerateUncached
    @GenerateNodeFactory
    @GenerateInline(value=false)
    static abstract class ToInt16
    extends ConvertTypeNode {
        ToInt16() {
        }

        @Specialization
        short doPrimitive(NFIType type, short arg) {
            return arg;
        }

        @Specialization(limit="3", replaces={"doPrimitive"}, guards={"interop.fitsInShort(arg)"}, rewriteOn={UnsupportedMessageException.class})
        @GenerateAOT.Exclude
        short doShort(NFIType type, Object arg, @CachedLibrary(value="arg") InteropLibrary interop) throws UnsupportedMessageException {
            return interop.asShort(arg);
        }

        @Specialization(limit="3", replaces={"doShort"}, guards={"interop.isNumber(arg)"})
        @GenerateAOT.Exclude
        static short doNumber(NFIType type, Object arg, @CachedLibrary(value="arg") InteropLibrary interop, @Bind Node node, @Cached InlinedBranchProfile exception) throws UnsupportedTypeException {
            try {
                int val;
                if (interop.fitsInShort(arg)) {
                    return interop.asShort(arg);
                }
                if (interop.fitsInInt(arg) && Integer.compareUnsigned(val = interop.asInt(arg), 65536) < 0) {
                    return (short)val;
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            exception.enter(node);
            throw UnsupportedTypeException.create((Object[])new Object[]{arg});
        }

        @Specialization(limit="3", guards={"interop.isBoolean(arg)"})
        @GenerateAOT.Exclude
        short doBoolean(NFIType type, Object arg, @CachedLibrary(value="arg") InteropLibrary interop) {
            try {
                return interop.asBoolean(arg) ? (short)1 : 0;
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }

        @Fallback
        byte doFail(NFIType type, Object arg) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{arg});
        }
    }

    @GenerateUncached
    @GenerateNodeFactory
    @GenerateInline(value=false)
    static abstract class FromUInt8
    extends ConvertTypeNode {
        FromUInt8() {
        }

        @Specialization
        int doPrimitive(NFIType type, byte arg) {
            return arg & 0xFF;
        }

        @Fallback
        Object doOther(NFIType type, Object arg) {
            return arg;
        }
    }

    @GenerateUncached
    @GenerateNodeFactory
    @GenerateInline(value=false)
    static abstract class ToInt8
    extends ConvertTypeNode {
        ToInt8() {
        }

        @Specialization
        byte doPrimitive(NFIType type, byte arg) {
            return arg;
        }

        @Specialization
        byte doChar(NFIType type, char arg) {
            return (byte)arg;
        }

        @Specialization(limit="3", replaces={"doPrimitive"}, guards={"interop.fitsInByte(arg)"}, rewriteOn={UnsupportedMessageException.class})
        @GenerateAOT.Exclude
        byte doByte(NFIType type, Object arg, @CachedLibrary(value="arg") InteropLibrary interop) throws UnsupportedMessageException {
            return interop.asByte(arg);
        }

        @Specialization(limit="3", replaces={"doByte"}, guards={"interop.isNumber(arg)"})
        @GenerateAOT.Exclude
        static byte doNumber(NFIType type, Object arg, @CachedLibrary(value="arg") InteropLibrary interop, @Bind Node node, @Cached InlinedBranchProfile exception) throws UnsupportedTypeException {
            try {
                short val;
                if (interop.fitsInByte(arg)) {
                    return interop.asByte(arg);
                }
                if (interop.fitsInShort(arg) && Integer.compareUnsigned(val = interop.asShort(arg), 256) < 0) {
                    return (byte)val;
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            exception.enter(node);
            throw UnsupportedTypeException.create((Object[])new Object[]{arg});
        }

        @Specialization(limit="3", guards={"interop.isBoolean(arg)"})
        @GenerateAOT.Exclude
        byte doBoolean(NFIType type, Object arg, @CachedLibrary(value="arg") InteropLibrary interop) {
            try {
                return interop.asBoolean(arg) ? (byte)1 : 0;
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }

        @Fallback
        byte doFail(NFIType type, Object arg) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{arg});
        }
    }

    @GenerateUncached
    @GenerateNodeFactory
    @GenerateInline(value=false)
    static abstract class PointerFromNative
    extends ConvertTypeNode {
        PointerFromNative() {
        }

        @Specialization(guards={"arg == null"})
        Object doNull(NFIType type, Object arg) {
            return NFIPointer.nullPtr();
        }

        @Specialization
        Object doLong(NFIType type, long arg) {
            return NFIPointer.create(arg);
        }

        @Specialization(guards={"arg != null"})
        Object doObject(NFIType type, Object arg, @CachedLibrary(limit="1") BackendNativePointerLibrary library, @Bind Node node, @Cached InlinedConditionProfile isPointerProfile) {
            try {
                return isPointerProfile.profile(node, library.isPointer(arg)) ? NFIPointer.create(library.asPointer(arg)) : arg;
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
    }

    @GenerateUncached
    @GenerateNodeFactory
    @GenerateInline(value=false)
    static abstract class NullableToNative
    extends ConvertTypeNode {
        NullableToNative() {
        }

        @Specialization(limit="3", guards={"interop.isNull(arg)"})
        @GenerateAOT.Exclude
        Object doNull(NFIType type, Object arg, @CachedLibrary(value="arg") InteropLibrary interop) {
            return NFIPointer.nullPtr();
        }

        @Specialization(limit="3", guards={"!interop.isNull(arg)"})
        @GenerateAOT.Exclude
        Object doObject(NFIType type, Object arg, @CachedLibrary(value="arg") InteropLibrary interop) {
            return arg;
        }
    }

    @GenerateUncached
    @GenerateNodeFactory
    @GenerateInline(value=false)
    static abstract class Injected
    extends ConvertTypeNode {
        Injected() {
        }

        @Specialization
        Object doConvert(NFIType type, Object arg) {
            return type.runtimeData;
        }
    }

    @GenerateUncached
    @GenerateNodeFactory
    @GenerateInline(value=false)
    static abstract class Nothing
    extends ConvertTypeNode {
        Nothing() {
        }

        @Specialization
        Object doConvert(NFIType type, Object arg) {
            return NFIPointer.nullPtr();
        }
    }

    @GenerateUncached
    @GenerateNodeFactory
    @GenerateInline(value=false)
    static abstract class NopConvert
    extends ConvertTypeNode {
        NopConvert() {
        }

        @Specialization
        Object doConvert(NFIType type, Object arg) {
            return arg;
        }
    }
}

