/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalField;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.duckdb.DuckDBColumnType;
import org.duckdb.DuckDBColumnTypeMetaData;
import org.duckdb.DuckDBResultSet;
import org.duckdb.DuckDBResultSetMetaData;
import org.duckdb.DuckDBTimestamp;
import org.duckdb.JsonNode;

class DuckDBVector {
    private static final BigDecimal ULONG_MULTIPLIER = new BigDecimal("18446744073709551616");
    private static final DateTimeFormatter ERA_FORMAT = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR_OF_ERA).appendLiteral("-").appendValue(ChronoField.MONTH_OF_YEAR).appendLiteral("-").appendValue(ChronoField.DAY_OF_MONTH).appendOptional(new DateTimeFormatterBuilder().appendLiteral(" (").appendText((TemporalField)ChronoField.ERA, TextStyle.SHORT).appendLiteral(")").toFormatter()).toFormatter();
    private final DuckDBColumnTypeMetaData meta;
    protected final DuckDBColumnType duckdb_type;
    final int length;
    private final boolean[] nullmask;
    private ByteBuffer constlen_data = null;
    private Object[] varlen_data = null;
    String[] string_data = null;

    DuckDBVector(String duckdb_type, int length, boolean[] nullmask) {
        this.duckdb_type = DuckDBResultSetMetaData.TypeNameToType(duckdb_type);
        this.meta = this.duckdb_type == DuckDBColumnType.DECIMAL ? DuckDBColumnTypeMetaData.parseColumnTypeMetadata(duckdb_type) : null;
        this.length = length;
        this.nullmask = nullmask;
    }

    Object getObject(int idx) throws SQLException {
        if (this.check_and_null(idx)) {
            return null;
        }
        switch (this.duckdb_type) {
            case BOOLEAN: {
                return this.getBoolean(idx);
            }
            case TINYINT: {
                return this.getByte(idx);
            }
            case SMALLINT: {
                return this.getShort(idx);
            }
            case INTEGER: {
                return this.getInt(idx);
            }
            case BIGINT: {
                return this.getLong(idx);
            }
            case HUGEINT: {
                return this.getHugeint(idx);
            }
            case UHUGEINT: {
                return this.getUhugeint(idx);
            }
            case UTINYINT: {
                return this.getUint8(idx);
            }
            case USMALLINT: {
                return this.getUint16(idx);
            }
            case UINTEGER: {
                return this.getUint32(idx);
            }
            case UBIGINT: {
                return this.getUint64(idx);
            }
            case FLOAT: {
                return Float.valueOf(this.getFloat(idx));
            }
            case DOUBLE: {
                return this.getDouble(idx);
            }
            case DECIMAL: {
                return this.getBigDecimal(idx);
            }
            case TIME: {
                return this.getLocalTime(idx);
            }
            case TIME_WITH_TIME_ZONE: {
                return this.getOffsetTime(idx);
            }
            case DATE: {
                return this.getLocalDate(idx);
            }
            case TIMESTAMP: 
            case TIMESTAMP_NS: 
            case TIMESTAMP_S: 
            case TIMESTAMP_MS: {
                return this.getTimestamp(idx);
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                return this.getOffsetDateTime(idx);
            }
            case JSON: {
                return this.getJsonObject(idx);
            }
            case BLOB: {
                return this.getBlob(idx);
            }
            case UUID: {
                return this.getUuid(idx);
            }
            case MAP: {
                return this.getMap(idx);
            }
            case LIST: 
            case ARRAY: {
                return this.getArray(idx);
            }
            case STRUCT: {
                return this.getStruct(idx);
            }
            case UNION: {
                return this.getUnion(idx);
            }
        }
        return this.getLazyString(idx);
    }

    LocalTime getLocalTime(int idx) throws SQLException {
        if (this.check_and_null(idx)) {
            return null;
        }
        switch (this.duckdb_type) {
            case TIME: {
                long microseconds = this.getLongFromConstlen(idx);
                long nanoseconds = TimeUnit.MICROSECONDS.toNanos(microseconds);
                return LocalTime.ofNanoOfDay(nanoseconds);
            }
            case TIMESTAMP: 
            case TIMESTAMP_NS: 
            case TIMESTAMP_S: 
            case TIMESTAMP_MS: 
            case TIMESTAMP_WITH_TIME_ZONE: {
                LocalDateTime ldt = this.getLocalDateTimeFromTimestamp(idx, null);
                return ldt.toLocalTime();
            }
        }
        String lazyString = this.getLazyString(idx);
        if (lazyString == null) {
            return null;
        }
        return LocalTime.parse(lazyString);
    }

    LocalDate getLocalDate(int idx) throws SQLException {
        if (this.check_and_null(idx)) {
            return null;
        }
        switch (this.duckdb_type) {
            case DATE: {
                int day = this.getbuf(idx, 4).getInt();
                return LocalDate.ofEpochDay(day);
            }
            case TIMESTAMP: 
            case TIMESTAMP_NS: 
            case TIMESTAMP_S: 
            case TIMESTAMP_MS: 
            case TIMESTAMP_WITH_TIME_ZONE: {
                LocalDateTime ldt = this.getLocalDateTimeFromTimestamp(idx, null);
                return ldt.toLocalDate();
            }
        }
        String lazyString = this.getLazyString(idx);
        if (lazyString == null) {
            return null;
        }
        if ("infinity".equals(lazyString)) {
            return LocalDate.MAX;
        }
        if ("-infinity".equals(lazyString)) {
            return LocalDate.MIN;
        }
        return LocalDate.from(ERA_FORMAT.parse(lazyString));
    }

    BigDecimal getBigDecimal(int idx) throws SQLException {
        if (this.check_and_null(idx)) {
            return null;
        }
        if (this.isType(DuckDBColumnType.DECIMAL)) {
            switch (this.meta.type_size) {
                case 16: {
                    return new BigDecimal(this.getbuf(idx, 2).getShort()).scaleByPowerOfTen(this.meta.scale * -1);
                }
                case 32: {
                    return new BigDecimal(this.getbuf(idx, 4).getInt()).scaleByPowerOfTen(this.meta.scale * -1);
                }
                case 64: {
                    return new BigDecimal(this.getbuf(idx, 8).getLong()).scaleByPowerOfTen(this.meta.scale * -1);
                }
                case 128: {
                    ByteBuffer buf = this.getbuf(idx, 16);
                    long lower = buf.getLong();
                    long upper = buf.getLong();
                    return new BigDecimal(upper).multiply(ULONG_MULTIPLIER).add(new BigDecimal(Long.toUnsignedString(lower))).scaleByPowerOfTen(this.meta.scale * -1);
                }
            }
        }
        Object o = this.getObject(idx);
        return new BigDecimal(o.toString());
    }

    OffsetDateTime getOffsetDateTime(int idx) throws SQLException {
        if (this.check_and_null(idx)) {
            return null;
        }
        switch (this.duckdb_type) {
            case TIMESTAMP: 
            case TIMESTAMP_NS: 
            case TIMESTAMP_S: 
            case TIMESTAMP_MS: 
            case TIMESTAMP_WITH_TIME_ZONE: {
                LocalDateTime ldt = this.getLocalDateTimeFromTimestamp(idx, null);
                Instant instant = ldt.toInstant(ZoneOffset.UTC);
                ZoneId systemZone = ZoneId.systemDefault();
                ZoneOffset zoneOffset = systemZone.getRules().getOffset(instant);
                return ldt.atOffset(zoneOffset);
            }
        }
        String lazyString = this.getLazyString(idx);
        if (lazyString == null) {
            return null;
        }
        return OffsetDateTime.parse(lazyString);
    }

    Timestamp getTimestamp(int idx) throws SQLException {
        return this.getTimestamp(idx, null);
    }

    UUID getUuid(int idx) throws SQLException {
        if (this.check_and_null(idx)) {
            return null;
        }
        if (this.isType(DuckDBColumnType.UUID)) {
            ByteBuffer buffer = this.getbuf(idx, 16);
            long leastSignificantBits = buffer.getLong();
            long mostSignificantBits = buffer.getLong();
            return new UUID(mostSignificantBits ^= Long.MIN_VALUE, leastSignificantBits);
        }
        Object o = this.getObject(idx);
        return UUID.fromString(o.toString());
    }

    String getLazyString(int idx) {
        if (this.check_and_null(idx)) {
            return null;
        }
        return this.varlen_data[idx].toString();
    }

    Array getArray(int idx) throws SQLException {
        if (this.check_and_null(idx)) {
            return null;
        }
        if (this.isType(DuckDBColumnType.LIST) || this.isType(DuckDBColumnType.ARRAY)) {
            return (Array)this.varlen_data[idx];
        }
        throw new SQLFeatureNotSupportedException("getArray");
    }

    Map<Object, Object> getMap(int idx) throws SQLException {
        if (this.check_and_null(idx)) {
            return null;
        }
        if (!this.isType(DuckDBColumnType.MAP)) {
            throw new SQLFeatureNotSupportedException("getMap");
        }
        Object[] entries = (Object[])((Array)this.varlen_data[idx]).getArray();
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        for (Object entry : entries) {
            Object[] entry_val = ((Struct)entry).getAttributes();
            result.put(entry_val[0], entry_val[1]);
        }
        return result;
    }

    Blob getBlob(int idx) throws SQLException {
        if (this.check_and_null(idx)) {
            return null;
        }
        if (this.isType(DuckDBColumnType.BLOB)) {
            return new DuckDBResultSet.DuckDBBlobResult(ByteBuffer.wrap((byte[])this.varlen_data[idx]));
        }
        throw new SQLFeatureNotSupportedException("getBlob");
    }

    byte[] getBytes(int idx) throws SQLException {
        if (this.check_and_null(idx)) {
            return null;
        }
        if (this.isType(DuckDBColumnType.BLOB)) {
            return (byte[])this.varlen_data[idx];
        }
        throw new SQLFeatureNotSupportedException("getBytes");
    }

    JsonNode getJsonObject(int idx) {
        if (this.check_and_null(idx)) {
            return null;
        }
        String result = this.getLazyString(idx);
        return result == null ? null : new JsonNode(result);
    }

    Date getDate(int idx) throws SQLException {
        if (this.check_and_null(idx)) {
            return null;
        }
        switch (this.duckdb_type) {
            case DATE: {
                return Date.valueOf(this.getLocalDate(idx));
            }
            case TIMESTAMP: 
            case TIMESTAMP_NS: 
            case TIMESTAMP_S: 
            case TIMESTAMP_MS: 
            case TIMESTAMP_WITH_TIME_ZONE: {
                LocalDateTime ldt = this.getLocalDateTimeFromTimestamp(idx, null);
                LocalDateTime ldtTruncated = ldt.truncatedTo(ChronoUnit.DAYS);
                Timestamp tsTruncated = Timestamp.valueOf(ldtTruncated);
                return new Date(tsTruncated.getTime());
            }
        }
        String lazyString = this.getLazyString(idx);
        if (lazyString == null) {
            return null;
        }
        return Date.valueOf(lazyString);
    }

    OffsetTime getOffsetTime(int idx) throws SQLException {
        if (this.check_and_null(idx)) {
            return null;
        }
        switch (this.duckdb_type) {
            case TIME: {
                LocalTime lt = this.getLocalTime(idx);
                return lt.atOffset(ZoneOffset.UTC);
            }
            case TIME_WITH_TIME_ZONE: {
                long micros = this.getLongFromConstlen(idx);
                return DuckDBTimestamp.toOffsetTime(micros);
            }
            case TIMESTAMP: 
            case TIMESTAMP_NS: 
            case TIMESTAMP_S: 
            case TIMESTAMP_MS: 
            case TIMESTAMP_WITH_TIME_ZONE: {
                OffsetDateTime odt = this.getOffsetDateTime(idx);
                return odt.toOffsetTime();
            }
        }
        String lazyString = this.getLazyString(idx);
        if (lazyString == null) {
            return null;
        }
        return OffsetTime.parse(lazyString);
    }

    Time getTime(int idx) throws SQLException {
        return this.getTime(idx, null);
    }

    Time getTime(int idx, Calendar cal) throws SQLException {
        if (this.check_and_null(idx)) {
            return null;
        }
        switch (this.duckdb_type) {
            case TIME: {
                LocalTime lt = this.getLocalTime(idx);
                return Time.valueOf(lt);
            }
            case TIME_WITH_TIME_ZONE: {
                long micros = this.getLongFromConstlen(idx);
                OffsetTime ot = DuckDBTimestamp.toOffsetTime(micros);
                LocalTime lt = ot.toLocalTime();
                return Time.valueOf(lt);
            }
            case TIMESTAMP: 
            case TIMESTAMP_NS: 
            case TIMESTAMP_S: 
            case TIMESTAMP_MS: 
            case TIMESTAMP_WITH_TIME_ZONE: {
                Timestamp ts = this.getTimestamp(idx, cal);
                return new Time(ts.getTime());
            }
        }
        String lazyString = this.getLazyString(idx);
        if (lazyString == null) {
            return null;
        }
        return Time.valueOf(lazyString);
    }

    Boolean getBoolean(int idx) throws SQLException {
        if (this.check_and_null(idx)) {
            return false;
        }
        if (this.isType(DuckDBColumnType.BOOLEAN)) {
            return this.getbuf(idx, 1).get() == 1;
        }
        Object o = this.getObject(idx);
        if (o instanceof Number) {
            return ((Number)o).byteValue() == 1;
        }
        return Boolean.parseBoolean(o.toString());
    }

    protected ByteBuffer getbuf(int idx, int typeWidth) {
        ByteBuffer buf = this.constlen_data;
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.position(idx * typeWidth);
        return buf;
    }

    private long getLongFromConstlen(int idx) {
        ByteBuffer buf = this.getbuf(idx, 8);
        return buf.getLong();
    }

    protected boolean check_and_null(int idx) {
        return this.nullmask[idx];
    }

    long getLong(int idx) throws SQLException {
        if (this.check_and_null(idx)) {
            return 0L;
        }
        if (this.isType(DuckDBColumnType.BIGINT) || this.isType(DuckDBColumnType.TIMESTAMP) || this.isType(DuckDBColumnType.TIMESTAMP_WITH_TIME_ZONE)) {
            return this.getbuf(idx, 8).getLong();
        }
        Object o = this.getObject(idx);
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        return Long.parseLong(o.toString());
    }

    int getInt(int idx) throws SQLException {
        if (this.check_and_null(idx)) {
            return 0;
        }
        if (this.isType(DuckDBColumnType.INTEGER)) {
            return this.getbuf(idx, 4).getInt();
        }
        Object o = this.getObject(idx);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return Integer.parseInt(o.toString());
    }

    short getUint8(int idx) throws SQLException {
        if (this.check_and_null(idx)) {
            return 0;
        }
        if (this.isType(DuckDBColumnType.UTINYINT)) {
            ByteBuffer buf = ByteBuffer.allocate(2);
            this.getbuf(idx, 1).get(buf.array(), 1, 1);
            return buf.getShort();
        }
        throw new SQLFeatureNotSupportedException("getUint8");
    }

    long getUint32(int idx) throws SQLException {
        if (this.check_and_null(idx)) {
            return 0L;
        }
        if (this.isType(DuckDBColumnType.UINTEGER)) {
            ByteBuffer buf = ByteBuffer.allocate(8);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            this.getbuf(idx, 4).get(buf.array(), 0, 4);
            return buf.getLong();
        }
        throw new SQLFeatureNotSupportedException("getUint32");
    }

    int getUint16(int idx) throws SQLException {
        if (this.check_and_null(idx)) {
            return 0;
        }
        if (this.isType(DuckDBColumnType.USMALLINT)) {
            ByteBuffer buf = ByteBuffer.allocate(4);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            this.getbuf(idx, 2).get(buf.array(), 0, 2);
            return buf.getInt();
        }
        throw new SQLFeatureNotSupportedException("getUint16");
    }

    BigInteger getUint64(int idx) throws SQLException {
        if (this.check_and_null(idx)) {
            return BigInteger.ZERO;
        }
        if (this.isType(DuckDBColumnType.UBIGINT)) {
            byte[] buf_res = new byte[16];
            byte[] buf = new byte[8];
            this.getbuf(idx, 8).get(buf);
            for (int i = 0; i < 8; ++i) {
                buf_res[i + 8] = buf[7 - i];
            }
            return new BigInteger(buf_res);
        }
        throw new SQLFeatureNotSupportedException("getUint64");
    }

    double getDouble(int idx) throws SQLException {
        if (this.check_and_null(idx)) {
            return Double.NaN;
        }
        if (this.isType(DuckDBColumnType.DOUBLE)) {
            return this.getbuf(idx, 8).getDouble();
        }
        Object o = this.getObject(idx);
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        return Double.parseDouble(o.toString());
    }

    byte getByte(int idx) throws SQLException {
        if (this.check_and_null(idx)) {
            return 0;
        }
        if (this.isType(DuckDBColumnType.TINYINT)) {
            return this.getbuf(idx, 1).get();
        }
        Object o = this.getObject(idx);
        if (o instanceof Number) {
            return ((Number)o).byteValue();
        }
        return Byte.parseByte(o.toString());
    }

    short getShort(int idx) throws SQLException {
        if (this.check_and_null(idx)) {
            return 0;
        }
        if (this.isType(DuckDBColumnType.SMALLINT)) {
            return this.getbuf(idx, 2).getShort();
        }
        Object o = this.getObject(idx);
        if (o instanceof Number) {
            return ((Number)o).shortValue();
        }
        return Short.parseShort(o.toString());
    }

    BigInteger getHugeint(int idx) throws SQLException {
        if (this.check_and_null(idx)) {
            return BigInteger.ZERO;
        }
        if (this.isType(DuckDBColumnType.HUGEINT)) {
            byte[] buf = new byte[16];
            this.getbuf(idx, 16).get(buf);
            for (int i = 0; i < 8; ++i) {
                byte keep = buf[i];
                buf[i] = buf[15 - i];
                buf[15 - i] = keep;
            }
            return new BigInteger(buf);
        }
        Object o = this.getObject(idx);
        return new BigInteger(o.toString());
    }

    BigInteger getUhugeint(int idx) throws SQLException {
        if (this.check_and_null(idx)) {
            return BigInteger.ZERO;
        }
        if (this.isType(DuckDBColumnType.UHUGEINT)) {
            byte[] buf = new byte[16];
            this.getbuf(idx, 16).get(buf);
            for (int i = 0; i < 8; ++i) {
                byte keep = buf[i];
                buf[i] = buf[15 - i];
                buf[15 - i] = keep;
            }
            return new BigInteger(1, buf);
        }
        Object o = this.getObject(idx);
        return new BigInteger(o.toString());
    }

    float getFloat(int idx) throws SQLException {
        if (this.check_and_null(idx)) {
            return Float.NaN;
        }
        if (this.isType(DuckDBColumnType.FLOAT)) {
            return this.getbuf(idx, 4).getFloat();
        }
        Object o = this.getObject(idx);
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        return Float.parseFloat(o.toString());
    }

    private boolean isType(DuckDBColumnType columnType) {
        return this.duckdb_type == columnType;
    }

    private LocalDateTime getLocalDateTimeFromDate(int idx) throws SQLException {
        LocalDate ld = this.getLocalDate(idx);
        if (ld == null) {
            return null;
        }
        return ld.atStartOfDay();
    }

    Timestamp getTimestamp(int idx, Calendar calNullable) throws SQLException {
        if (this.check_and_null(idx)) {
            return null;
        }
        LocalDateTime ldt = this.duckdb_type == DuckDBColumnType.DATE ? this.getLocalDateTimeFromDate(idx) : this.getLocalDateTimeFromTimestamp(idx, calNullable);
        if (ldt != null) {
            return Timestamp.valueOf(ldt);
        }
        String lazyString = this.getLazyString(idx);
        if (lazyString == null) {
            return null;
        }
        return Timestamp.valueOf(lazyString);
    }

    LocalDateTime getLocalDateTime(int idx) throws SQLException {
        LocalDateTime ldt = this.duckdb_type == DuckDBColumnType.DATE ? this.getLocalDateTimeFromDate(idx) : this.getLocalDateTimeFromTimestamp(idx, null);
        if (ldt != null) {
            return ldt;
        }
        String lazyString = this.getLazyString(idx);
        if (lazyString == null) {
            return null;
        }
        return LocalDateTime.parse(lazyString);
    }

    private LocalDateTime getLocalDateTimeFromTimestamp(int idx, Calendar calNullable) throws SQLException {
        if (this.check_and_null(idx)) {
            return null;
        }
        ZoneId zoneIdNullable = calNullable != null ? calNullable.getTimeZone().toZoneId() : null;
        switch (this.duckdb_type) {
            case TIMESTAMP: {
                return DuckDBTimestamp.localDateTimeFromTimestamp(this.getLongFromConstlen(idx), ChronoUnit.MICROS, zoneIdNullable);
            }
            case TIMESTAMP_MS: {
                return DuckDBTimestamp.localDateTimeFromTimestamp(this.getLongFromConstlen(idx), ChronoUnit.MILLIS, zoneIdNullable);
            }
            case TIMESTAMP_NS: {
                return DuckDBTimestamp.localDateTimeFromTimestamp(this.getLongFromConstlen(idx), ChronoUnit.NANOS, zoneIdNullable);
            }
            case TIMESTAMP_S: {
                return DuckDBTimestamp.localDateTimeFromTimestamp(this.getLongFromConstlen(idx), ChronoUnit.SECONDS, zoneIdNullable);
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                return DuckDBTimestamp.localDateTimeFromTimestampWithTimezone(this.getLongFromConstlen(idx), ChronoUnit.MICROS, zoneIdNullable);
            }
        }
        return null;
    }

    Struct getStruct(int idx) {
        return this.check_and_null(idx) ? null : (Struct)this.varlen_data[idx];
    }

    Object getUnion(int idx) throws SQLException {
        if (this.check_and_null(idx)) {
            return null;
        }
        Struct struct = this.getStruct(idx);
        Object[] attributes = struct.getAttributes();
        short tag = (Short)attributes[0];
        return attributes[1 + tag];
    }
}

