/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.lib.PyLongAsIntNode;
import com.oracle.graal.python.lib.PyLongCheckNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class PyObjectAsFileDescriptor
extends PNodeWithContext {
    public abstract int execute(Frame var1, Node var2, Object var3);

    @Specialization
    static int doInt(Node inliningTarget, int object, @Cached.Exclusive @Cached PRaiseNode raise) {
        return PyObjectAsFileDescriptor.checkResult(object, inliningTarget, raise);
    }

    @Specialization(guards={"longCheckNode.execute(inliningTarget, object)"}, limit="1")
    static int doPyLong(VirtualFrame frame, Node inliningTarget, Object object, @Cached.Exclusive @Cached PyLongCheckNode longCheckNode, @Cached.Exclusive @Cached PyLongAsIntNode asIntNode, @Cached.Exclusive @Cached PRaiseNode raise) {
        return PyObjectAsFileDescriptor.checkResult(asIntNode.execute((Frame)frame, inliningTarget, object), inliningTarget, raise);
    }

    @Fallback
    static int doNotLong(VirtualFrame frame, Node inliningTarget, Object object, @Cached(inline=false) PyObjectLookupAttr lookupFileno, @Cached(inline=false) CallNode callFileno, @Cached.Exclusive @Cached PyLongCheckNode checkResultNode, @Cached.Exclusive @Cached PyLongAsIntNode asIntNode, @Cached.Exclusive @Cached PRaiseNode raise) {
        Object filenoMethod = lookupFileno.execute((Frame)frame, inliningTarget, object, SpecialMethodNames.T_FILENO);
        if (filenoMethod != PNone.NO_VALUE) {
            Object result = callFileno.execute((Frame)frame, filenoMethod, new Object[0]);
            if (checkResultNode.execute(inliningTarget, result)) {
                return PyObjectAsFileDescriptor.checkResult(asIntNode.execute((Frame)frame, inliningTarget, result), inliningTarget, raise);
            }
            throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.RETURNED_NON_INTEGER, "fileno()");
        }
        throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.ARG_MUST_BE_INT_OR_HAVE_FILENO_METHOD);
    }

    private static int checkResult(int result, Node inliningTarget, PRaiseNode raiseNode) {
        if (result < 0) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.S_CANNOT_BE_NEGATIVE_INTEGER_D, "file descriptor", result);
        }
        return result;
    }
}

