/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.lib.PyNumberAsSizeNodeGen;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.nodes.util.CastToJavaIntLossyNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateCached
@GenerateInline(inlineByDefault=true)
public abstract class PyNumberAsSizeNode
extends PNodeWithContext {
    public final int executeLossy(Frame frame, Node inliningTarget, Object object) {
        return this.execute(frame, inliningTarget, object, PNone.NO_VALUE);
    }

    public final int executeExactCached(Frame frame, Object object) {
        return this.execute(frame, this, object, (Object)PythonBuiltinClassType.OverflowError);
    }

    public final int executeExact(Frame frame, Node inliningTarget, Object object) {
        return this.execute(frame, inliningTarget, object, (Object)PythonBuiltinClassType.OverflowError);
    }

    public static int executeExactUncached(Object object) {
        return PyNumberAsSizeNode.getUncached().executeExact(null, null, object);
    }

    public final int executeExact(Frame frame, Object object, PythonBuiltinClassType errorClass) {
        return this.execute(frame, null, object, (Object)errorClass);
    }

    public final int executeExact(Frame frame, Node inliningTarget, Object object, PythonBuiltinClassType errorClass) {
        return this.execute(frame, inliningTarget, object, (Object)errorClass);
    }

    public abstract int execute(Frame var1, Node var2, Object var3, Object var4);

    @Specialization
    static int doInt(int object, Object errorClass) {
        return object;
    }

    @Specialization
    public static int doLongExact(Node inliningTarget, long object, PythonBuiltinClassType errorClass, @Cached PRaiseNode raiseNode) {
        int converted = (int)object;
        if (object == (long)converted) {
            return converted;
        }
        throw raiseNode.raise(inliningTarget, errorClass, ErrorMessages.CANNOT_FIT_P_INTO_INDEXSIZED_INT, object);
    }

    @Specialization
    static int doLongLossy(long object, PNone errorClass) {
        int converted = (int)object;
        if (object == (long)converted) {
            return converted;
        }
        return object > 0L ? Integer.MAX_VALUE : Integer.MIN_VALUE;
    }

    @HostCompilerDirectives.InliningCutoff
    @Fallback
    static int doObject(Frame frame, Object object, Object errorClass, @Cached(inline=false) PyNumberAsSizeObjectNode node) {
        return node.execute(frame, object, errorClass);
    }

    @NeverDefault
    public static PyNumberAsSizeNode create() {
        return PyNumberAsSizeNodeGen.create();
    }

    public static PyNumberAsSizeNode getUncached() {
        return PyNumberAsSizeNodeGen.getUncached();
    }

    @GenerateInline(value=false)
    @GenerateUncached
    static abstract class PyNumberAsSizeObjectNode
    extends Node {
        PyNumberAsSizeObjectNode() {
        }

        protected abstract int execute(Frame var1, Object var2, Object var3);

        @Specialization
        static int doObjectExact(VirtualFrame frame, Object object, PythonBuiltinClassType errorClass, @Bind Node inliningTarget, @Cached.Exclusive @Cached PyNumberIndexNode indexNode, @Cached PRaiseNode raiseNode, @Cached CastToJavaIntExactNode cast) {
            Object index = indexNode.execute((Frame)frame, inliningTarget, object);
            try {
                return cast.execute(inliningTarget, index);
            }
            catch (PException pe) {
                throw raiseNode.raise(inliningTarget, errorClass, ErrorMessages.CANNOT_FIT_P_INTO_INDEXSIZED_INT, object);
            }
            catch (CannotCastException cannotCastException) {
                throw CompilerDirectives.shouldNotReachHere((String)"PyNumberIndexNode didn't return a python integer");
            }
        }

        @Specialization
        static int doObjectLossy(VirtualFrame frame, Object object, PNone errorClass, @Bind Node inliningTarget, @Cached.Exclusive @Cached PyNumberIndexNode indexNode, @Cached CastToJavaIntLossyNode cast) {
            Object index = indexNode.execute((Frame)frame, inliningTarget, object);
            try {
                return cast.execute(inliningTarget, index);
            }
            catch (CannotCastException cannotCastException) {
                throw CompilerDirectives.shouldNotReachHere((String)"PyNumberIndexNode didn't return a python integer");
            }
        }
    }
}

