/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.cast.JSStringToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerAsLongNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(value=JSToIntegerAsLongNode.class)
public final class JSToIntegerAsLongNodeGen
extends JSToIntegerAsLongNode {
    @CompilerDirectives.CompilationFinal
    private int state_0_;
    @Node.Child
    private JSToNumberNode toNumberNode;
    @Node.Child
    private StringData string_cache;

    private JSToIntegerAsLongNodeGen() {
    }

    @Override
    public long executeLong(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0x1FFF) != 0) {
            JSToNumberNode toNumberNode_1;
            if ((state_0 & 1) != 0 && arg0Value instanceof Integer) {
                int arg0Value_ = (Integer)arg0Value;
                return JSToIntegerAsLongNode.doInteger(arg0Value_);
            }
            if ((state_0 & 2) != 0 && arg0Value instanceof Boolean) {
                boolean arg0Value_ = (Boolean)arg0Value;
                return JSToIntegerAsLongNode.doBoolean(arg0Value_);
            }
            if ((state_0 & 4) != 0 && arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                return JSToIntegerAsLongNode.doLong(arg0Value_);
            }
            if ((state_0 & 8) != 0 && arg0Value instanceof SafeInteger) {
                SafeInteger arg0Value_ = (SafeInteger)arg0Value;
                return JSToIntegerAsLongNode.doSafeInteger(arg0Value_);
            }
            if ((state_0 & 0x30) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0xE000) >>> 13, arg0Value)) {
                double arg0Value_ = JSTypesGen.asImplicitDouble((state_0 & 0xE000) >>> 13, arg0Value);
                if ((state_0 & 0x10) != 0 && !Double.isInfinite(arg0Value_)) {
                    return JSToIntegerAsLongNode.doDouble(arg0Value_);
                }
                if ((state_0 & 0x20) != 0 && Double.isInfinite(arg0Value_)) {
                    return JSToIntegerAsLongNode.doDoubleInfinite(arg0Value_);
                }
            }
            if ((state_0 & 0xC0) != 0) {
                if ((state_0 & 0x40) != 0 && JSGuards.isUndefined(arg0Value)) {
                    return JSToIntegerAsLongNode.doUndefined(arg0Value);
                }
                if ((state_0 & 0x80) != 0 && JSGuards.isJSNull(arg0Value)) {
                    return JSToIntegerAsLongNode.doNull(arg0Value);
                }
            }
            if ((state_0 & 0x100) != 0 && arg0Value instanceof Symbol) {
                Symbol arg0Value_ = (Symbol)arg0Value;
                return this.doSymbol(arg0Value_);
            }
            if ((state_0 & 0x200) != 0 && arg0Value instanceof BigInt) {
                BigInt arg0Value_ = (BigInt)arg0Value;
                return this.doBigInt(arg0Value_);
            }
            if ((state_0 & 0x400) != 0 && arg0Value instanceof TruffleString) {
                TruffleString arg0Value_ = (TruffleString)arg0Value;
                StringData s10_ = this.string_cache;
                if (s10_ != null) {
                    return this.doString(arg0Value_, s10_.nestedToIntegerNode_, s10_.stringToNumberNode_);
                }
            }
            if ((state_0 & 0x800) != 0 && arg0Value instanceof JSObject) {
                JSObject arg0Value_ = (JSObject)((Object)arg0Value);
                JSToNumberNode toNumberNode_ = this.toNumberNode;
                if (toNumberNode_ != null) {
                    return this.doJSObject(arg0Value_, toNumberNode_);
                }
            }
            if ((state_0 & 0x1000) != 0 && (toNumberNode_1 = this.toNumberNode) != null && (JSGuards.isJSObject(arg0Value) || JSGuards.isForeignObject(arg0Value))) {
                return this.doJSOrForeignObject(arg0Value, toNumberNode_1);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private long executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            this.state_0_ = state_0 |= 1;
            return JSToIntegerAsLongNode.doInteger(arg0Value_);
        }
        if (arg0Value instanceof Boolean) {
            boolean arg0Value_ = (Boolean)arg0Value;
            this.state_0_ = state_0 |= 2;
            return JSToIntegerAsLongNode.doBoolean(arg0Value_);
        }
        if (arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            this.state_0_ = state_0 |= 4;
            return JSToIntegerAsLongNode.doLong(arg0Value_);
        }
        if (arg0Value instanceof SafeInteger) {
            SafeInteger arg0Value_ = (SafeInteger)arg0Value;
            this.state_0_ = state_0 |= 8;
            return JSToIntegerAsLongNode.doSafeInteger(arg0Value_);
        }
        int doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value);
        if (doubleCast0 != 0) {
            double arg0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
            if (!Double.isInfinite(arg0Value_)) {
                state_0 |= doubleCast0 << 13;
                this.state_0_ = state_0 |= 0x10;
                return JSToIntegerAsLongNode.doDouble(arg0Value_);
            }
            if (Double.isInfinite(arg0Value_)) {
                state_0 |= doubleCast0 << 13;
                this.state_0_ = state_0 |= 0x20;
                return JSToIntegerAsLongNode.doDoubleInfinite(arg0Value_);
            }
        }
        if (JSGuards.isUndefined(arg0Value)) {
            this.state_0_ = state_0 |= 0x40;
            return JSToIntegerAsLongNode.doUndefined(arg0Value);
        }
        if (JSGuards.isJSNull(arg0Value)) {
            this.state_0_ = state_0 |= 0x80;
            return JSToIntegerAsLongNode.doNull(arg0Value);
        }
        if (arg0Value instanceof Symbol) {
            Symbol arg0Value_ = (Symbol)arg0Value;
            this.state_0_ = state_0 |= 0x100;
            return this.doSymbol(arg0Value_);
        }
        if (arg0Value instanceof BigInt) {
            BigInt arg0Value_ = (BigInt)arg0Value;
            this.state_0_ = state_0 |= 0x200;
            return this.doBigInt(arg0Value_);
        }
        if (arg0Value instanceof TruffleString) {
            TruffleString arg0Value_ = (TruffleString)arg0Value;
            StringData s10_ = (StringData)this.insert(new StringData());
            JSToIntegerAsLongNode nestedToIntegerNode__ = (JSToIntegerAsLongNode)s10_.insert(JSToIntegerAsLongNode.create());
            Objects.requireNonNull(nestedToIntegerNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s10_.nestedToIntegerNode_ = nestedToIntegerNode__;
            JSStringToNumberNode stringToNumberNode__ = (JSStringToNumberNode)s10_.insert(JSStringToNumberNode.create());
            Objects.requireNonNull(stringToNumberNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s10_.stringToNumberNode_ = stringToNumberNode__;
            VarHandle.storeStoreFence();
            this.string_cache = s10_;
            this.state_0_ = state_0 |= 0x400;
            return this.doString(arg0Value_, nestedToIntegerNode__, stringToNumberNode__);
        }
        if ((state_0 & 0x1000) == 0 && arg0Value instanceof JSObject) {
            JSToNumberNode toNumberNode_;
            JSObject arg0Value_ = (JSObject)((Object)arg0Value);
            JSToNumberNode toNumberNode__shared = this.toNumberNode;
            if (toNumberNode__shared != null) {
                toNumberNode_ = toNumberNode__shared;
            } else {
                toNumberNode_ = (JSToNumberNode)this.insert(JSToNumberNode.create());
                if (toNumberNode_ == null) {
                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (this.toNumberNode == null) {
                VarHandle.storeStoreFence();
                this.toNumberNode = toNumberNode_;
            }
            this.state_0_ = state_0 |= 0x800;
            return this.doJSObject(arg0Value_, toNumberNode_);
        }
        if (JSGuards.isJSObject(arg0Value) || JSGuards.isForeignObject(arg0Value)) {
            JSToNumberNode toNumberNode_1;
            JSToNumberNode toNumberNode_1_shared = this.toNumberNode;
            if (toNumberNode_1_shared != null) {
                toNumberNode_1 = toNumberNode_1_shared;
            } else {
                toNumberNode_1 = (JSToNumberNode)this.insert(JSToNumberNode.create());
                if (toNumberNode_1 == null) {
                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (this.toNumberNode == null) {
                VarHandle.storeStoreFence();
                this.toNumberNode = toNumberNode_1;
            }
            state_0 &= 0xFFFFF7FF;
            this.state_0_ = state_0 |= 0x1000;
            return this.doJSOrForeignObject(arg0Value, toNumberNode_1);
        }
        throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value});
    }

    @NeverDefault
    public static JSToIntegerAsLongNode create() {
        return new JSToIntegerAsLongNodeGen();
    }

    @GeneratedBy(value=JSToIntegerAsLongNode.class)
    @DenyReplace
    private static final class StringData
    extends Node
    implements DSLSupport.SpecializationDataNode {
        @Node.Child
        JSToIntegerAsLongNode nestedToIntegerNode_;
        @Node.Child
        JSStringToNumberNode stringToNumberNode_;

        StringData() {
        }
    }
}

