/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.hashlib;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.hashlib.DigestObject;
import com.oracle.graal.python.builtins.modules.hashlib.DigestObjectBuiltins;
import com.oracle.graal.python.builtins.modules.hashlib.HashlibModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.hashlib.HashlibModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.common.EconomicMapStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.ssl.LazyBouncyCastleProvider;
import com.oracle.graal.python.lib.PyLongAsLongNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromPythonObjectNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.statement.AbstractImportNode;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jcajce.provider.util.DigestFactory;

@CoreFunctions(defineModule="_hashlib")
public final class HashlibModuleBuiltins
extends PythonBuiltins {
    private static final String OPENSSL_PREFIX = "openssl_";
    private static final Map<String, String> NAME_MAPPINGS = Map.of("sha3_224", "sha3-sha224", "sha3_256", "sha3-sha256", "sha3_384", "sha3-sha384", "sha3_512", "sha3-sha512", "shake_128", "SHAKE128", "shake_256", "SHAKE256");
    private static final String[] DIGEST_ALIASES = new String[]{"md5", "_md5", "sha1", "_sha1", "sha224", "_sha2", "sha256", "_sha2", "sha384", "_sha2", "sha512", "_sha2", "sha3_224", "_sha3", "sha3_256", "_sha3", "sha3_384", "_sha3", "sha3_512", "_sha3", "shake_128", "_sha3", "shake_256", "_sha3"};

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return HashlibModuleBuiltinsFactory.getFactories();
    }

    private void addDigestAlias(PythonModule self, PythonModule mod, ReadAttributeFromPythonObjectNode readNode, EconomicMapStorage storage, String digest) {
        TruffleString tsDigest = PythonUtils.toTruffleStringUncached(digest);
        Object function = readNode.execute(mod, tsDigest);
        if (function != PNone.NO_VALUE) {
            self.setAttribute(PythonUtils.toTruffleStringUncached(OPENSSL_PREFIX + digest), function);
            HashingStorageNodes.HashingStorageSetItem.executeUncached(storage, function, tsDigest);
        }
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        PythonLanguage language = core.getLanguage();
        PythonModule self = core.lookupBuiltinModule(BuiltinNames.T_HASHLIB);
        EconomicMapStorage storage = EconomicMapStorage.create();
        LazyBouncyCastleProvider.initProvider();
        ArrayList<String> digests = new ArrayList<String>();
        for (Provider provider : Security.getProviders()) {
            for (Provider.Service service : provider.getServices()) {
                if (!service.getType().equalsIgnoreCase(MessageDigest.class.getSimpleName())) continue;
                digests.add(service.getAlgorithm());
            }
        }
        EconomicMapStorage algos = EconomicMapStorage.create(digests.size());
        for (String digest : digests) {
            algos.putUncached(digest, (Object)PNone.NONE);
        }
        self.setAttribute(PythonUtils.tsLiteral("openssl_md_meth_names"), PFactory.createFrozenSet(language, algos));
        self.setAttribute(PythonUtils.tsLiteral("_constructors"), PFactory.createMappingproxy(language, PFactory.createDict(language, storage)));
        ReadAttributeFromPythonObjectNode readNode = ReadAttributeFromPythonObjectNode.getUncached();
        PythonModule sha3module = AbstractImportNode.importModule(BuiltinNames.T_SHA3);
        for (int i = 0; i < DIGEST_ALIASES.length; i += 2) {
            String module = DIGEST_ALIASES[i + 1];
            PythonModule mod = module.equals("_sha3") ? sha3module : core.lookupBuiltinModule(PythonUtils.toTruffleStringUncached(module));
            this.addDigestAlias(self, mod, readNode, storage, DIGEST_ALIASES[i]);
        }
        self.setModuleState(storage);
    }

    @CompilerDirectives.TruffleBoundary
    static Mac createMac(TruffleString digest, byte[] key, int keyLen, byte[] msg, int msgLen) throws NoSuchAlgorithmException, InvalidKeyException {
        String inputName = digest.toJavaStringUncached().toLowerCase();
        String algorithm = "hmac" + NAME_MAPPINGS.getOrDefault(inputName, inputName);
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, 0, keyLen, algorithm);
        Mac mac = Mac.getInstance(algorithm);
        mac.init(secretKeySpec);
        if (msg != null) {
            mac.update(msg, 0, msgLen);
        }
        return mac;
    }

    @Builtin(name="pbkdf2_hmac", minNumOfPositionalArgs=4, parameterNames={"hash_name", "password", "salt", "iterations", "dklen"})
    @GenerateNodeFactory
    @ArgumentsClinic(value={@ArgumentClinic(name="hash_name", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="password", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer), @ArgumentClinic(name="salt", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer), @ArgumentClinic(name="iterations", conversion=ArgumentClinic.ClinicConversion.Long)})
    static abstract class Pbkdf2HmacNode
    extends PythonClinicBuiltinNode {
        Pbkdf2HmacNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return HashlibModuleBuiltinsClinicProviders.Pbkdf2HmacNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static Object pbkdf2(VirtualFrame frame, TruffleString hashName, Object password, Object salt, long iterations, Object dklenObj, @Bind Node inliningTarget, @Bind PythonLanguage language, @CachedLibrary(value="password") PythonBufferAccessLibrary passwordLib, @CachedLibrary(value="salt") PythonBufferAccessLibrary saltLib, @Cached PyLongAsLongNode asLongNode, @Cached InlinedConditionProfile noDklenProfile, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached PRaiseNode raiseNode) {
            try {
                Digest digest = Pbkdf2HmacNode.getDigest(toJavaStringNode.execute((AbstractTruffleString)hashName));
                if (digest == null) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.UnsupportedDigestmodError, ErrorMessages.UNSUPPORTED_HASH_TYPE, hashName);
                }
                if (iterations < 1L) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.ITERATION_VALUE_MUST_BE_GREATER_THAN_ZERO);
                }
                if (iterations > Integer.MAX_VALUE) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.OverflowError, ErrorMessages.ITERATION_VALUE_IS_TOO_GREAT);
                }
                long dklen = noDklenProfile.profile(inliningTarget, PGuards.isPNone(dklenObj)) ? (long)digest.getDigestSize() : asLongNode.execute((Frame)frame, inliningTarget, dklenObj);
                if ((dklen *= 8L) < 1L) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.KEY_LENGTH_MUST_BE_GREATER_THAN_ZERO);
                }
                if (dklen > Integer.MAX_VALUE) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.OverflowError, ErrorMessages.ITERATION_VALUE_IS_TOO_GREAT);
                }
                byte[] passwordBytes = passwordLib.getInternalOrCopiedExactByteArray(password);
                byte[] saltBytes = saltLib.getInternalOrCopiedExactByteArray(salt);
                PBytes pBytes = PFactory.createBytes(language, Pbkdf2HmacNode.generate(digest, passwordBytes, saltBytes, (int)iterations, (int)dklen));
                return pBytes;
            }
            finally {
                passwordLib.release(password);
                saltLib.release(salt);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static Digest getDigest(String name) {
            name = name.toLowerCase();
            return DigestFactory.getDigest((String)NAME_MAPPINGS.getOrDefault(name, name));
        }

        @CompilerDirectives.TruffleBoundary
        private static byte[] generate(Digest digest, byte[] password, byte[] salt, int iterations, int dklen) {
            PKCS5S2ParametersGenerator generator = new PKCS5S2ParametersGenerator(digest);
            generator.init(password, salt, iterations);
            CipherParameters cipherParameters = generator.generateDerivedParameters(dklen);
            if (!(cipherParameters instanceof KeyParameter)) {
                throw CompilerDirectives.shouldNotReachHere((String)"unexpected cipher parameters");
            }
            KeyParameter keyParameter = (KeyParameter)cipherParameters;
            return keyParameter.getKey();
        }
    }

    @Builtin(name="get_fips_mode")
    @GenerateNodeFactory
    static abstract class GetFipsNode
    extends PythonBuiltinNode {
        GetFipsNode() {
        }

        @Specialization
        static int getFips() {
            return 0;
        }
    }

    @Builtin(name="new", minNumOfPositionalArgs=1, parameterNames={"name", "string"}, keywordOnlyNames={"usedforsecurity"})
    @GenerateNodeFactory
    @ArgumentsClinic(value={@ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="usedforsecurity", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true")})
    static abstract class NewNode
    extends PythonClinicBuiltinNode {
        NewNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return HashlibModuleBuiltinsClinicProviders.NewNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object newDigest(VirtualFrame frame, TruffleString name, Object buffer, boolean usedForSecurity, @Bind Node inliningTarget, @Cached CreateDigestNode createNode, @Cached CastToJavaStringNode castStr) {
            String pythonDigestName = NewNode.getPythonName(castStr.execute(name));
            String javaDigestName = NewNode.getJavaName(pythonDigestName);
            PythonBuiltinClassType digestType = NewNode.getTypeFor(javaDigestName);
            return createNode.execute(frame, inliningTarget, digestType, pythonDigestName, javaDigestName, buffer);
        }

        private static PythonBuiltinClassType getTypeFor(String digestName) {
            switch (digestName) {
                case "SHAKE256": 
                case "SHAKE128": {
                    return PythonBuiltinClassType.HashlibHashXof;
                }
            }
            return PythonBuiltinClassType.HashlibHash;
        }

        @CompilerDirectives.TruffleBoundary
        private static String getPythonName(String inputName) {
            return inputName.toLowerCase();
        }

        @CompilerDirectives.TruffleBoundary
        private static String getJavaName(String inputName) {
            return NAME_MAPPINGS.getOrDefault(inputName, inputName);
        }
    }

    @GenerateUncached(value=false)
    @GenerateCached(value=false)
    @GenerateInline
    static abstract class CreateDigestNode
    extends Node {
        CreateDigestNode() {
        }

        abstract Object execute(VirtualFrame var1, Node var2, PythonBuiltinClassType var3, String var4, String var5, Object var6);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object doIt(VirtualFrame frame, Node inliningTarget, PythonBuiltinClassType type, String pythonName, String javaName, Object value, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(limit="2") PythonBufferAcquireLibrary acquireLib, @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib, @Cached PRaiseNode raise) {
            Object buffer;
            if (value instanceof PNone) {
                buffer = null;
            } else if (acquireLib.hasBuffer(value)) {
                buffer = acquireLib.acquireReadonly(value, frame, indirectCallData);
            } else {
                throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.BYTESLIKE_OBJ_REQUIRED, value);
            }
            try {
                MessageDigest digest;
                byte[] bytes = buffer == null ? null : bufferLib.getInternalOrCopiedByteArray(buffer);
                int bytesLen = buffer == null ? 0 : bufferLib.getBufferLength(buffer);
                try {
                    digest = CreateDigestNode.createDigest(javaName, bytes, bytesLen);
                }
                catch (NoSuchAlgorithmException e) {
                    throw raise.raise(inliningTarget, PythonBuiltinClassType.UnsupportedDigestmodError, e);
                }
                DigestObject digestObject = PFactory.createDigestObject(PythonLanguage.get(inliningTarget), type, pythonName, digest);
                return digestObject;
            }
            finally {
                if (buffer != null) {
                    bufferLib.release(buffer, frame, indirectCallData);
                }
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static MessageDigest createDigest(String name, byte[] bytes, int bytesLen) throws NoSuchAlgorithmException {
            MessageDigest digest = MessageDigest.getInstance(name);
            if (bytes != null) {
                digest.update(bytes, 0, bytesLen);
            }
            return digest;
        }
    }

    @Builtin(name="hmac_new", declaresExplicitSelf=true, parameterNames={"$mod", "key", "msg", "digestmod"}, minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class HmacNewNode
    extends PythonQuaternaryBuiltinNode {
        private static final TruffleString HMAC_PREFIX = PythonUtils.tsLiteral("hmac-");

        HmacNewNode() {
        }

        @Specialization
        static Object hmacNewError(PythonModule self, Object key, Object msg, PNone digest, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.MISSING_D_REQUIRED_S_ARGUMENT_S_POS, "hmac_new", "digestmod", 3);
        }

        @Specialization(guards={"!isString(digestmod)"})
        static Object hmacNewFromFunction(VirtualFrame frame, PythonModule self, Object key, Object msg, Object digestmod, @Bind Node inliningTarget, @Cached HashingStorageNodes.HashingStorageGetItem getItemNode, @Cached.Exclusive @Cached CastToTruffleStringNode castStr, @Cached.Exclusive @Cached CastToJavaStringNode castJStr, @Cached.Shared(value="concatStr") @Cached TruffleString.ConcatNode concatStr, @Cached.Shared(value="acquireLib") @CachedLibrary(limit="2") PythonBufferAcquireLibrary acquireLib, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            EconomicMapStorage constructors = self.getModuleState(EconomicMapStorage.class);
            Object name = getItemNode.execute((Frame)frame, inliningTarget, constructors, digestmod);
            if (name != null) {
                assert (name instanceof TruffleString);
                return HmacNewNode.hmacNew(self, key, msg, name, inliningTarget, castStr, castJStr, concatStr, acquireLib, bufferLib, raiseNode);
            }
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.UnsupportedDigestmodError);
        }

        /*
         * Loose catch block
         */
        @Specialization(guards={"isString(digestmodObj)"})
        static Object hmacNew(PythonModule self, Object keyObj, Object msgObj, Object digestmodObj, @Bind Node inliningTarget, @Cached.Exclusive @Cached CastToTruffleStringNode castStr, @Cached.Exclusive @Cached CastToJavaStringNode castJStr, @Cached.Shared(value="concatStr") @Cached TruffleString.ConcatNode concatStr, @Cached.Shared(value="acquireLib") @CachedLibrary(limit="2") PythonBufferAcquireLibrary acquireLib, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            TruffleString digestmod = castStr.execute(inliningTarget, digestmodObj);
            if (!acquireLib.hasBuffer(keyObj)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.BYTESLIKE_OBJ_REQUIRED, keyObj);
            }
            Object key = acquireLib.acquireReadonly(keyObj);
            try {
                Object msg;
                if (msgObj instanceof PNone) {
                    msg = null;
                } else if (acquireLib.hasBuffer(msgObj)) {
                    msg = acquireLib.acquireReadonly(msgObj);
                } else {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.BYTESLIKE_OBJ_REQUIRED, msgObj);
                }
                try {
                    byte[] msgBytes = msg == null ? null : bufferLib.getInternalOrCopiedByteArray(msg);
                    int msgLen = msg == null ? 0 : bufferLib.getBufferLength(msg);
                    Mac mac = HashlibModuleBuiltins.createMac(digestmod, bufferLib.getInternalOrCopiedByteArray(key), bufferLib.getBufferLength(key), msgBytes, msgLen);
                    DigestObject digestObject = PFactory.createDigestObject(PythonLanguage.get(inliningTarget), PythonBuiltinClassType.HashlibHmac, castJStr.execute(concatStr.execute((AbstractTruffleString)HMAC_PREFIX, (AbstractTruffleString)digestmod, PythonUtils.TS_ENCODING, true)), mac);
                    return digestObject;
                }
                catch (InvalidKeyException | NoSuchAlgorithmException e) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.UnsupportedDigestmodError, e);
                }
                finally {
                    if (msg != null) {
                        bufferLib.release(msg);
                    }
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                bufferLib.release(key);
            }
        }
    }

    @Builtin(name="hmac_digest", declaresExplicitSelf=true, parameterNames={"$mod", "key", "msg", "digest"})
    @GenerateNodeFactory
    static abstract class HmacDigestNode
    extends PythonQuaternaryBuiltinNode {
        HmacDigestNode() {
        }

        @Specialization
        static Object hmacDigest(VirtualFrame frame, PythonModule self, Object key, Object msg, Object digest, @Bind Node inliningTarget, @Cached HmacNewNode newNode2, @Cached DigestObjectBuiltins.DigestNode digestNode, @Cached PRaiseNode raiseNode) {
            if (msg instanceof PNone) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.BYTESLIKE_OBJ_REQUIRED, msg);
            }
            Object hmacObject = newNode2.execute(frame, self, key, msg, digest);
            return digestNode.execute(frame, hmacObject);
        }
    }

    @Builtin(name="compare_digest", parameterNames={"a", "b"})
    @GenerateNodeFactory
    static abstract class CompareDigestNode
    extends PythonBinaryBuiltinNode {
        CompareDigestNode() {
        }

        @Specialization(guards={"isString(a)", "isString(b)"})
        static Object cmpStrings(Object a, Object b, @Bind Node inliningTarget, @Cached TruffleString.CopyToByteArrayNode getByteArrayNode, @Cached TruffleString.GetCodeRangeNode getCodeRangeNode, @Cached CastToTruffleStringNode castA, @Cached CastToTruffleStringNode castB, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            TruffleString tsA = castA.execute(inliningTarget, a);
            TruffleString tsB = castB.execute(inliningTarget, b);
            TruffleString.CodeRange crA = getCodeRangeNode.execute((AbstractTruffleString)tsA, PythonUtils.TS_ENCODING);
            TruffleString.CodeRange crB = getCodeRangeNode.execute((AbstractTruffleString)tsB, PythonUtils.TS_ENCODING);
            if (!crA.isSubsetOf(TruffleString.CodeRange.ASCII) || !crB.isSubsetOf(TruffleString.CodeRange.ASCII)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.COMPARING_STRINGS_WITH_NON_ASCII);
            }
            byte[] bytesA = getByteArrayNode.execute((AbstractTruffleString)tsA, PythonUtils.TS_ENCODING);
            byte[] bytesB = getByteArrayNode.execute((AbstractTruffleString)castB.execute(inliningTarget, b), PythonUtils.TS_ENCODING);
            return CompareDigestNode.cmp(bytesA, bytesB);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!isString(a) || !isString(b)"})
        static boolean cmpBuffers(VirtualFrame frame, Object a, Object b, @Bind Node inliningTarget, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(limit="3") PythonBufferAcquireLibrary acquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary accessLib, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            if (acquireLib.hasBuffer(a) && acquireLib.hasBuffer(b)) {
                Object bufferA = acquireLib.acquireReadonly(a, frame, indirectCallData);
                try {
                    Object bufferB = acquireLib.acquireReadonly(b, frame, indirectCallData);
                    try {
                        byte[] bytesA = accessLib.getInternalOrCopiedByteArray(bufferA);
                        byte[] bytesB = accessLib.getInternalOrCopiedByteArray(bufferB);
                        boolean bl = CompareDigestNode.cmp(bytesA, bytesB);
                        accessLib.release(bufferB, frame, indirectCallData);
                        return bl;
                    }
                    catch (Throwable throwable) {
                        accessLib.release(bufferB, frame, indirectCallData);
                        throw throwable;
                    }
                }
                finally {
                    accessLib.release(bufferA, frame, indirectCallData);
                }
            }
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.UNSUPPORTED_OPERAND_TYPES_OR_COMBINATION_OF_TYPES, a, b);
        }

        @CompilerDirectives.TruffleBoundary
        static boolean cmp(byte[] a, byte[] b) {
            return MessageDigest.isEqual(a, b);
        }
    }
}

