/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.extern.decimal;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.firebirdsql.extern.decimal.Decimal;
import org.firebirdsql.extern.decimal.DecimalCodec;
import org.firebirdsql.extern.decimal.DecimalFactory;
import org.firebirdsql.extern.decimal.DecimalFormat;
import org.firebirdsql.extern.decimal.DecimalType;
import org.firebirdsql.extern.decimal.OverflowHandling;

public final class Decimal32
extends Decimal<Decimal32> {
    public static final Decimal32 POSITIVE_INFINITY = new Decimal32(1, DecimalType.INFINITY);
    public static final Decimal32 NEGATIVE_INFINITY = new Decimal32(-1, DecimalType.INFINITY);
    public static final Decimal32 POSITIVE_NAN = new Decimal32(1, DecimalType.NAN);
    public static final Decimal32 NEGATIVE_NAN = new Decimal32(-1, DecimalType.NAN);
    public static final Decimal32 POSITIVE_SIGNALING_NAN = new Decimal32(1, DecimalType.SIGNALING_NAN);
    public static final Decimal32 NEGATIVE_SIGNALING_NAN = new Decimal32(-1, DecimalType.SIGNALING_NAN);
    private static final Decimal32Factory DECIMAL_32_FACTORY = new Decimal32Factory();
    private static final DecimalCodec<Decimal32> DECIMAL_32_CODEC = new DecimalCodec<Decimal32>(DECIMAL_32_FACTORY);

    private Decimal32(int signum, DecimalType decimalType) {
        super(signum, decimalType);
    }

    private Decimal32(int signum, BigDecimal bigDecimal) {
        super(signum, bigDecimal);
    }

    @Override
    DecimalCodec<Decimal32> getDecimalCodec() {
        return DECIMAL_32_CODEC;
    }

    @Override
    DecimalFactory<Decimal32> getDecimalFactory() {
        return DECIMAL_32_FACTORY;
    }

    public static Decimal32 parseBytes(byte[] decBytes) {
        return DECIMAL_32_CODEC.parseBytes(decBytes);
    }

    public static Decimal32 valueOf(BigDecimal value) {
        return Decimal32.valueOf(value, OverflowHandling.ROUND_TO_INFINITY);
    }

    public static Decimal32 valueOf(BigDecimal value, OverflowHandling overflowHandling) {
        return (Decimal32)DECIMAL_32_FACTORY.valueOf(value, overflowHandling);
    }

    public static Decimal32 valueOf(BigInteger value) {
        return Decimal32.valueOf(value, OverflowHandling.ROUND_TO_INFINITY);
    }

    public static Decimal32 valueOf(BigInteger value, OverflowHandling overflowHandling) {
        return (Decimal32)DECIMAL_32_FACTORY.valueOf(value, overflowHandling);
    }

    public static Decimal32 valueOfExact(BigInteger value) {
        return (Decimal32)DECIMAL_32_FACTORY.valueOfExact(value);
    }

    public static Decimal32 valueOf(double value) {
        return Decimal32.valueOf(value, OverflowHandling.ROUND_TO_INFINITY);
    }

    public static Decimal32 valueOf(double value, OverflowHandling overflowHandling) {
        return (Decimal32)DECIMAL_32_FACTORY.valueOf(value, overflowHandling);
    }

    public static Decimal32 valueOf(Decimal<?> decimal) {
        return Decimal32.valueOf(decimal, OverflowHandling.ROUND_TO_INFINITY);
    }

    public static Decimal32 valueOf(Decimal<?> decimal, OverflowHandling overflowHandling) {
        if (decimal instanceof Decimal32) {
            return (Decimal32)decimal;
        }
        return (Decimal32)DECIMAL_32_FACTORY.valueOf(decimal, overflowHandling);
    }

    public static Decimal32 valueOf(String value) {
        return Decimal32.valueOf(value, OverflowHandling.ROUND_TO_INFINITY);
    }

    public static Decimal32 valueOf(String value, OverflowHandling overflowHandling) {
        return (Decimal32)DECIMAL_32_FACTORY.valueOf(value, overflowHandling);
    }

    private static class Decimal32Factory
    extends Decimal.AbstractDecimalFactory<Decimal32> {
        private Decimal32Factory() {
            super(Decimal32.class, DecimalFormat.Decimal32, POSITIVE_INFINITY, NEGATIVE_INFINITY, POSITIVE_NAN, NEGATIVE_NAN, POSITIVE_SIGNALING_NAN, NEGATIVE_SIGNALING_NAN);
        }

        @Override
        public Decimal32 createDecimal(int signum, BigDecimal value) {
            return new Decimal32(signum, this.validateRange(value));
        }
    }
}

