/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.ds;

import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.naming.BinaryRefAddr;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.firebirdsql.ds.AbstractConnectionPropertiesDataSource;
import org.firebirdsql.ds.DataSourceFactory;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.jaybird.props.def.ConnectionProperty;
import org.firebirdsql.jdbc.FBConnectionProperties;

public abstract class FBAbstractCommonDataSource
extends AbstractConnectionPropertiesDataSource {
    protected static final String REF_DESCRIPTION = "description";
    protected static final String REF_PROPERTIES = "properties";
    private String description;
    private final Lock lock = new ReentrantLock();
    private final LockCloseable unlock = this.lock::unlock;
    private FBConnectionProperties connectionProperties = new FBConnectionProperties();

    protected final LockCloseable withLock() {
        this.lock.lock();
        return this.unlock;
    }

    protected abstract void checkNotStarted() throws IllegalStateException;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public TransactionParameterBuffer getTransactionParameters(int isolation) {
        try (LockCloseable ignored = this.withLock();){
            TransactionParameterBuffer transactionParameterBuffer = this.connectionProperties.getTransactionParameters(isolation);
            return transactionParameterBuffer;
        }
    }

    @Override
    public void setTransactionParameters(int isolation, TransactionParameterBuffer tpb) {
        try (LockCloseable ignored = this.withLock();){
            this.checkNotStarted();
            this.connectionProperties.setTransactionParameters(isolation, tpb);
        }
    }

    @Override
    public final void setNonStandardProperty(String propertyMapping) {
        try (LockCloseable ignored = this.withLock();){
            this.checkNotStarted();
            this.connectionProperties.setNonStandardProperty(propertyMapping);
        }
    }

    @Override
    public String getProperty(String name) {
        try (LockCloseable ignored = this.withLock();){
            String string = this.connectionProperties.getProperty(name);
            return string;
        }
    }

    @Override
    public void setProperty(String name, String value) {
        try (LockCloseable ignored = this.withLock();){
            this.checkNotStarted();
            this.connectionProperties.setProperty(name, value);
        }
    }

    @Override
    public Integer getIntProperty(String name) {
        try (LockCloseable ignored = this.withLock();){
            Integer n = this.connectionProperties.getIntProperty(name);
            return n;
        }
    }

    @Override
    public void setIntProperty(String name, Integer value) {
        try (LockCloseable ignored = this.withLock();){
            this.checkNotStarted();
            this.connectionProperties.setIntProperty(name, value);
        }
    }

    @Override
    public Boolean getBooleanProperty(String name) {
        try (LockCloseable ignored = this.withLock();){
            Boolean bl = this.connectionProperties.getBooleanProperty(name);
            return bl;
        }
    }

    @Override
    public void setBooleanProperty(String name, Boolean value) {
        try (LockCloseable ignored = this.withLock();){
            this.checkNotStarted();
            this.connectionProperties.setBooleanProperty(name, value);
        }
    }

    @Override
    public Map<ConnectionProperty, Object> connectionPropertyValues() {
        try (LockCloseable ignored = this.withLock();){
            Map<ConnectionProperty, Object> map = this.connectionProperties.connectionPropertyValues();
            return map;
        }
    }

    protected final void setConnectionProperties(FBConnectionProperties connectionProperties) {
        if (connectionProperties == null) {
            throw new NullPointerException("null value not allowed for connectionProperties");
        }
        try (LockCloseable ignored = this.withLock();){
            this.checkNotStarted();
            this.connectionProperties = connectionProperties;
        }
    }

    protected final FBConnectionProperties getConnectionProperties() {
        try (LockCloseable ignored = this.withLock();){
            FBConnectionProperties fBConnectionProperties = this.connectionProperties;
            return fBConnectionProperties;
        }
    }

    protected static void updateReference(Reference ref, FBAbstractCommonDataSource instance) throws NamingException {
        try (LockCloseable ignored = instance.withLock();){
            ref.add(new StringRefAddr(REF_DESCRIPTION, instance.getDescription()));
            byte[] data = DataSourceFactory.serialize(instance.connectionProperties);
            ref.add(new BinaryRefAddr(REF_PROPERTIES, data));
        }
    }
}

