/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.intl;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.intl.CoerceOptionsToObjectNode;
import com.oracle.truffle.js.nodes.intl.CoerceOptionsToObjectNodeGen;
import com.oracle.truffle.js.nodes.intl.GetStringOptionNode;
import com.oracle.truffle.js.nodes.intl.InitializePluralRulesNodeGen;
import com.oracle.truffle.js.nodes.intl.JSToCanonicalizedLocaleListNode;
import com.oracle.truffle.js.nodes.intl.SetNumberFormatDigitOptionsNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.intl.JSPluralRules;
import com.oracle.truffle.js.runtime.builtins.intl.JSPluralRulesObject;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import java.util.List;
import java.util.MissingResourceException;

public abstract class InitializePluralRulesNode
extends JavaScriptBaseNode {
    private static final List<String> TYPE_OPTION_VALUES = List.of("cardinal", "ordinal");
    private static final List<String> NOTATION_OPTION_VALUES = List.of("standard", "scientific", "engineering", "compact");
    private final JSContext context;
    @Node.Child
    JSToCanonicalizedLocaleListNode toCanonicalizedLocaleListNode;
    @Node.Child
    CoerceOptionsToObjectNode coerceOptionsToObjectNode;
    @Node.Child
    GetStringOptionNode getLocaleMatcherOption;
    @Node.Child
    SetNumberFormatDigitOptionsNode setNumberFormatDigitOptions;
    @Node.Child
    GetStringOptionNode getTypeOption;
    @Node.Child
    GetStringOptionNode getNotationOption;
    private final BranchProfile errorBranch = BranchProfile.create();

    protected InitializePluralRulesNode(JSContext context) {
        this.context = context;
        this.toCanonicalizedLocaleListNode = JSToCanonicalizedLocaleListNode.create(context);
        this.coerceOptionsToObjectNode = CoerceOptionsToObjectNodeGen.create(context);
        this.getLocaleMatcherOption = GetStringOptionNode.create(context, IntlUtil.KEY_LOCALE_MATCHER, GetStringOptionNode.LOCALE_MATCHER_OPTION_VALUES, "best fit");
        this.getTypeOption = GetStringOptionNode.create(context, IntlUtil.KEY_TYPE, TYPE_OPTION_VALUES, "cardinal");
        this.getNotationOption = GetStringOptionNode.create(context, IntlUtil.KEY_NOTATION, NOTATION_OPTION_VALUES, "standard");
        this.setNumberFormatDigitOptions = SetNumberFormatDigitOptionsNode.create(context);
    }

    public abstract JSPluralRulesObject executeInit(JSPluralRulesObject var1, Object var2, Object var3);

    public static InitializePluralRulesNode createInitalizePluralRulesNode(JSContext context) {
        return InitializePluralRulesNodeGen.create(context);
    }

    @Specialization
    public JSPluralRulesObject initializePluralRules(JSPluralRulesObject pluralRulesObj, Object localesArg, Object optionsArg) {
        try {
            JSPluralRules.InternalState state = pluralRulesObj.getInternalState();
            String[] locales = this.toCanonicalizedLocaleListNode.executeLanguageTags(localesArg);
            Object options = this.coerceOptionsToObjectNode.execute(optionsArg);
            this.getLocaleMatcherOption.executeValue(options);
            String optType = this.getTypeOption.executeValue(options);
            state.setType(optType);
            String notation = this.getNotationOption.executeValue(options);
            state.setNotation(notation);
            state.resolveLocaleAndNumberingSystem(this.context, locales, null);
            this.setNumberFormatDigitOptions.execute(state, options, 0, 3, false);
            state.initializeNumberFormatter();
            state.initializePluralRules();
        }
        catch (MissingResourceException e) {
            this.errorBranch.enter();
            throw Errors.createICU4JDataError(e);
        }
        return pluralRulesObj;
    }
}

