/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.scheduler;

import java.time.Clock;
import java.time.Duration;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.Utility;
import us.fatehi.utility.scheduler.TaskDefinition;
import us.fatehi.utility.scheduler.TaskRunner;
import us.fatehi.utility.scheduler.TimedTaskResult;

abstract class AbstractTaskRunner
implements TaskRunner {
    private static final Logger LOGGER = Logger.getLogger(AbstractTaskRunner.class.getName());
    private final String id;
    protected final Clock clock;
    private final Queue<TaskDefinition> taskDefinitions;
    private final Queue<TimedTaskResult> taskResults;

    AbstractTaskRunner(String id) {
        this(id, Clock.systemUTC());
    }

    AbstractTaskRunner(String id, Clock clock) {
        this.id = Utility.requireNotBlank(id, "No id provided");
        this.clock = Objects.requireNonNull(clock, "Clock not provided");
        this.taskDefinitions = new LinkedBlockingDeque<TaskDefinition>();
        this.taskResults = new LinkedBlockingDeque<TimedTaskResult>();
    }

    @Override
    public final void add(TaskDefinition taskDefinition) throws Exception {
        if (taskDefinition == null) {
            return;
        }
        if (this.isStopped()) {
            throw new IllegalStateException("Task runner is stopped");
        }
        this.taskDefinitions.add(taskDefinition);
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public abstract boolean isStopped();

    @Override
    public final Supplier<String> report() {
        return () -> {
            BiFunction<Duration, Duration, Double> calculatePercentage = (duration, totalDuration) -> {
                long totalMillis = totalDuration.toMillis();
                if (totalMillis == 0L) {
                    return 0.0;
                }
                return (double)duration.toMillis() * 100.0 / (double)totalMillis;
            };
            DateTimeFormatter df = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.NANO_OF_SECOND, 3, 3, true).toFormatter();
            Duration totalDuration2 = Duration.ofNanos(0L);
            for (TimedTaskResult task : this.taskResults) {
                totalDuration2 = totalDuration2.plus(task.getDuration());
            }
            StringBuilder buffer = new StringBuilder(1024);
            LocalTime totalDurationLocal = LocalTime.ofNanoOfDay(totalDuration2.toNanos());
            buffer.append("Total time taken for <%s> - %s hours%n".formatted(this.id, totalDurationLocal.format(df)));
            for (TimedTaskResult task : this.taskResults) {
                buffer.append("-%5.1f%% - %s%n".formatted(calculatePercentage.apply(task.getDuration(), totalDuration2), task));
            }
            this.taskResults.clear();
            return buffer.toString();
        };
    }

    @Override
    public abstract void stop();

    @Override
    public final void submit() throws Exception {
        if (this.isStopped()) {
            throw new IllegalStateException("Task runner is stopped");
        }
        Objects.requireNonNull(this.taskDefinitions, "Tasks not provided");
        Collection<Object> runTaskResults = this.taskDefinitions.isEmpty() ? Collections.emptyList() : this.runTimed(this.taskDefinitions);
        this.taskResults.addAll(runTaskResults);
        this.taskDefinitions.clear();
        boolean hasException = false;
        Exception exception = null;
        for (TimedTaskResult timedTaskResult : runTaskResults) {
            if (!timedTaskResult.hasException()) continue;
            hasException = true;
            Exception runTaskException = timedTaskResult.getException();
            if (exception == null) {
                exception = runTaskException;
                continue;
            }
            exception.addSuppressed(runTaskException);
        }
        if (hasException) {
            this.stop();
            LOGGER.log(Level.CONFIG, this.report());
            throw exception;
        }
    }

    abstract Collection<TimedTaskResult> runTimed(Collection<TaskDefinition> var1) throws Exception;
}

