/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.panama;

import com.oracle.truffle.api.InternalResource;
import com.oracle.truffle.nfi.backend.panama.AbstractErrorContext;
import com.oracle.truffle.nfi.backend.panama.NFIError;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.VarHandle;

public class ErrorContext
extends AbstractErrorContext {
    private static final String ERRNO_LOCATION = switch (InternalResource.OS.getCurrent()) {
        default -> throw new MatchException(null, null);
        case InternalResource.OS.DARWIN -> "__error";
        case InternalResource.OS.LINUX -> "__errno_location";
        case InternalResource.OS.WINDOWS -> "_errno";
    };
    public static final VarHandle INT_VAR_HANDLE = ValueLayout.JAVA_INT.varHandle();
    private MemorySegment errnoLocation;

    private static MemorySegment lookupErrnoLocation() {
        try {
            Linker linker = Linker.nativeLinker();
            FunctionDescriptor desc = FunctionDescriptor.of(ValueLayout.JAVA_LONG, new MemoryLayout[0]);
            MemorySegment sym = linker.defaultLookup().find(ERRNO_LOCATION).orElseThrow();
            MethodHandle handle = linker.downcallHandle(desc, new Linker.Option[0]);
            try {
                return MemorySegment.ofAddress(handle.invokeExact(sym)).reinterpret(4L);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        catch (IllegalCallerException ic) {
            throw NFIError.illegalNativeAccess(null);
        }
    }

    @Override
    void initialize() {
        if (this.errnoLocation == null) {
            this.errnoLocation = ErrorContext.lookupErrnoLocation();
        }
    }

    private MemorySegment getErrnoLocation() {
        assert (this.errnoLocation != null);
        return this.errnoLocation;
    }

    @Override
    int getNativeErrno() {
        return INT_VAR_HANDLE.get(this.getErrnoLocation(), 0);
    }

    @Override
    void setNativeErrno(int newErrno) {
        INT_VAR_HANDLE.set(this.getErrnoLocation(), 0, newErrno);
    }
}

