import datetime
from typing import ClassVar

from ...core import WesternCalendar
from .mixins import (
    AutumnHolidayFirstMondayOctober,
    AutumnHolidayLastMondaySeptember,
    AutumnHolidaySecondMondayOctober,
    AutumnHolidayThirdMondayOctober,
    AyrGoldCup,
    BattleStirlingBridge,
    FairHolidayFirstMondayAugust,
    FairHolidayFirstMondayJuly,
    FairHolidayFourthFridayJuly,
    FairHolidayLastMondayJuly,
    FairHolidayLastMondayJune,
    FairHolidaySecondMondayJuly,
    FairHolidayThirdMondayJuly,
    LateSummer,
    SpringHolidayFirstMondayApril,
    SpringHolidayFirstMondayJune,
    SpringHolidayLastMondayMay,
    SpringHolidaySecondMondayApril,
    SpringHolidayTuesdayAfterFirstMondayMay,
    VictoriaDayFirstMondayJune,
    VictoriaDayFourthMondayMay,
    VictoriaDayLastMondayMay,
)

class Scotland(WesternCalendar):
    include_spring_holiday: ClassVar[bool]
    spring_holiday_label: ClassVar[str]
    include_fair_holiday: ClassVar[bool]
    include_autumn_holiday: ClassVar[bool]
    include_saint_andrew: ClassVar[bool]
    include_victoria_day: ClassVar[bool]
    def __init__(self, *args, **kwargs) -> None: ...
    def get_may_day(self, year: int) -> tuple[datetime.date, str]: ...
    def get_spring_holiday(self, year: int) -> tuple[datetime.date, str]: ...
    def get_fair_holiday(self, year: int) -> tuple[datetime.date, str]: ...
    def get_autumn_holiday(self, year: int) -> tuple[datetime.date, str]: ...
    def get_victoria_day(self, year: int) -> tuple[datetime.date, str]: ...

class Aberdeen(FairHolidaySecondMondayJuly, AutumnHolidayLastMondaySeptember, Scotland): ...
class Angus(SpringHolidaySecondMondayApril, AutumnHolidayLastMondaySeptember, Scotland): ...
class Arbroath(FairHolidayThirdMondayJuly, Scotland): ...
class Ayr(SpringHolidayLastMondayMay, AyrGoldCup, Scotland): ...
class CarnoustieMonifieth(SpringHolidayFirstMondayApril, AutumnHolidayFirstMondayOctober, Scotland): ...
class Clydebank(SpringHolidayTuesdayAfterFirstMondayMay, Scotland): ...
class DumfriesGalloway(Scotland): ...
class Dundee(
    SpringHolidayFirstMondayApril, VictoriaDayLastMondayMay, FairHolidayLastMondayJuly, AutumnHolidayFirstMondayOctober, Scotland
): ...
class EastDunbartonshire(SpringHolidayLastMondayMay, FairHolidayThirdMondayJuly, AutumnHolidayLastMondaySeptember, Scotland): ...
class Edinburgh(Scotland): ...
class Elgin(SpringHolidaySecondMondayApril, FairHolidayLastMondayJune, LateSummer, AutumnHolidayThirdMondayOctober, Scotland): ...
class Falkirk(FairHolidayFirstMondayJuly, BattleStirlingBridge, Scotland): ...
class Fife(VictoriaDayFirstMondayJune, FairHolidayThirdMondayJuly, AutumnHolidayThirdMondayOctober, Scotland): ...
class Galashiels(SpringHolidayFirstMondayJune, Scotland): ...
class Glasgow(SpringHolidayLastMondayMay, FairHolidayThirdMondayJuly, AutumnHolidayLastMondaySeptember, Scotland): ...
class Hawick(Scotland): ...
class Inverclyde(LateSummer, Scotland): ...
class Inverness(SpringHolidayFirstMondayApril, FairHolidayFirstMondayJuly, AutumnHolidayFirstMondayOctober, Scotland): ...
class Kilmarnock(AyrGoldCup, Scotland): ...
class Lanark(Scotland): ...
class Linlithgow(Scotland): ...
class Lochaber(Scotland): ...
class NorthLanarkshire(SpringHolidayLastMondayMay, FairHolidayThirdMondayJuly, AutumnHolidayLastMondaySeptember, Scotland): ...
class Paisley(VictoriaDayLastMondayMay, FairHolidayFirstMondayAugust, AutumnHolidayLastMondaySeptember, Scotland): ...
class Perth(
    SpringHolidayFirstMondayApril, VictoriaDayFourthMondayMay, BattleStirlingBridge, AutumnHolidayFirstMondayOctober, Scotland
): ...
class ScottishBorders(SpringHolidayFirstMondayApril, FairHolidayFourthFridayJuly, AutumnHolidaySecondMondayOctober, Scotland): ...
class SouthLanarkshire(SpringHolidayLastMondayMay, FairHolidayThirdMondayJuly, AutumnHolidayLastMondaySeptember, Scotland): ...
class Stirling(SpringHolidayTuesdayAfterFirstMondayMay, BattleStirlingBridge, Scotland): ...
class WestDunbartonshire(AutumnHolidayLastMondaySeptember, Scotland): ...
