/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.httpclient;

import java.net.InetAddress;
import java.net.ProxySelector;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.httpclient.ContextHandlingHttpClient;
import net.shibboleth.shared.httpclient.HttpClientContextHandler;
import net.shibboleth.shared.httpclient.HttpClientSupport;
import net.shibboleth.shared.httpclient.LocalAddressProxyRoutePlanner;
import net.shibboleth.shared.httpclient.LocalAddressRoutePlanner;
import net.shibboleth.shared.httpclient.LocalAddressSystemRoutePlanner;
import net.shibboleth.shared.httpclient.RequestConnectionClose;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.auth.CredentialsProviderBuilder;
import org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class HttpClientBuilder {
    @Nullable
    private InetAddress socketLocalAddress;
    @Nonnull
    private Duration socketTimeout;
    private int socketBufferSize;
    @Nonnull
    private Duration connectionTimeout;
    @Nonnull
    private Duration connectionRequestTimeout;
    @Nonnull
    private Duration responseTimeout;
    private int maxConnectionsTotal;
    private int maxConnectionsPerRoute;
    private boolean connectionDisregardTLSCertificate;
    @Nullable
    private LayeredConnectionSocketFactory tlsSocketFactory;
    private boolean connectionCloseAfterResponse;
    @Nullable
    private Duration validateAfterInactivity;
    @Nullable
    private String connectionProxyHost;
    @Nullable
    private String userAgent;
    private int connectionProxyPort;
    @Nullable
    private String connectionProxyUsername;
    @Nullable
    private String connectionProxyPassword;
    private boolean httpFollowRedirects;
    @Nullable
    private String httpContentCharSet;
    @Nullable
    private HttpRequestRetryStrategy retryStrategy;
    @Nullable
    private SchemePortResolver schemePortResolver;
    private boolean disableAuthCaching;
    private boolean disableAutomaticRetries;
    private boolean disableConnectionState;
    private boolean disableContentCompression;
    private boolean disableCookieManagement;
    private boolean disableRedirectHandling;
    private boolean useSystemProperties;
    private boolean evictExpiredConnections;
    private boolean evictIdleConnections;
    @Nonnull
    private Duration connectionMaxIdleTime;
    @Nonnull
    @Unmodifiable
    @NotLive
    private List<HttpRequestInterceptor> requestInterceptorsFirst;
    @Nonnull
    @Unmodifiable
    @NotLive
    private List<HttpRequestInterceptor> requestInterceptorsLast;
    @Nonnull
    @Unmodifiable
    @NotLive
    private List<HttpResponseInterceptor> responseInterceptorsFirst;
    @Nonnull
    @Unmodifiable
    @NotLive
    private List<HttpResponseInterceptor> responseInterceptorsLast;
    @Nonnull
    @Unmodifiable
    @NotLive
    private List<HttpClientContextHandler> staticContextHandlers;
    @Nonnull
    private final org.apache.hc.client5.http.impl.classic.HttpClientBuilder apacheBuilder;

    public HttpClientBuilder() {
        this(org.apache.hc.client5.http.impl.classic.HttpClientBuilder.create());
    }

    public HttpClientBuilder(@Nonnull org.apache.hc.client5.http.impl.classic.HttpClientBuilder builder) {
        this.apacheBuilder = Constraint.isNotNull(builder, "Apache HttpClientBuilder may not be null");
        this.maxConnectionsTotal = -1;
        this.maxConnectionsPerRoute = -1;
        this.socketLocalAddress = null;
        this.socketBufferSize = 8192;
        this.socketTimeout = Duration.ofSeconds(60L);
        this.responseTimeout = Duration.ofNanos(60L);
        this.connectionTimeout = Duration.ofSeconds(60L);
        this.connectionRequestTimeout = Duration.ofSeconds(60L);
        this.connectionDisregardTLSCertificate = false;
        this.connectionCloseAfterResponse = true;
        this.connectionProxyHost = null;
        this.connectionProxyPort = 8080;
        this.connectionProxyUsername = null;
        this.connectionProxyPassword = null;
        this.httpFollowRedirects = true;
        this.httpContentCharSet = "UTF-8";
        this.userAgent = null;
        this.validateAfterInactivity = null;
        this.retryStrategy = null;
        this.schemePortResolver = null;
        this.disableAuthCaching = false;
        this.disableAutomaticRetries = false;
        this.disableConnectionState = false;
        this.disableContentCompression = false;
        this.disableCookieManagement = false;
        this.disableRedirectHandling = false;
        this.useSystemProperties = false;
        this.evictExpiredConnections = false;
        this.evictIdleConnections = false;
        this.connectionMaxIdleTime = Duration.ofMinutes(30L);
        this.requestInterceptorsFirst = CollectionSupport.emptyList();
        this.requestInterceptorsLast = CollectionSupport.emptyList();
        this.responseInterceptorsFirst = CollectionSupport.emptyList();
        this.responseInterceptorsLast = CollectionSupport.emptyList();
        this.staticContextHandlers = CollectionSupport.emptyList();
    }

    public void resetDefaults() {
        this.maxConnectionsTotal = -1;
        this.maxConnectionsPerRoute = -1;
        this.socketLocalAddress = null;
        this.socketBufferSize = 8192;
        this.socketTimeout = Duration.ofSeconds(60L);
        this.responseTimeout = Duration.ofNanos(60L);
        this.connectionTimeout = Duration.ofSeconds(60L);
        this.connectionRequestTimeout = Duration.ofSeconds(60L);
        this.connectionDisregardTLSCertificate = false;
        this.connectionCloseAfterResponse = true;
        this.connectionProxyHost = null;
        this.connectionProxyPort = 8080;
        this.connectionProxyUsername = null;
        this.connectionProxyPassword = null;
        this.httpFollowRedirects = true;
        this.httpContentCharSet = "UTF-8";
        this.userAgent = null;
        this.validateAfterInactivity = null;
        this.retryStrategy = null;
        this.schemePortResolver = null;
        this.disableAuthCaching = false;
        this.disableAutomaticRetries = false;
        this.disableConnectionState = false;
        this.disableContentCompression = false;
        this.disableCookieManagement = false;
        this.disableRedirectHandling = false;
        this.useSystemProperties = false;
        this.evictExpiredConnections = false;
        this.evictIdleConnections = false;
        this.connectionMaxIdleTime = Duration.ofMinutes(30L);
        this.requestInterceptorsFirst = CollectionSupport.emptyList();
        this.requestInterceptorsLast = CollectionSupport.emptyList();
        this.responseInterceptorsFirst = CollectionSupport.emptyList();
        this.responseInterceptorsLast = CollectionSupport.emptyList();
        this.staticContextHandlers = CollectionSupport.emptyList();
    }

    public int getMaxConnectionsTotal() {
        return this.maxConnectionsTotal;
    }

    public void setMaxConnectionsTotal(int max) {
        this.maxConnectionsTotal = max;
    }

    public int getMaxConnectionsPerRoute() {
        return this.maxConnectionsPerRoute;
    }

    public void setMaxConnectionsPerRoute(int max) {
        this.maxConnectionsPerRoute = max;
    }

    public InetAddress getSocketLocalAddress() {
        return this.socketLocalAddress;
    }

    public void setSocketLocalAddress(InetAddress address) {
        this.socketLocalAddress = address;
    }

    public void setSocketLocalAddress(String ipOrHost) throws UnknownHostException {
        this.socketLocalAddress = InetAddress.getByName(Constraint.isNotNull(ipOrHost, "IP or hostname may not be null"));
    }

    @Nonnull
    public Duration getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(@Nonnull Duration timeout) {
        Constraint.isNotNull(timeout, "Timeout cannot be null");
        Constraint.isLessThanOrEqual(Integer.MAX_VALUE, timeout.toMillis(), "Timeout too large");
        this.responseTimeout = timeout;
    }

    @Nonnull
    public Duration getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(@Nonnull Duration timeout) {
        Constraint.isNotNull(timeout, "Timeout cannot be null");
        Constraint.isLessThanOrEqual(Integer.MAX_VALUE, timeout.toMillis(), "Timeout too large");
        this.socketTimeout = timeout;
    }

    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public void setSocketBufferSize(int size) {
        this.socketBufferSize = Constraint.isGreaterThan(0, size, "Socket buffer size must be greater than 0");
    }

    @Nonnull
    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(@Nonnull Duration timeout) {
        Constraint.isNotNull(timeout, "Connection timeout cannot be null");
        Constraint.isLessThanOrEqual(Integer.MAX_VALUE, timeout.toMillis(), "Connection timeout too large");
        this.connectionTimeout = timeout;
    }

    @Nonnull
    public Duration getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public void setConnectionRequestTimeout(@Nonnull Duration timeout) {
        Constraint.isNotNull(timeout, "Connection request timeout cannot be null");
        Constraint.isLessThanOrEqual(Integer.MAX_VALUE, timeout.toMillis(), "Connection request timeout too large");
        this.connectionRequestTimeout = timeout;
    }

    public boolean isConnectionDisregardTLSCertificate() {
        return this.connectionDisregardTLSCertificate;
    }

    public void setConnectionDisregardTLSCertificate(boolean disregard) {
        this.connectionDisregardTLSCertificate = disregard;
    }

    @Nullable
    public LayeredConnectionSocketFactory getTLSSocketFactory() {
        return this.tlsSocketFactory;
    }

    public void setTLSSocketFactory(@Nullable LayeredConnectionSocketFactory factory) {
        this.tlsSocketFactory = factory;
    }

    public boolean isConnectionCloseAfterResponse() {
        return this.connectionCloseAfterResponse;
    }

    public void setConnectionCloseAfterResponse(boolean close) {
        this.connectionCloseAfterResponse = close;
    }

    @Nullable
    Duration getValidateAfterInactivity() {
        return this.validateAfterInactivity;
    }

    public void setValidateAfterInactivity(@Nullable Duration duration) {
        this.validateAfterInactivity = duration;
    }

    @Nullable
    public String getConnectionProxyHost() {
        return this.connectionProxyHost;
    }

    public void setConnectionProxyHost(@Nullable String host) {
        this.connectionProxyHost = StringSupport.trimOrNull(host);
    }

    public int getConnectionProxyPort() {
        return this.connectionProxyPort;
    }

    public void setConnectionProxyPort(int port) {
        this.connectionProxyPort = (int)Constraint.numberInRangeExclusive(0L, 65536L, port, "Proxy port must be between 0 and 65536, exclusive");
    }

    @Nullable
    public String getConnectionProxyUsername() {
        return this.connectionProxyUsername;
    }

    public void setConnectionProxyUsername(@Nullable String usename) {
        this.connectionProxyUsername = usename;
    }

    @Nullable
    public String getConnectionProxyPassword() {
        return this.connectionProxyPassword;
    }

    public void setConnectionProxyPassword(@Nullable String password) {
        this.connectionProxyPassword = password;
    }

    public boolean isHttpFollowRedirects() {
        return this.httpFollowRedirects;
    }

    public void setHttpFollowRedirects(boolean followRedirects) {
        this.httpFollowRedirects = followRedirects;
    }

    @Nullable
    public String getHttpContentCharSet() {
        return this.httpContentCharSet;
    }

    public void setHttpContentCharSet(@Nullable String charSet) {
        this.httpContentCharSet = charSet;
    }

    @Nullable
    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(@Nullable String what) {
        this.userAgent = what;
    }

    @Nullable
    public HttpRequestRetryStrategy getHttpRequestRetryStrategy() {
        return this.retryStrategy;
    }

    public void setHttpRequestRetryStrategy(@Nullable HttpRequestRetryStrategy strategy) {
        this.retryStrategy = strategy;
    }

    @Nullable
    public SchemePortResolver getSchemePortResolver() {
        return this.schemePortResolver;
    }

    public void setSchemePortResolver(@Nullable SchemePortResolver resolver) {
        this.schemePortResolver = resolver;
    }

    public boolean isDisableAuthCaching() {
        return this.disableAuthCaching;
    }

    public void setDisableAuthCaching(boolean flag) {
        this.disableAuthCaching = flag;
    }

    public boolean isDisableAutomaticRetries() {
        return this.disableAutomaticRetries;
    }

    public void setDisableAutomaticRetries(boolean flag) {
        this.disableAutomaticRetries = flag;
    }

    public boolean isDisableConnectionState() {
        return this.disableConnectionState;
    }

    public void setDisableConnectionState(boolean flag) {
        this.disableConnectionState = flag;
    }

    public boolean isDisableContentCompression() {
        return this.disableContentCompression;
    }

    public void setDisableContentCompression(boolean flag) {
        this.disableContentCompression = flag;
    }

    public boolean isDisableCookieManagement() {
        return this.disableCookieManagement;
    }

    public void setDisableCookieManagement(boolean flag) {
        this.disableCookieManagement = flag;
    }

    public boolean isDisableRedirectHandling() {
        return this.disableRedirectHandling;
    }

    public void setDisableRedirectHandling(boolean flag) {
        this.disableRedirectHandling = flag;
    }

    public boolean isUseSystemProperties() {
        return this.useSystemProperties;
    }

    public void setUseSystemProperties(boolean flag) {
        this.useSystemProperties = flag;
    }

    public boolean isEvictExpiredConnections() {
        return this.evictExpiredConnections;
    }

    public void setEvictExpiredConnections(boolean flag) {
        this.evictExpiredConnections = flag;
    }

    public boolean isEvictIdleConnections() {
        return this.evictIdleConnections;
    }

    public void setEvictIdleConnections(boolean flag) {
        this.evictIdleConnections = flag;
    }

    @Nonnull
    Duration getConnectionMaxIdleTime() {
        return this.connectionMaxIdleTime;
    }

    public void setConnectionMaxIdleTime(@Nonnull Duration duration) {
        Constraint.isNotNull(duration, "Connection max idle time cannot be null");
        Constraint.isLessThanOrEqual(Integer.MAX_VALUE, duration.toMillis(), "Connection max idle time too large");
        this.connectionMaxIdleTime = duration;
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<HttpRequestInterceptor> getFirstRequestInterceptors() {
        return this.requestInterceptorsFirst;
    }

    public void setFirstRequestInterceptors(@Nullable List<HttpRequestInterceptor> interceptors) {
        this.requestInterceptorsFirst = interceptors != null ? CollectionSupport.copyToList(interceptors) : CollectionSupport.emptyList();
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<HttpRequestInterceptor> getLastRequestInterceptors() {
        return this.requestInterceptorsLast;
    }

    public void setLastRequestInterceptors(@Nullable List<HttpRequestInterceptor> interceptors) {
        this.requestInterceptorsLast = interceptors != null ? CollectionSupport.copyToList(interceptors) : CollectionSupport.emptyList();
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<HttpResponseInterceptor> getFirstResponseInterceptors() {
        return this.responseInterceptorsFirst;
    }

    public void setFirstResponseInterceptors(@Nullable List<HttpResponseInterceptor> interceptors) {
        this.responseInterceptorsFirst = interceptors != null ? CollectionSupport.copyToList(interceptors) : CollectionSupport.emptyList();
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<HttpResponseInterceptor> getLastResponseInterceptors() {
        return this.responseInterceptorsLast;
    }

    public void setLastResponseInterceptors(@Nullable List<HttpResponseInterceptor> interceptors) {
        this.responseInterceptorsLast = interceptors != null ? CollectionSupport.copyToList(interceptors) : CollectionSupport.emptyList();
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<HttpClientContextHandler> getStaticContextHandlers() {
        return this.staticContextHandlers;
    }

    public void setStaticContextHandlers(@Nullable List<HttpClientContextHandler> handlers) {
        this.staticContextHandlers = handlers != null ? CollectionSupport.copyToList(handlers) : CollectionSupport.emptyList();
    }

    @Nonnull
    public HttpClient buildClient() throws Exception {
        this.decorateApacheBuilder();
        return new ContextHandlingHttpClient((HttpClient)this.getApacheBuilder().build(), this.getStaticContextHandlers());
    }

    protected void decorateApacheBuilder() throws Exception {
        org.apache.hc.client5.http.impl.classic.HttpClientBuilder builder = this.getApacheBuilder();
        builder.setConnectionManager(this.buildConnectionManager());
        builder.setDefaultRequestConfig(this.buildDefaultRequestConfig());
        HttpHost proxyHost = null;
        if (this.connectionProxyHost != null) {
            proxyHost = new HttpHost(this.connectionProxyHost, this.connectionProxyPort);
            builder.setProxy(proxyHost);
        }
        builder.setRoutePlanner(this.buildRoutePlanner(proxyHost));
        builder.setDefaultCredentialsProvider(this.buildDefaultCredentialsProvider());
        this.handleFluentProperties(builder);
        if (this.connectionCloseAfterResponse) {
            if (!this.getFirstRequestInterceptors().stream().anyMatch(RequestConnectionClose.class::isInstance)) {
                if (!this.getLastRequestInterceptors().stream().anyMatch(RequestConnectionClose.class::isInstance)) {
                    builder.addRequestInterceptorLast((HttpRequestInterceptor)new RequestConnectionClose());
                }
            }
        }
        this.getFirstRequestInterceptors().forEach(arg_0 -> ((org.apache.hc.client5.http.impl.classic.HttpClientBuilder)builder).addRequestInterceptorFirst(arg_0));
        this.getLastRequestInterceptors().forEach(arg_0 -> ((org.apache.hc.client5.http.impl.classic.HttpClientBuilder)builder).addRequestInterceptorLast(arg_0));
        this.getFirstResponseInterceptors().forEach(arg_0 -> ((org.apache.hc.client5.http.impl.classic.HttpClientBuilder)builder).addResponseInterceptorFirst(arg_0));
        this.getLastResponseInterceptors().forEach(arg_0 -> ((org.apache.hc.client5.http.impl.classic.HttpClientBuilder)builder).addResponseInterceptorLast(arg_0));
        if (this.retryStrategy != null) {
            builder.setRetryStrategy(this.retryStrategy);
        }
        if (null != this.userAgent) {
            builder.setUserAgent(this.userAgent);
        }
    }

    @Nullable
    protected HttpRoutePlanner buildRoutePlanner(@Nullable HttpHost proxyHost) {
        DefaultSchemePortResolver resolver;
        if (this.socketLocalAddress == null) {
            return null;
        }
        Object object = resolver = this.schemePortResolver != null ? this.schemePortResolver : DefaultSchemePortResolver.INSTANCE;
        if (proxyHost != null) {
            return new LocalAddressProxyRoutePlanner(this.socketLocalAddress, proxyHost, (SchemePortResolver)resolver);
        }
        if (this.isUseSystemProperties()) {
            return new LocalAddressSystemRoutePlanner(this.socketLocalAddress, (SchemePortResolver)resolver, ProxySelector.getDefault());
        }
        return new LocalAddressRoutePlanner(this.socketLocalAddress, (SchemePortResolver)resolver);
    }

    protected void handleFluentProperties(@Nonnull org.apache.hc.client5.http.impl.classic.HttpClientBuilder builder) {
        if (this.isDisableAuthCaching()) {
            builder.disableAuthCaching();
        }
        if (this.isDisableAutomaticRetries()) {
            builder.disableAutomaticRetries();
        }
        if (this.isDisableConnectionState()) {
            builder.disableConnectionState();
        }
        if (this.isDisableContentCompression()) {
            builder.disableContentCompression();
        }
        if (this.isDisableCookieManagement()) {
            builder.disableCookieManagement();
        }
        if (this.isDisableRedirectHandling()) {
            builder.disableRedirectHandling();
        }
        if (this.isUseSystemProperties()) {
            builder.useSystemProperties();
        }
        if (this.isEvictExpiredConnections()) {
            builder.evictExpiredConnections();
        }
        if (this.isEvictIdleConnections()) {
            builder.evictIdleConnections(TimeValue.ofMilliseconds((long)this.connectionMaxIdleTime.toMillis()));
        }
    }

    @Nullable
    protected CredentialsProvider buildDefaultCredentialsProvider() {
        if (this.connectionProxyHost != null && this.connectionProxyUsername != null && this.connectionProxyPassword != null) {
            char[] proxyPassBytes = this.connectionProxyPassword.toCharArray();
            return CredentialsProviderBuilder.create().add(new AuthScope(this.connectionProxyHost, this.connectionProxyPort), (Credentials)new UsernamePasswordCredentials(this.connectionProxyUsername, proxyPassBytes)).build();
        }
        return null;
    }

    @Nonnull
    protected RequestConfig buildDefaultRequestConfig() {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        if (!this.connectionRequestTimeout.isNegative()) {
            requestConfigBuilder.setConnectionRequestTimeout(Timeout.ofMilliseconds((long)this.connectionRequestTimeout.toMillis()));
        }
        if (!this.responseTimeout.isNegative()) {
            requestConfigBuilder.setResponseTimeout(Timeout.ofMilliseconds((long)this.responseTimeout.toMillis()));
        }
        requestConfigBuilder.setRedirectsEnabled(this.httpFollowRedirects);
        return requestConfigBuilder.build();
    }

    @Nonnull
    protected HttpClientConnectionManager buildConnectionManager() {
        PoolingHttpClientConnectionManagerBuilder connMgrBuilder = PoolingHttpClientConnectionManagerBuilder.create();
        connMgrBuilder.setConnectionFactory(this.buildConnectionFactory());
        connMgrBuilder.setDefaultConnectionConfig(this.buildDefaultConnectionConfig());
        if (this.getTLSSocketFactory() != null) {
            connMgrBuilder.setSSLSocketFactory(this.getTLSSocketFactory());
        } else if (this.connectionDisregardTLSCertificate) {
            connMgrBuilder.setSSLSocketFactory(HttpClientSupport.buildNoTrustTLSSocketFactory());
        } else {
            connMgrBuilder.setSSLSocketFactory(HttpClientSupport.buildStrictTLSSocketFactory());
        }
        if (this.maxConnectionsTotal > 0) {
            connMgrBuilder.setMaxConnTotal(this.maxConnectionsTotal);
        }
        if (this.maxConnectionsPerRoute > 0) {
            connMgrBuilder.setMaxConnPerRoute(this.maxConnectionsPerRoute);
        }
        return connMgrBuilder.build();
    }

    @Nonnull
    protected ConnectionConfig buildDefaultConnectionConfig() {
        ConnectionConfig.Builder builder = ConnectionConfig.custom();
        if (!this.connectionTimeout.isNegative()) {
            builder.setConnectTimeout(Timeout.ofMilliseconds((long)this.connectionTimeout.toMillis()));
        }
        if (!this.socketTimeout.isNegative()) {
            builder.setSocketTimeout(Timeout.ofMilliseconds((long)this.socketTimeout.toMillis()));
        }
        if (this.validateAfterInactivity != null) {
            builder.setValidateAfterInactivity(TimeValue.ofMilliseconds((long)this.validateAfterInactivity.toMillis()));
        }
        return builder.build();
    }

    @Nonnull
    protected HttpConnectionFactory<ManagedHttpClientConnection> buildConnectionFactory() {
        ManagedHttpClientConnectionFactory.Builder builder = ManagedHttpClientConnectionFactory.builder();
        builder.http1Config(Http1Config.custom().setBufferSize(this.socketBufferSize).build());
        if (this.httpContentCharSet != null) {
            builder.charCodingConfig(CharCodingConfig.custom().setCharset(Charset.forName(this.httpContentCharSet)).build());
        }
        return builder.build();
    }

    @Nonnull
    org.apache.hc.client5.http.impl.classic.HttpClientBuilder getApacheBuilder() {
        return this.apacheBuilder;
    }
}

