/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.serializer.DateTypeSerializer;

public class SqlDateTypeSerializer<T extends Date>
extends DateTypeSerializer<T> {
    public SqlDateTypeSerializer(Customization customization) {
        super(customization);
    }

    @Override
    protected Instant toInstant(Date value) {
        if (value instanceof java.sql.Date) {
            return Instant.ofEpochMilli(value.getTime());
        }
        return super.toInstant(value);
    }

    @Override
    protected String formatDefault(Date value, Locale locale) {
        if (value instanceof java.sql.Date) {
            return value.toString() + 'Z';
        }
        return super.formatDefault(value, locale);
    }

    @Override
    protected String formatWithFormatter(Date value, DateTimeFormatter formatter) {
        if (value instanceof java.sql.Date) {
            return ((java.sql.Date)value).toLocalDate().format(formatter);
        }
        return super.formatWithFormatter(value, formatter);
    }
}

