/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.indices.replication.common.ReplicationLuceneIndex;
import org.opensearch.indices.replication.common.ReplicationState;
import org.opensearch.indices.replication.common.ReplicationTimer;

@PublicApi(since="2.2.0")
public class SegmentReplicationState
implements ReplicationState,
ToXContentFragment,
Writeable {
    private Stage stage;
    private ReplicationLuceneIndex index;
    private final ReplicationTimer overallTimer;
    private final Map<String, Long> timingData;
    private final ReplicationTimer stageTimer;
    private long replicationId;
    private final ShardRouting shardRouting;
    private String sourceDescription;
    private DiscoveryNode targetNode;

    public ShardRouting getShardRouting() {
        return this.shardRouting;
    }

    @Override
    public ReplicationLuceneIndex getIndex() {
        return this.index;
    }

    public long getReplicationId() {
        return this.replicationId;
    }

    @Override
    public ReplicationTimer getTimer() {
        return this.overallTimer;
    }

    public Stage getStage() {
        return this.stage;
    }

    public String getSourceDescription() {
        return this.sourceDescription;
    }

    public DiscoveryNode getTargetNode() {
        return this.targetNode;
    }

    public Map<String, Long> getTimingData() {
        return this.timingData;
    }

    public TimeValue getReplicatingStageTime() {
        long time = this.timingData.getOrDefault(Stage.REPLICATING.toString(), 0L);
        return new TimeValue(time);
    }

    public TimeValue getGetCheckpointInfoStageTime() {
        long time = this.timingData.getOrDefault(Stage.GET_CHECKPOINT_INFO.toString(), 0L);
        return new TimeValue(time);
    }

    public TimeValue getFileDiffStageTime() {
        long time = this.timingData.getOrDefault(Stage.FILE_DIFF.toString(), 0L);
        return new TimeValue(time);
    }

    public TimeValue getGetFileStageTime() {
        long time = this.timingData.getOrDefault(Stage.GET_FILES.toString(), 0L);
        return new TimeValue(time);
    }

    public TimeValue getFinalizeReplicationStageTime() {
        long time = this.timingData.getOrDefault(Stage.FINALIZE_REPLICATION.toString(), 0L);
        return new TimeValue(time);
    }

    public SegmentReplicationState(ShardRouting shardRouting, ReplicationLuceneIndex index, long replicationId, String sourceDescription, DiscoveryNode targetNode) {
        this.index = index;
        this.shardRouting = shardRouting;
        this.replicationId = replicationId;
        this.sourceDescription = sourceDescription;
        this.targetNode = targetNode;
        this.timingData = new ConcurrentHashMap<String, Long>(Stage.values().length + 1);
        this.overallTimer = new ReplicationTimer();
        this.stageTimer = new ReplicationTimer();
        this.setStage(Stage.INIT);
        this.stageTimer.start();
    }

    public SegmentReplicationState(StreamInput in) throws IOException {
        this.index = new ReplicationLuceneIndex(in);
        this.shardRouting = new ShardRouting(in);
        this.stage = (Stage)in.readEnum(Stage.class);
        this.replicationId = in.readLong();
        this.overallTimer = new ReplicationTimer(in);
        this.stageTimer = new ReplicationTimer(in);
        this.timingData = in.readMap(StreamInput::readString, StreamInput::readLong);
        this.sourceDescription = in.readString();
        this.targetNode = new DiscoveryNode(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.index.writeTo(out);
        this.shardRouting.writeTo(out);
        out.writeEnum((Enum)this.stage);
        out.writeLong(this.replicationId);
        this.overallTimer.writeTo(out);
        this.stageTimer.writeTo(out);
        HashMap<String, Long> timingDataCopy = new HashMap<String, Long>();
        for (Map.Entry<String, Long> entry : this.timingData.entrySet()) {
            timingDataCopy.put(entry.getKey(), entry.getValue());
        }
        out.writeMap(timingDataCopy, StreamOutput::writeString, StreamOutput::writeLong);
        out.writeString(this.sourceDescription);
        this.targetNode.writeTo(out);
    }

    protected void validateAndSetStage(Stage expected, Stage next) {
        if (this.stage != expected) {
            assert (false) : "can't move replication to stage [" + String.valueOf((Object)next) + "]. current stage: [" + String.valueOf((Object)this.stage) + "] (expected [" + String.valueOf((Object)expected) + "])";
            throw new IllegalStateException("can't move replication to stage [" + String.valueOf((Object)next) + "]. current stage: [" + String.valueOf((Object)this.stage) + "] (expected [" + String.valueOf((Object)expected) + "])");
        }
        this.stopTimersAndSetStage(next);
    }

    private void stopTimersAndSetStage(Stage next) {
        this.stageTimer.stop();
        this.timingData.put(this.stage.name(), this.stageTimer.time());
        this.stageTimer.reset();
        this.stageTimer.start();
        this.stage = next;
    }

    public void setStage(Stage stage) {
        switch (stage.ordinal()) {
            case 1: {
                this.stage = Stage.INIT;
                break;
            }
            case 2: {
                this.validateAndSetStage(Stage.INIT, stage);
                this.overallTimer.start();
                break;
            }
            case 3: {
                this.validateAndSetStage(Stage.REPLICATING, stage);
                break;
            }
            case 4: {
                this.validateAndSetStage(Stage.GET_CHECKPOINT_INFO, stage);
                break;
            }
            case 5: {
                this.validateAndSetStage(Stage.FILE_DIFF, stage);
                break;
            }
            case 6: {
                this.validateAndSetStage(Stage.GET_FILES, stage);
                break;
            }
            case 0: {
                this.validateAndSetStage(Stage.FINALIZE_REPLICATION, stage);
                this.overallTimer.stop();
                this.timingData.put("OVERALL", this.overallTimer.time());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown SegmentReplicationState.Stage [" + String.valueOf((Object)stage) + "]");
            }
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("index_name", this.shardRouting.index().getName());
        builder.field("id", this.shardRouting.shardId().id());
        builder.field("stage", (Object)this.getStage());
        builder.timeField("start_time_in_millis", "start_time", this.getTimer().startTime());
        if (this.getTimer().stopTime() > 0L) {
            builder.timeField("stop_time_in_millis", "stop_time", this.getTimer().stopTime());
        }
        builder.humanReadableField("total_time_in_millis", "total_time", (Object)new TimeValue(this.getTimer().time()));
        builder.field("source", this.getSourceDescription());
        builder.startObject("target");
        builder.field("id", this.targetNode.getId());
        builder.field("host", this.targetNode.getHostName());
        builder.field("transport_address", this.targetNode.getAddress().toString());
        builder.field("ip", this.targetNode.getHostAddress());
        builder.field("name", this.targetNode.getName());
        builder.endObject();
        builder.startObject("index");
        this.index.toXContent(builder, params);
        builder.endObject();
        builder.field("replicating_stage", (Object)this.getReplicatingStageTime());
        builder.field("get_checkpoint_info_stage", (Object)this.getGetCheckpointInfoStageTime());
        builder.field("file_diff_stage", (Object)this.getFileDiffStageTime());
        builder.field("get_files_stage", (Object)this.getGetFileStageTime());
        builder.field("finalize_replication_stage", (Object)this.getFinalizeReplicationStageTime());
        return builder;
    }

    @PublicApi(since="2.2.0")
    public static final class Stage
    extends Enum<Stage> {
        public static final /* enum */ Stage DONE = new Stage(0);
        public static final /* enum */ Stage INIT = new Stage(1);
        public static final /* enum */ Stage REPLICATING = new Stage(2);
        public static final /* enum */ Stage GET_CHECKPOINT_INFO = new Stage(3);
        public static final /* enum */ Stage FILE_DIFF = new Stage(4);
        public static final /* enum */ Stage GET_FILES = new Stage(5);
        public static final /* enum */ Stage FINALIZE_REPLICATION = new Stage(6);
        private static final Stage[] STAGES;
        private final byte id;
        private static final /* synthetic */ Stage[] $VALUES;

        public static Stage[] values() {
            return (Stage[])$VALUES.clone();
        }

        public static Stage valueOf(String name) {
            return Enum.valueOf(Stage.class, name);
        }

        private Stage(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static Stage fromId(byte id) {
            if (id < 0 || id >= STAGES.length) {
                throw new IllegalArgumentException("No mapping for id [" + id + "]");
            }
            return STAGES[id];
        }

        private static /* synthetic */ Stage[] $values() {
            return new Stage[]{DONE, INIT, REPLICATING, GET_CHECKPOINT_INFO, FILE_DIFF, GET_FILES, FINALIZE_REPLICATION};
        }

        static {
            $VALUES = Stage.$values();
            STAGES = new Stage[Stage.values().length];
            for (Stage stage : Stage.values()) {
                assert (stage.id() < STAGES.length && stage.id() >= 0);
                Stage.STAGES[stage.id] = stage;
            }
        }
    }

    static final class Fields {
        static final String ID = "id";
        static final String STAGE = "stage";
        static final String START_TIME = "start_time";
        static final String START_TIME_IN_MILLIS = "start_time_in_millis";
        static final String STOP_TIME = "stop_time";
        static final String STOP_TIME_IN_MILLIS = "stop_time_in_millis";
        static final String TOTAL_TIME = "total_time";
        static final String TOTAL_TIME_IN_MILLIS = "total_time_in_millis";
        static final String SOURCE = "source";
        static final String HOST = "host";
        static final String TRANSPORT_ADDRESS = "transport_address";
        static final String IP = "ip";
        static final String NAME = "name";
        static final String TARGET = "target";
        static final String INDEX = "index";
        static final String INDEX_NAME = "index_name";
        static final String REPLICATING_STAGE = "replicating_stage";
        static final String GET_CHECKPOINT_INFO_STAGE = "get_checkpoint_info_stage";
        static final String FILE_DIFF_STAGE = "file_diff_stage";
        static final String GET_FILES_STAGE = "get_files_stage";
        static final String FINALIZE_REPLICATION_STAGE = "finalize_replication_stage";

        Fields() {
        }
    }
}

