/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.pipeline.common;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.document.DocumentField;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.search.SearchHit;
import org.opensearch.search.pipeline.AbstractProcessor;
import org.opensearch.search.pipeline.Processor;
import org.opensearch.search.pipeline.SearchResponseProcessor;

public class SortResponseProcessor
extends AbstractProcessor
implements SearchResponseProcessor {
    public static final String TYPE = "sort";
    public static final String SORT_FIELD = "field";
    public static final String SORT_ORDER = "order";
    public static final String TARGET_FIELD = "target_field";
    public static final String DEFAULT_ORDER = "asc";
    private final String sortField;
    private final SortOrder sortOrder;
    private final String targetField;

    SortResponseProcessor(String tag, String description, boolean ignoreFailure, String sortField, SortOrder sortOrder, String targetField) {
        super(tag, description, ignoreFailure);
        this.sortField = Objects.requireNonNull(sortField);
        this.sortOrder = Objects.requireNonNull(sortOrder);
        this.targetField = targetField == null ? sortField : targetField;
    }

    public String getSortField() {
        return this.sortField;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getType() {
        return TYPE;
    }

    public SearchResponse processResponse(SearchRequest request, SearchResponse response) throws Exception {
        SearchHit[] hits;
        for (SearchHit hit : hits = response.getHits().getHits()) {
            BytesReference sourceRef;
            Tuple typeAndSourceMap;
            Map sourceAsMap;
            Map fields = hit.getFields();
            if (fields.containsKey(this.sortField)) {
                DocumentField docField = (DocumentField)hit.getFields().get(this.sortField);
                if (docField == null) {
                    throw new IllegalArgumentException("field [" + this.sortField + "] is null, cannot sort.");
                }
                hit.setDocumentField(this.targetField, new DocumentField(this.targetField, this.getSortedValues(docField.getValues())));
            }
            if (!hit.hasSource() || !(sourceAsMap = (Map)(typeAndSourceMap = XContentHelper.convertToMap((BytesReference)(sourceRef = hit.getSourceRef()), (boolean)false, (MediaType)null)).v2()).containsKey(this.sortField)) continue;
            Object val = sourceAsMap.get(this.sortField);
            if (val instanceof List) {
                List listVal = (List)val;
                sourceAsMap.put(this.targetField, this.getSortedValues(listVal));
            }
            XContentBuilder builder = XContentBuilder.builder((XContent)((MediaType)typeAndSourceMap.v1()).xContent());
            builder.map(sourceAsMap);
            hit.sourceRef(BytesReference.bytes((XContentBuilder)builder));
        }
        return response;
    }

    private List<Object> getSortedValues(List<Object> values) {
        return values.stream().map(this::downcastToComparable).sorted(this.sortOrder.equals((Object)SortOrder.ASCENDING) ? Comparator.naturalOrder() : Comparator.reverseOrder()).collect(Collectors.toList());
    }

    private Comparable<Object> downcastToComparable(Object obj) {
        if (obj instanceof Comparable) {
            return (Comparable)obj;
        }
        if (obj == null) {
            throw new IllegalArgumentException("field [" + this.sortField + "] contains a null value.]");
        }
        throw new IllegalArgumentException("field [" + this.sortField + "] of type [" + obj.getClass().getName() + "] is not comparable.]");
    }

    public static enum SortOrder {
        ASCENDING("asc"),
        DESCENDING("desc");

        private final String direction;

        private SortOrder(String direction) {
            this.direction = direction;
        }

        public String toString() {
            return this.direction;
        }

        public static SortOrder fromString(String value) {
            if (value == null) {
                throw new IllegalArgumentException("Sort direction cannot be null");
            }
            if (value.equals(ASCENDING.toString())) {
                return ASCENDING;
            }
            if (value.equals(DESCENDING.toString())) {
                return DESCENDING;
            }
            throw new IllegalArgumentException("Sort direction [" + value + "] not recognized. Valid values are: [asc, desc]");
        }
    }

    static class Factory
    implements Processor.Factory<SearchResponseProcessor> {
        Factory() {
        }

        public SortResponseProcessor create(Map<String, Processor.Factory<SearchResponseProcessor>> processorFactories, String tag, String description, boolean ignoreFailure, Map<String, Object> config, Processor.PipelineContext pipelineContext) {
            String sortField = ConfigurationUtils.readStringProperty((String)SortResponseProcessor.TYPE, (String)tag, config, (String)SortResponseProcessor.SORT_FIELD);
            String targetField = ConfigurationUtils.readStringProperty((String)SortResponseProcessor.TYPE, (String)tag, config, (String)SortResponseProcessor.TARGET_FIELD, (String)sortField);
            try {
                SortOrder sortOrder = SortOrder.fromString(ConfigurationUtils.readStringProperty((String)SortResponseProcessor.TYPE, (String)tag, config, (String)SortResponseProcessor.SORT_ORDER, (String)SortResponseProcessor.DEFAULT_ORDER));
                return new SortResponseProcessor(tag, description, ignoreFailure, sortField, sortOrder, targetField);
            }
            catch (IllegalArgumentException e) {
                throw ConfigurationUtils.newConfigurationException((String)SortResponseProcessor.TYPE, (String)tag, (String)SortResponseProcessor.SORT_ORDER, (String)e.getMessage());
            }
        }
    }
}

