/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.boot;

import io.quarkus.runtime.annotations.RecordableConstructor;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.spi.ClassTransformer;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.jpa.internal.util.PersistenceUnitTransactionTypeHelper;

public final class QuarkusPersistenceUnitDescriptor
implements PersistenceUnitDescriptor {
    private final String name;
    private final String providerClassName;
    private final boolean useQuotedIdentifiers;
    private final jakarta.persistence.PersistenceUnitTransactionType persistenceUnitTransactionType;
    private final ValidationMode validationMode;
    private final SharedCacheMode sharedCacheMode;
    private final List<String> managedClassNames;
    private final Properties properties;
    private final boolean reactive;

    public QuarkusPersistenceUnitDescriptor(String name, jakarta.persistence.PersistenceUnitTransactionType persistenceUnitTransactionType, List<String> managedClassNames, Properties properties, boolean reactive) {
        this.name = name;
        this.providerClassName = null;
        this.useQuotedIdentifiers = false;
        this.persistenceUnitTransactionType = persistenceUnitTransactionType;
        this.validationMode = null;
        this.sharedCacheMode = null;
        this.managedClassNames = managedClassNames;
        this.properties = properties;
        this.reactive = reactive;
    }

    @Deprecated
    @RecordableConstructor
    public QuarkusPersistenceUnitDescriptor(String name, String providerClassName, boolean useQuotedIdentifiers, jakarta.persistence.PersistenceUnitTransactionType persistenceUnitTransactionType, ValidationMode validationMode, SharedCacheMode sharedCacheMode, List<String> managedClassNames, Properties properties, boolean reactive) {
        this.name = name;
        this.providerClassName = providerClassName;
        this.useQuotedIdentifiers = useQuotedIdentifiers;
        this.persistenceUnitTransactionType = persistenceUnitTransactionType;
        this.validationMode = validationMode;
        this.sharedCacheMode = sharedCacheMode;
        this.managedClassNames = managedClassNames;
        this.properties = properties;
        this.reactive = reactive;
    }

    public static QuarkusPersistenceUnitDescriptor validateAndReadFrom(PersistenceUnitDescriptor toClone) {
        if (toClone instanceof QuarkusPersistenceUnitDescriptor) {
            return (QuarkusPersistenceUnitDescriptor)toClone;
        }
        Objects.requireNonNull(toClone);
        QuarkusPersistenceUnitDescriptor.verifyIgnoredFields(toClone);
        return new QuarkusPersistenceUnitDescriptor(toClone.getName(), toClone.getProviderClassName(), toClone.isUseQuotedIdentifiers(), toClone.getPersistenceUnitTransactionType(), toClone.getValidationMode(), toClone.getSharedCacheMode(), Collections.unmodifiableList(toClone.getManagedClassNames()), toClone.getProperties(), false);
    }

    public URL getPersistenceUnitRootUrl() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getProviderClassName() {
        return this.providerClassName;
    }

    public boolean isUseQuotedIdentifiers() {
        return this.useQuotedIdentifiers;
    }

    public boolean isExcludeUnlistedClasses() {
        return true;
    }

    public jakarta.persistence.PersistenceUnitTransactionType getPersistenceUnitTransactionType() {
        return this.persistenceUnitTransactionType;
    }

    @Deprecated
    public PersistenceUnitTransactionType getTransactionType() {
        return PersistenceUnitTransactionTypeHelper.toDeprecatedForm((jakarta.persistence.PersistenceUnitTransactionType)this.getPersistenceUnitTransactionType());
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public SharedCacheMode getSharedCacheMode() {
        return this.sharedCacheMode;
    }

    public List<String> getManagedClassNames() {
        return this.managedClassNames;
    }

    public List<String> getMappingFileNames() {
        return Collections.emptyList();
    }

    public List<URL> getJarFileUrls() {
        return Collections.emptyList();
    }

    public Object getNonJtaDataSource() {
        return null;
    }

    public Object getJtaDataSource() {
        return null;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public ClassLoader getTempClassLoader() {
        return null;
    }

    public boolean isReactive() {
        return this.reactive;
    }

    public void pushClassTransformer(EnhancementContext enhancementContext) {
    }

    private static void verifyIgnoredFields(PersistenceUnitDescriptor toClone) {
        if (toClone.getJarFileUrls() != null && !toClone.getJarFileUrls().isEmpty()) {
            throw new UnsupportedOperationException("Value found for #getJarFileUrls : not supported yet");
        }
        if (toClone.getJtaDataSource() != null) {
            throw new UnsupportedOperationException("Value found for #getJtaDataSource : not supported yet");
        }
        if (toClone.getNonJtaDataSource() != null) {
            throw new UnsupportedOperationException("Value found for #getNonJtaDataSource : not supported");
        }
    }

    public String toString() {
        return "QuarkusPersistenceUnitDescriptor{name='" + this.name + "', providerClassName='" + this.providerClassName + "', useQuotedIdentifiers=" + this.useQuotedIdentifiers + ", transactionType=" + String.valueOf(this.persistenceUnitTransactionType) + ", validationMode=" + String.valueOf(this.validationMode) + ", sharedCacheMode=" + String.valueOf(this.sharedCacheMode) + ", managedClassNames=" + String.valueOf(this.managedClassNames) + ", properties=" + String.valueOf(this.properties) + ", isReactive=" + this.reactive + "}";
    }

    public ClassTransformer getClassTransformer() {
        return null;
    }
}

