/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime.security;

import io.quarkus.resteasy.reactive.server.runtime.security.EagerSecurityContext;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.MethodDescription;
import io.quarkus.security.spi.runtime.SecurityCheck;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

final class SecurityCheckWithMethodArgsHandler
implements ServerRestHandler {
    private final SecurityCheck securityCheck;
    private final MethodDescription invokedMethodDesc;

    SecurityCheckWithMethodArgsHandler(SecurityCheck securityCheck, MethodDescription invokedMethodDesc) {
        this.securityCheck = securityCheck;
        this.invokedMethodDesc = invokedMethodDesc;
    }

    public void handle(final ResteasyReactiveRequestContext requestContext) {
        if (!EagerSecurityContext.isAuthorizationEnabled()) {
            return;
        }
        requestContext.requireCDIRequestScope();
        requestContext.suspend();
        SecurityIdentity securityIdentity = EagerSecurityContext.getCurrentIdentityAssociation().getIdentity();
        EagerSecurityContext.getInstance().runSecurityCheck(this.securityCheck, this.invokedMethodDesc, requestContext, securityIdentity).subscribe().withSubscriber((UniSubscriber)new UniSubscriber<Object>(){

            public void onSubscribe(UniSubscription subscription) {
            }

            public void onItem(Object item) {
                requestContext.resume();
            }

            public void onFailure(Throwable failure) {
                requestContext.resume(failure, true);
            }
        });
    }
}

