/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.format;

public enum StringJsonDocumentMarker {
    ARRAY_END(']'),
    ARRAY_START('['),
    OBJECT_END('}'),
    OBJECT_START('{'),
    SEPARATOR(','),
    QUOTE('\"'),
    KEY_VALUE_SEPARATOR(':'),
    OTHER;

    private final char val;

    private StringJsonDocumentMarker(char val) {
        this.val = val;
    }

    private StringJsonDocumentMarker() {
        this.val = '\u0000';
    }

    public char getMarkerCharacter() {
        return this.val;
    }

    public static StringJsonDocumentMarker markerOf(char ch) {
        switch (ch) {
            case ']': {
                return ARRAY_END;
            }
            case '[': {
                return ARRAY_START;
            }
            case '}': {
                return OBJECT_END;
            }
            case '{': {
                return OBJECT_START;
            }
            case ',': {
                return SEPARATOR;
            }
            case '\"': {
                return QUOTE;
            }
            case ':': {
                return KEY_VALUE_SEPARATOR;
            }
        }
        return OTHER;
    }
}

