/*
 * Decompiled with CFR 0.152.
 */
package jspecview.java;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.net.URL;
import jspecview.java.AwtColor;
import org.jmol.api.PlatformViewer;

class Image {
    private static final DirectColorModel rgbColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
    private static final int[] sampleModelBitMasks = new int[]{0xFF0000, 65280, 255};

    Image() {
    }

    static Object createImage(Object object) {
        if (object instanceof URL) {
            return Toolkit.getDefaultToolkit().createImage((URL)object);
        }
        if (object instanceof String) {
            return Toolkit.getDefaultToolkit().createImage((String)object);
        }
        if (object instanceof byte[]) {
            return Toolkit.getDefaultToolkit().createImage((byte[])object);
        }
        return null;
    }

    static void waitForDisplay(PlatformViewer platformViewer, Object object) throws InterruptedException {
        Object var2_2 = null;
        MediaTracker mediaTracker = new MediaTracker(var2_2);
        int n = (int)(Math.random() * 100000.0);
        mediaTracker.addImage((java.awt.Image)object, n);
        mediaTracker.waitForID(n);
    }

    static int getWidth(Object object) {
        return ((java.awt.Image)object).getWidth(null);
    }

    static int getHeight(Object object) {
        return ((java.awt.Image)object).getHeight(null);
    }

    static int[] grabPixels(Object object, int n, int n2, int[] nArray) {
        BufferedImage bufferedImage = (BufferedImage)object;
        int n3 = bufferedImage.getWidth();
        int[] nArray2 = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        if (n3 == n && bufferedImage.getHeight() == n2) {
            return nArray2;
        }
        if (nArray == null) {
            nArray = new int[n * n2];
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = n3 - n;
        while (n4 < n2) {
            int n8 = 0;
            while (n8 < n) {
                nArray[n5++] = nArray2[n6++];
                ++n8;
            }
            ++n4;
            n6 += n7;
        }
        return nArray;
    }

    static int[] drawImageToBuffer(Object object, Object object2, Object object3, int n, int n2, int n3) {
        Graphics graphics = (Graphics)object;
        java.awt.Image image = (java.awt.Image)object3;
        int n4 = image.getWidth(null);
        int n5 = image.getHeight(null);
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(5, 1.0f));
            graphics.setColor(n3 == 0 ? new AwtColor(0, 0, 0, 0) : new AwtColor(n3));
            graphics.fillRect(0, 0, n, n2);
            ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, 1.0f));
            graphics.drawImage(image, 0, 0, n, n2, 0, 0, n4, n5, null);
        } else {
            graphics.clearRect(0, 0, n, n2);
            graphics.drawImage(image, 0, 0, n, n2, 0, 0, n4, n5, null);
        }
        return Image.grabPixels(object2, n, n2, null);
    }

    public static int[] getTextPixels(String string, org.jmol.util.Font font, Object object, Object object2, int n, int n2, int n3) {
        Graphics graphics = (Graphics)object;
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(Color.white);
        graphics.setFont((Font)font.font);
        graphics.drawString(string, 0, n3);
        return Image.grabPixels(object2, n, n2, null);
    }

    static Object newBufferedImage(Object object, int n, int n2) {
        return new BufferedImage(n, n2, ((BufferedImage)object).getType());
    }

    static Object newBufferedImage(int n, int n2) {
        return new BufferedImage(n, n2, 2);
    }

    static Object allocateRgbImage(int n, int n2, int[] nArray, int n3, boolean bl) {
        return new BufferedImage(rgbColorModel, Raster.createWritableRaster(new SinglePixelPackedSampleModel(3, n, n2, sampleModelBitMasks), new DataBufferInt(nArray, n3), null), false, null);
    }

    static Object getStaticGraphics(Object object, boolean bl) {
        Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        return graphics2D;
    }

    static Object getGraphics(Object object) {
        return ((java.awt.Image)object).getGraphics();
    }

    static void drawImage(Object object, Object object2, int n, int n2, int n3, int n4) {
        ((Graphics)object).drawImage((java.awt.Image)object2, n, n2, null);
    }

    static void flush(Object object) {
        ((java.awt.Image)object).flush();
    }

    static void disposeGraphics(Object object) {
        ((Graphics)object).dispose();
    }
}

