/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import shadow.bundletool.com.android.ddmlib.AdbCommandRejectedException;
import shadow.bundletool.com.android.ddmlib.AdbHelper;
import shadow.bundletool.com.android.ddmlib.IDevice;
import shadow.bundletool.com.android.ddmlib.InstallCreateReceiver;
import shadow.bundletool.com.android.ddmlib.InstallException;
import shadow.bundletool.com.android.ddmlib.InstallReceiver;
import shadow.bundletool.com.android.ddmlib.Log;
import shadow.bundletool.com.android.ddmlib.ShellCommandUnresponsiveException;
import shadow.bundletool.com.android.ddmlib.TimeoutException;
import shadow.bundletool.com.android.sdklib.AndroidVersion;

public abstract class SplitApkInstallerBase {
    private static final String LOG_TAG = "SplitApkInstallerBase";
    private static boolean abbExecAllowed = true;
    protected final IDevice mDevice;
    private final String mOptions;
    private final String mPrefix;
    private final AdbHelper.AdbService mService;
    private final AdbHelper.AdbService mServiceWrite;

    protected SplitApkInstallerBase(IDevice device, String options) {
        this.mDevice = device;
        this.mOptions = options;
        if (this.mDevice.supportsFeature(IDevice.Feature.ABB_EXEC) && abbExecAllowed) {
            this.mPrefix = "package";
            this.mService = AdbHelper.AdbService.ABB_EXEC;
            this.mServiceWrite = AdbHelper.AdbService.ABB_EXEC;
        } else if (SplitApkInstallerBase.supportsCmd(device)) {
            this.mPrefix = "cmd package";
            this.mService = AdbHelper.AdbService.SHELL;
            this.mServiceWrite = AdbHelper.AdbService.EXEC;
        } else {
            this.mPrefix = "pm";
            this.mService = AdbHelper.AdbService.SHELL;
            this.mServiceWrite = AdbHelper.AdbService.EXEC;
        }
        Log.i(LOG_TAG, String.format("Install-Write Strategy '%s' over '%s'", this.mPrefix, this.mServiceWrite.name()));
    }

    private static boolean supportsCmd(IDevice device) {
        return device.getVersion().isGreaterOrEqualThan(AndroidVersion.BINDER_CMD_AVAILABLE.getApiLevel());
    }

    static void setAbbExecAllowed(boolean allowed) {
        abbExecAllowed = allowed;
    }

    protected String createMultiInstallSession(String options, long timeout, TimeUnit unit) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, InstallException {
        InstallCreateReceiver receiver = new InstallCreateReceiver();
        String cmd = this.mPrefix + " install-create";
        if (!options.trim().isEmpty()) {
            cmd = cmd + " " + options;
        }
        this.mDevice.executeRemoteCommand(this.mService, cmd, receiver, 0L, timeout, unit, null);
        String sessionId = receiver.getSessionId();
        if (sessionId == null) {
            String message2 = String.format("'%s'", cmd);
            message2 = receiver.getErrorMessage() != null ? String.format("%s returns error '%s'", message2, receiver.getErrorMessage()) : (receiver.getSuccessMessage() != null ? String.format("%s returns '%s' without session ID", message2, receiver.getSuccessMessage()) : String.format("Failed to create install session with %s", message2));
            Log.e(LOG_TAG, message2);
            throw new InstallException(message2);
        }
        Log.i(LOG_TAG, String.format("Created install session %s with options %s", sessionId, options));
        return sessionId;
    }

    protected void installCommit(String sessionId, long timeout, TimeUnit unit) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, InstallException {
        String command = this.mPrefix + " install-commit " + sessionId;
        InstallReceiver receiver = new InstallReceiver();
        this.mDevice.executeRemoteCommand(this.mService, command, receiver, 0L, timeout, unit, null);
        if (!receiver.isSuccessfullyCompleted()) {
            Object message2 = String.format("Failed to commit install session %s with command %s.", sessionId, command);
            if (receiver.getErrorMessage() != null) {
                message2 = (String)message2 + String.format(" Error: %s", receiver.getErrorMessage());
            }
            Log.e(LOG_TAG, (String)message2);
            throw new InstallException((String)message2, receiver.getErrorCode());
        }
    }

    protected void installAbandon(String sessionId, long timeout, TimeUnit unit) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, InstallException {
        String command = this.mPrefix + " install-abandon " + sessionId;
        InstallReceiver receiver = new InstallReceiver();
        this.mDevice.executeRemoteCommand(this.mService, command, receiver, 0L, timeout, unit, null);
        if (!receiver.isSuccessfullyCompleted()) {
            Log.e(LOG_TAG, String.format("Failed to abandon install session %s", sessionId));
        }
    }

    protected IDevice getDevice() {
        return this.mDevice;
    }

    protected String getPrefix() {
        return this.mPrefix;
    }

    protected String getOptions() {
        return this.mOptions;
    }

    protected AdbHelper.AdbService getService() {
        return this.mService;
    }

    protected AdbHelper.AdbService getServiceWrite() {
        return this.mServiceWrite;
    }

    protected static String getOptions(boolean reInstall, List<String> installOptions) {
        return SplitApkInstallerBase.getOptions(reInstall, false, null, installOptions);
    }

    protected static String getOptions(boolean reInstall, boolean partialInstall, String applicationId, List<String> installOptions) {
        StringBuilder sb5 = new StringBuilder();
        if (reInstall) {
            sb5.append("-r");
        }
        if (partialInstall) {
            if (sb5.length() > 0) {
                sb5.append(" ");
            }
            if (applicationId == null) {
                throw new IllegalArgumentException("Cannot do a partial install without knowing the application id");
            }
            sb5.append("-p ");
            sb5.append(applicationId);
        }
        if (!installOptions.isEmpty()) {
            if (sb5.length() > 0) {
                sb5.append(" ");
            }
            sb5.append(Joiner.on(" ").join(installOptions));
        }
        return sb5.toString();
    }

    protected static void validateApiLevel(IDevice device) {
        int apiWithSplitApk = AndroidVersion.ALLOW_SPLIT_APK_INSTALLATION.getApiLevel();
        if (!device.getVersion().isGreaterOrEqualThan(apiWithSplitApk)) {
            throw new IllegalArgumentException(String.format("Device %s API level=%d. Cannot install split APKs with API level < %d", device.getSerialNumber(), device.getVersion().getApiLevel(), apiWithSplitApk));
        }
    }
}

