/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.InstanceScope;
import org.stringtemplate.v4.ModelAdaptor;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STWriter;
import org.stringtemplate.v4.compiler.BytecodeDisassembler;
import org.stringtemplate.v4.compiler.CompiledST;
import org.stringtemplate.v4.compiler.Compiler;
import org.stringtemplate.v4.compiler.FormalArgument;
import org.stringtemplate.v4.debug.EvalExprEvent;
import org.stringtemplate.v4.debug.EvalTemplateEvent;
import org.stringtemplate.v4.debug.IndentEvent;
import org.stringtemplate.v4.debug.InterpEvent;
import org.stringtemplate.v4.misc.ArrayIterator;
import org.stringtemplate.v4.misc.ErrorManager;
import org.stringtemplate.v4.misc.ErrorType;
import org.stringtemplate.v4.misc.Interval;
import org.stringtemplate.v4.misc.Misc;
import org.stringtemplate.v4.misc.STNoSuchAttributeException;
import org.stringtemplate.v4.misc.STNoSuchPropertyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interpreter {
    public static final int DEFAULT_OPERAND_STACK_SIZE = 100;
    public static final Set<String> predefinedAnonSubtemplateAttributes = new HashSet<String>(){
        {
            this.add("i");
            this.add("i0");
        }
    };
    Object[] operands = new Object[100];
    int sp = -1;
    int nwline = 0;
    STGroup group;
    Locale locale;
    ErrorManager errMgr;
    public static boolean trace = false;
    protected List<String> executeTrace;
    public boolean debug = false;
    protected List<InterpEvent> events;

    public Interpreter(STGroup group, boolean debug) {
        this(group, Locale.getDefault(), group.errMgr, debug);
    }

    public Interpreter(STGroup group, Locale locale, boolean debug) {
        this(group, locale, group.errMgr, debug);
    }

    public Interpreter(STGroup group, ErrorManager errMgr, boolean debug) {
        this(group, Locale.getDefault(), errMgr, debug);
    }

    public Interpreter(STGroup group, Locale locale, ErrorManager errMgr, boolean debug) {
        this.group = group;
        this.locale = locale;
        this.errMgr = errMgr;
        this.debug = debug;
        if (debug) {
            this.events = new ArrayList<InterpEvent>();
            this.executeTrace = new ArrayList<String>();
        }
    }

    public int exec(STWriter out, InstanceScope scope) {
        ST self = scope.st;
        if (trace) {
            System.out.println("exec(" + self.getName() + ")");
        }
        try {
            this.setDefaultArguments(out, scope);
            return this._exec(out, scope);
        }
        catch (Exception e15) {
            StringWriter sw4 = new StringWriter();
            PrintWriter pw4 = new PrintWriter(sw4);
            e15.printStackTrace(pw4);
            pw4.flush();
            this.errMgr.runTimeError(this, scope, ErrorType.INTERNAL_ERROR, "internal error: " + sw4.toString());
            return 0;
        }
    }

    protected int _exec(STWriter out, InstanceScope scope) {
        ST self = scope.st;
        int start = out.index();
        short prevOpcode = 0;
        int n15 = 0;
        byte[] code = self.impl.instrs;
        int ip4 = 0;
        while (ip4 < self.impl.codeSize) {
            if (trace || this.debug) {
                this.trace(scope, ip4);
            }
            short opcode = code[ip4];
            scope.ip = ip4++;
            switch (opcode) {
                case 1: {
                    this.load_str(self, ip4);
                    ip4 += 2;
                    break;
                }
                case 2: {
                    Object o15;
                    int nameIndex = Interpreter.getShort(code, ip4);
                    ip4 += 2;
                    String name = self.impl.strings[nameIndex];
                    try {
                        o15 = this.getAttribute(scope, name);
                        if (o15 == ST.EMPTY_ATTR) {
                            o15 = null;
                        }
                    }
                    catch (STNoSuchAttributeException nsae) {
                        this.errMgr.runTimeError(this, scope, ErrorType.NO_SUCH_ATTRIBUTE, name);
                        o15 = null;
                    }
                    this.operands[++this.sp] = o15;
                    break;
                }
                case 3: {
                    int valueIndex = Interpreter.getShort(code, ip4);
                    ip4 += 2;
                    Object o15 = self.locals[valueIndex];
                    if (o15 == ST.EMPTY_ATTR) {
                        o15 = null;
                    }
                    this.operands[++this.sp] = o15;
                    break;
                }
                case 4: {
                    int nameIndex = Interpreter.getShort(code, ip4);
                    ip4 += 2;
                    Object o15 = this.operands[this.sp--];
                    String name = self.impl.strings[nameIndex];
                    this.operands[++this.sp] = this.getObjectProperty(out, scope, o15, name);
                    break;
                }
                case 5: {
                    Object propName = this.operands[this.sp--];
                    Object o15 = this.operands[this.sp];
                    this.operands[this.sp] = this.getObjectProperty(out, scope, o15, propName);
                    break;
                }
                case 8: {
                    int nameIndex = Interpreter.getShort(code, ip4);
                    String name = self.impl.strings[nameIndex];
                    int nargs = Interpreter.getShort(code, ip4 += 2);
                    ip4 += 2;
                    ST st4 = self.groupThatCreatedThisInstance.getEmbeddedInstanceOf(this, scope, name);
                    this.storeArgs(scope, nargs, st4);
                    this.sp -= nargs;
                    this.operands[++this.sp] = st4;
                    break;
                }
                case 9: {
                    int nargs = Interpreter.getShort(code, ip4);
                    ip4 += 2;
                    String name = (String)this.operands[this.sp - nargs];
                    ST st4 = self.groupThatCreatedThisInstance.getEmbeddedInstanceOf(this, scope, name);
                    this.storeArgs(scope, nargs, st4);
                    this.sp -= nargs;
                    --this.sp;
                    this.operands[++this.sp] = st4;
                    break;
                }
                case 10: {
                    int nameIndex = Interpreter.getShort(code, ip4);
                    ip4 += 2;
                    String name = self.impl.strings[nameIndex];
                    ArgumentsMap attrs = (ArgumentsMap)this.operands[this.sp--];
                    ST st4 = self.groupThatCreatedThisInstance.getEmbeddedInstanceOf(this, scope, name);
                    this.storeArgs(scope, attrs, st4);
                    this.operands[++this.sp] = st4;
                    break;
                }
                case 11: {
                    int nameIndex = Interpreter.getShort(code, ip4);
                    String name = self.impl.strings[nameIndex];
                    int nargs = Interpreter.getShort(code, ip4 += 2);
                    ip4 += 2;
                    this.super_new(scope, name, nargs);
                    break;
                }
                case 12: {
                    int nameIndex = Interpreter.getShort(code, ip4);
                    ip4 += 2;
                    String name = self.impl.strings[nameIndex];
                    ArgumentsMap attrs = (ArgumentsMap)this.operands[this.sp--];
                    this.super_new(scope, name, attrs);
                    break;
                }
                case 6: {
                    int optionIndex = Interpreter.getShort(code, ip4);
                    ip4 += 2;
                    Object o15 = this.operands[this.sp--];
                    Object[] options = (Object[])this.operands[this.sp];
                    options[optionIndex] = o15;
                    break;
                }
                case 7: {
                    int nameIndex = Interpreter.getShort(code, ip4);
                    String name = self.impl.strings[nameIndex];
                    ip4 += 2;
                    Object o15 = this.operands[this.sp--];
                    ArgumentsMap attrs = (ArgumentsMap)this.operands[this.sp];
                    attrs.put(name, o15);
                    break;
                }
                case 13: {
                    Object o15 = this.operands[this.sp--];
                    int n16 = this.writeObjectNoOptions(out, scope, o15);
                    n15 += n16;
                    this.nwline += n16;
                    break;
                }
                case 14: {
                    Object[] options = (Object[])this.operands[this.sp--];
                    Object o15 = this.operands[this.sp--];
                    int n25 = this.writeObjectWithOptions(out, scope, o15, options);
                    n15 += n25;
                    this.nwline += n25;
                    break;
                }
                case 15: {
                    ST st4 = (ST)this.operands[this.sp--];
                    Object o15 = this.operands[this.sp--];
                    this.map(scope, o15, st4);
                    break;
                }
                case 16: {
                    Object o15;
                    int nmaps = Interpreter.getShort(code, ip4);
                    ip4 += 2;
                    ArrayList<ST> templates = new ArrayList<ST>();
                    for (int i15 = nmaps - 1; i15 >= 0; --i15) {
                        templates.add((ST)this.operands[this.sp - i15]);
                    }
                    this.sp -= nmaps;
                    if ((o15 = this.operands[this.sp--]) == null) break;
                    this.rot_map(scope, o15, templates);
                    break;
                }
                case 17: {
                    ST st4 = (ST)this.operands[this.sp--];
                    int nmaps = Interpreter.getShort(code, ip4);
                    ip4 += 2;
                    ObjectList exprs = new ObjectList();
                    for (int i16 = nmaps - 1; i16 >= 0; --i16) {
                        exprs.add(this.operands[this.sp - i16]);
                    }
                    this.sp -= nmaps;
                    this.operands[++this.sp] = this.zip_map(scope, exprs, st4);
                    break;
                }
                case 18: {
                    ip4 = Interpreter.getShort(code, ip4);
                    break;
                }
                case 19: {
                    int addr = Interpreter.getShort(code, ip4);
                    ip4 += 2;
                    Object o15 = this.operands[this.sp--];
                    if (this.testAttributeTrue(o15)) break;
                    ip4 = addr;
                    break;
                }
                case 20: {
                    this.operands[++this.sp] = new Object[Compiler.NUM_OPTIONS];
                    break;
                }
                case 21: {
                    this.operands[++this.sp] = new ArgumentsMap();
                    break;
                }
                case 22: {
                    int nameIndex = Interpreter.getShort(code, ip4);
                    ip4 += 2;
                    String name = self.impl.strings[nameIndex];
                    ArgumentsMap attrs = (ArgumentsMap)this.operands[this.sp];
                    this.passthru(scope, name, attrs);
                    break;
                }
                case 24: {
                    this.operands[++this.sp] = new ObjectList();
                    break;
                }
                case 25: {
                    Object o15 = this.operands[this.sp--];
                    ObjectList list2 = (ObjectList)this.operands[this.sp];
                    this.addToList(scope, list2, o15);
                    break;
                }
                case 26: {
                    this.operands[this.sp] = this.toString(out, scope, this.operands[this.sp]);
                    break;
                }
                case 27: {
                    this.operands[this.sp] = this.first(scope, this.operands[this.sp]);
                    break;
                }
                case 28: {
                    this.operands[this.sp] = this.last(scope, this.operands[this.sp]);
                    break;
                }
                case 29: {
                    this.operands[this.sp] = this.rest(scope, this.operands[this.sp]);
                    break;
                }
                case 30: {
                    this.operands[this.sp] = this.trunc(scope, this.operands[this.sp]);
                    break;
                }
                case 31: {
                    this.operands[this.sp] = this.strip(scope, this.operands[this.sp]);
                    break;
                }
                case 32: {
                    Object o15 = this.operands[this.sp--];
                    if (o15.getClass() == String.class) {
                        this.operands[++this.sp] = ((String)o15).trim();
                        break;
                    }
                    this.errMgr.runTimeError(this, scope, ErrorType.EXPECTING_STRING, "trim", (Object)o15.getClass().getName());
                    this.operands[++this.sp] = o15;
                    break;
                }
                case 33: {
                    this.operands[this.sp] = this.length(this.operands[this.sp]);
                    break;
                }
                case 34: {
                    Object o15 = this.operands[this.sp--];
                    if (o15.getClass() == String.class) {
                        this.operands[++this.sp] = ((String)o15).length();
                        break;
                    }
                    this.errMgr.runTimeError(this, scope, ErrorType.EXPECTING_STRING, "strlen", (Object)o15.getClass().getName());
                    this.operands[++this.sp] = 0;
                    break;
                }
                case 35: {
                    this.operands[this.sp] = this.reverse(scope, this.operands[this.sp]);
                    break;
                }
                case 36: {
                    this.operands[this.sp] = !this.testAttributeTrue(this.operands[this.sp]);
                    break;
                }
                case 37: {
                    Object right = this.operands[this.sp--];
                    Object left = this.operands[this.sp--];
                    this.operands[++this.sp] = this.testAttributeTrue(left) || this.testAttributeTrue(right);
                    break;
                }
                case 38: {
                    Object right = this.operands[this.sp--];
                    Object left = this.operands[this.sp--];
                    this.operands[++this.sp] = this.testAttributeTrue(left) && this.testAttributeTrue(right);
                    break;
                }
                case 39: {
                    int strIndex = Interpreter.getShort(code, ip4);
                    ip4 += 2;
                    this.indent(out, scope, strIndex);
                    break;
                }
                case 40: {
                    out.popIndentation();
                    break;
                }
                case 41: {
                    try {
                        if (prevOpcode == 41 || prevOpcode == 39 || this.nwline > 0) {
                            out.write(Misc.newline);
                        }
                        this.nwline = 0;
                    }
                    catch (IOException ioe) {
                        this.errMgr.IOError(self, ErrorType.WRITE_IO_ERROR, ioe);
                    }
                    break;
                }
                case 42: {
                    break;
                }
                case 43: {
                    --this.sp;
                    break;
                }
                case 44: {
                    this.operands[++this.sp] = null;
                    break;
                }
                case 45: {
                    this.operands[++this.sp] = true;
                    break;
                }
                case 46: {
                    this.operands[++this.sp] = false;
                    break;
                }
                case 47: {
                    int strIndex = Interpreter.getShort(code, ip4);
                    ip4 += 2;
                    Object o15 = self.impl.strings[strIndex];
                    int n16 = this.writeObjectNoOptions(out, scope, o15);
                    n15 += n16;
                    this.nwline += n16;
                    break;
                }
                default: {
                    this.errMgr.internalError(self, "invalid bytecode @ " + (ip4 - 1) + ": " + opcode, null);
                    self.impl.dump();
                }
            }
            prevOpcode = opcode;
        }
        if (this.debug) {
            int stop = out.index() - 1;
            EvalTemplateEvent e15 = new EvalTemplateEvent(scope, start, stop);
            this.trackDebugEvent(scope, e15);
        }
        return n15;
    }

    void load_str(ST self, int ip4) {
        int strIndex = Interpreter.getShort(self.impl.instrs, ip4);
        ip4 += 2;
        this.operands[++this.sp] = self.impl.strings[strIndex];
    }

    void super_new(InstanceScope scope, String name, int nargs) {
        ST self = scope.st;
        ST st4 = null;
        CompiledST imported = self.impl.nativeGroup.lookupImportedTemplate(name);
        if (imported == null) {
            this.errMgr.runTimeError(this, scope, ErrorType.NO_IMPORTED_TEMPLATE, name);
            st4 = self.groupThatCreatedThisInstance.createStringTemplateInternally(new CompiledST());
        } else {
            st4 = imported.nativeGroup.getEmbeddedInstanceOf(this, scope, name);
            st4.groupThatCreatedThisInstance = this.group;
        }
        this.storeArgs(scope, nargs, st4);
        this.sp -= nargs;
        this.operands[++this.sp] = st4;
    }

    void super_new(InstanceScope scope, String name, Map<String, Object> attrs) {
        ST self = scope.st;
        ST st4 = null;
        CompiledST imported = self.impl.nativeGroup.lookupImportedTemplate(name);
        if (imported == null) {
            this.errMgr.runTimeError(this, scope, ErrorType.NO_IMPORTED_TEMPLATE, name);
            st4 = self.groupThatCreatedThisInstance.createStringTemplateInternally(new CompiledST());
        } else {
            st4 = imported.nativeGroup.createStringTemplateInternally(imported);
            st4.groupThatCreatedThisInstance = this.group;
        }
        this.storeArgs(scope, attrs, st4);
        this.operands[++this.sp] = st4;
    }

    void passthru(InstanceScope scope, String templateName, Map<String, Object> attrs) {
        CompiledST c15 = this.group.lookupTemplate(templateName);
        if (c15 == null) {
            return;
        }
        if (c15.formalArguments == null) {
            return;
        }
        for (FormalArgument arg : c15.formalArguments.values()) {
            if (attrs.containsKey(arg.name)) continue;
            try {
                Object o15 = this.getAttribute(scope, arg.name);
                if (o15 == ST.EMPTY_ATTR && arg.defaultValueToken == null) {
                    attrs.put(arg.name, null);
                    continue;
                }
                if (o15 == ST.EMPTY_ATTR) continue;
                attrs.put(arg.name, o15);
            }
            catch (STNoSuchAttributeException nsae) {
                if (arg.defaultValueToken != null) continue;
                this.errMgr.runTimeError(this, scope, ErrorType.NO_SUCH_ATTRIBUTE_PASS_THROUGH, arg.name);
                attrs.put(arg.name, null);
            }
        }
    }

    void storeArgs(InstanceScope scope, Map<String, Object> attrs, ST st4) {
        if (st4.impl.hasFormalArgs) {
            boolean argumentCountMismatch = false;
            Map<String, FormalArgument> formalArguments = st4.impl.formalArguments;
            if (formalArguments == null) {
                formalArguments = Collections.emptyMap();
            }
            for (Map.Entry<String, FormalArgument> formalArgument : formalArguments.entrySet()) {
                if (formalArgument.getValue().defaultValueToken != null || formalArgument.getValue().defaultValue != null || attrs != null && attrs.containsKey(formalArgument.getKey())) continue;
                argumentCountMismatch = true;
                break;
            }
            if (attrs != null && attrs.size() > formalArguments.size()) {
                argumentCountMismatch = true;
            }
            if (argumentCountMismatch) {
                int nargs = attrs != null ? attrs.size() : 0;
                int nformalArgs = formalArguments.size();
                this.errMgr.runTimeError(this, scope, ErrorType.ARGUMENT_COUNT_MISMATCH, nargs, st4.impl.name, nformalArgs);
            }
        }
        if (attrs != null) {
            for (Map.Entry<String, Object> argument : attrs.entrySet()) {
                if (!st4.impl.hasFormalArgs) {
                    if (st4.impl.formalArguments == null || !st4.impl.formalArguments.containsKey(argument.getKey())) {
                        try {
                            st4.impl = st4.impl.clone();
                            st4.add(argument.getKey(), argument.getValue());
                        }
                        catch (CloneNotSupportedException ex4) {
                            this.errMgr.runTimeError(this, scope, ErrorType.NO_SUCH_ATTRIBUTE, argument.getKey());
                        }
                        continue;
                    }
                    st4.rawSetAttribute(argument.getKey(), argument.getValue());
                    continue;
                }
                if (st4.impl.formalArguments == null || !st4.impl.formalArguments.containsKey(argument.getKey())) {
                    this.errMgr.runTimeError(this, scope, ErrorType.NO_SUCH_ATTRIBUTE, argument.getKey());
                    continue;
                }
                st4.rawSetAttribute(argument.getKey(), argument.getValue());
            }
        }
    }

    void storeArgs(InstanceScope scope, int nargs, ST st4) {
        if (nargs > 0 && !st4.impl.hasFormalArgs && st4.impl.formalArguments == null) {
            st4.add("it", null);
        }
        int nformalArgs = 0;
        if (st4.impl.formalArguments != null) {
            nformalArgs = st4.impl.formalArguments.size();
        }
        int firstArg = this.sp - (nargs - 1);
        int numToStore = Math.min(nargs, nformalArgs);
        if (st4.impl.isAnonSubtemplate) {
            nformalArgs -= predefinedAnonSubtemplateAttributes.size();
        }
        if (nargs < nformalArgs - st4.impl.numberOfArgsWithDefaultValues || nargs > nformalArgs) {
            this.errMgr.runTimeError(this, scope, ErrorType.ARGUMENT_COUNT_MISMATCH, nargs, st4.impl.name, nformalArgs);
        }
        if (st4.impl.formalArguments == null) {
            return;
        }
        Iterator<String> argNames = st4.impl.formalArguments.keySet().iterator();
        for (int i15 = 0; i15 < numToStore; ++i15) {
            Object o15 = this.operands[firstArg + i15];
            String argName = argNames.next();
            st4.rawSetAttribute(argName, o15);
        }
    }

    protected void indent(STWriter out, InstanceScope scope, int strIndex) {
        String indent = scope.st.impl.strings[strIndex];
        if (this.debug) {
            int start = out.index();
            IndentEvent e15 = new IndentEvent(scope, start, start + indent.length() - 1, this.getExprStartChar(scope), this.getExprStopChar(scope));
            this.trackDebugEvent(scope, e15);
        }
        out.pushIndentation(indent);
    }

    protected int writeObjectNoOptions(STWriter out, InstanceScope scope, Object o15) {
        int start = out.index();
        int n15 = this.writeObject(out, scope, o15, null);
        if (this.debug) {
            EvalExprEvent e15 = new EvalExprEvent(scope, start, out.index() - 1, this.getExprStartChar(scope), this.getExprStopChar(scope));
            this.trackDebugEvent(scope, e15);
        }
        return n15;
    }

    protected int writeObjectWithOptions(STWriter out, InstanceScope scope, Object o15, Object[] options) {
        int start = out.index();
        String[] optionStrings = null;
        if (options != null) {
            optionStrings = new String[options.length];
            for (int i15 = 0; i15 < Compiler.NUM_OPTIONS; ++i15) {
                optionStrings[i15] = this.toString(out, scope, options[i15]);
            }
        }
        if (options != null && options[Option.ANCHOR.ordinal()] != null) {
            out.pushAnchorPoint();
        }
        int n15 = this.writeObject(out, scope, o15, optionStrings);
        if (options != null && options[Option.ANCHOR.ordinal()] != null) {
            out.popAnchorPoint();
        }
        if (this.debug) {
            EvalExprEvent e15 = new EvalExprEvent(scope, start, out.index() - 1, this.getExprStartChar(scope), this.getExprStopChar(scope));
            this.trackDebugEvent(scope, e15);
        }
        return n15;
    }

    protected int writeObject(STWriter out, InstanceScope scope, Object o15, String[] options) {
        int n15 = 0;
        if (o15 == null) {
            if (options != null && options[Option.NULL.ordinal()] != null) {
                o15 = options[Option.NULL.ordinal()];
            } else {
                return 0;
            }
        }
        if (o15 instanceof ST) {
            scope = new InstanceScope(scope, (ST)o15);
            if (options != null && options[Option.WRAP.ordinal()] != null) {
                try {
                    out.writeWrap(options[Option.WRAP.ordinal()]);
                }
                catch (IOException ioe) {
                    this.errMgr.IOError(scope.st, ErrorType.WRITE_IO_ERROR, ioe);
                }
            }
            n15 = this.exec(out, scope);
        } else {
            o15 = this.convertAnythingIteratableToIterator(scope, o15);
            try {
                n15 = o15 instanceof Iterator ? this.writeIterator(out, scope, o15, options) : this.writePOJO(out, scope, o15, options);
            }
            catch (IOException ioe) {
                this.errMgr.IOError(scope.st, ErrorType.WRITE_IO_ERROR, ioe, o15);
            }
        }
        return n15;
    }

    protected int writeIterator(STWriter out, InstanceScope scope, Object o15, String[] options) throws IOException {
        if (o15 == null) {
            return 0;
        }
        int n15 = 0;
        Iterator it = (Iterator)o15;
        String separator = null;
        if (options != null) {
            separator = options[Option.SEPARATOR.ordinal()];
        }
        boolean seenAValue = false;
        while (it.hasNext()) {
            int nw4;
            boolean needSeparator;
            Object iterValue = it.next();
            boolean bl4 = needSeparator = seenAValue && separator != null && (iterValue != null || options[Option.NULL.ordinal()] != null);
            if (needSeparator) {
                n15 += out.writeSeparator(separator);
            }
            if ((nw4 = this.writeObject(out, scope, iterValue, options)) > 0) {
                seenAValue = true;
            }
            n15 += nw4;
        }
        return n15;
    }

    protected int writePOJO(STWriter out, InstanceScope scope, Object o15, String[] options) throws IOException {
        AttributeRenderer r15;
        String formatString = null;
        if (options != null) {
            formatString = options[Option.FORMAT.ordinal()];
        }
        String v15 = (r15 = scope.st.impl.nativeGroup.getAttributeRenderer(o15.getClass())) != null ? r15.toString(o15, formatString, this.locale) : o15.toString();
        int n15 = options != null && options[Option.WRAP.ordinal()] != null ? out.write(v15, options[Option.WRAP.ordinal()]) : out.write(v15);
        return n15;
    }

    protected int getExprStartChar(InstanceScope scope) {
        Interval templateLocation = scope.st.impl.sourceMap[scope.ip];
        if (templateLocation != null) {
            return templateLocation.a;
        }
        return -1;
    }

    protected int getExprStopChar(InstanceScope scope) {
        Interval templateLocation = scope.st.impl.sourceMap[scope.ip];
        if (templateLocation != null) {
            return templateLocation.b;
        }
        return -1;
    }

    protected void map(InstanceScope scope, Object attr, final ST st4) {
        this.rot_map(scope, attr, (List<ST>)new ArrayList<ST>(){
            {
                this.add(st4);
            }
        });
    }

    protected void rot_map(InstanceScope scope, Object attr, List<ST> prototypes) {
        if (attr == null) {
            this.operands[++this.sp] = null;
            return;
        }
        if ((attr = this.convertAnythingIteratableToIterator(scope, attr)) instanceof Iterator) {
            List<ST> mapped = this.rot_map_iterator(scope, (Iterator)attr, prototypes);
            this.operands[++this.sp] = mapped;
        } else {
            ST proto = prototypes.get(0);
            ST st4 = this.group.createStringTemplateInternally(proto);
            if (st4 != null) {
                this.setFirstArgument(scope, st4, attr);
                if (st4.impl.isAnonSubtemplate) {
                    st4.rawSetAttribute("i0", 0);
                    st4.rawSetAttribute("i", 1);
                }
                this.operands[++this.sp] = st4;
            } else {
                this.operands[++this.sp] = null;
            }
        }
    }

    protected List<ST> rot_map_iterator(InstanceScope scope, Iterator<?> attr, List<ST> prototypes) {
        ArrayList<ST> mapped = new ArrayList<ST>();
        Iterator<?> iter = attr;
        int i05 = 0;
        int i15 = 1;
        int ti4 = 0;
        while (iter.hasNext()) {
            Object iterValue = iter.next();
            if (iterValue == null) {
                mapped.add(null);
                continue;
            }
            int templateIndex = ti4 % prototypes.size();
            ++ti4;
            ST proto = prototypes.get(templateIndex);
            ST st4 = this.group.createStringTemplateInternally(proto);
            this.setFirstArgument(scope, st4, iterValue);
            if (st4.impl.isAnonSubtemplate) {
                st4.rawSetAttribute("i0", i05);
                st4.rawSetAttribute("i", i15);
            }
            mapped.add(st4);
            ++i05;
            ++i15;
        }
        return mapped;
    }

    protected ST.AttributeList zip_map(InstanceScope scope, List<Object> exprs, ST prototype) {
        if (exprs == null || prototype == null || exprs.size() == 0) {
            return null;
        }
        for (int i15 = 0; i15 < exprs.size(); ++i15) {
            Object attr = exprs.get(i15);
            if (attr == null) continue;
            exprs.set(i15, this.convertAnythingToIterator(scope, attr));
        }
        int numExprs = exprs.size();
        CompiledST code = prototype.impl;
        Map<String, FormalArgument> formalArguments = code.formalArguments;
        if (!code.hasFormalArgs || formalArguments == null) {
            this.errMgr.runTimeError(this, scope, ErrorType.MISSING_FORMAL_ARGUMENTS);
            return null;
        }
        String[] formalArgumentNames = formalArguments.keySet().toArray(new String[formalArguments.size()]);
        int nformalArgs = formalArgumentNames.length;
        if (prototype.isAnonSubtemplate()) {
            nformalArgs -= predefinedAnonSubtemplateAttributes.size();
        }
        if (nformalArgs != numExprs) {
            int shorterSize;
            this.errMgr.runTimeError(this, scope, ErrorType.MAP_ARGUMENT_COUNT_MISMATCH, numExprs, (Object)nformalArgs);
            numExprs = shorterSize = Math.min(formalArgumentNames.length, numExprs);
            String[] newFormalArgumentNames = new String[shorterSize];
            System.arraycopy(formalArgumentNames, 0, newFormalArgumentNames, 0, shorterSize);
            formalArgumentNames = newFormalArgumentNames;
        }
        ST.AttributeList results = new ST.AttributeList();
        int i16 = 0;
        while (true) {
            int numEmpty = 0;
            ST embedded = this.group.createStringTemplateInternally(prototype);
            embedded.rawSetAttribute("i0", i16);
            embedded.rawSetAttribute("i", i16 + 1);
            for (int a15 = 0; a15 < numExprs; ++a15) {
                Iterator it = (Iterator)exprs.get(a15);
                if (it != null && it.hasNext()) {
                    String argName = formalArgumentNames[a15];
                    Object iteratedValue = it.next();
                    embedded.rawSetAttribute(argName, iteratedValue);
                    continue;
                }
                ++numEmpty;
            }
            if (numEmpty == numExprs) break;
            results.add(embedded);
            ++i16;
        }
        return results;
    }

    protected void setFirstArgument(InstanceScope scope, ST st4, Object attr) {
        if (!st4.impl.hasFormalArgs && st4.impl.formalArguments == null) {
            st4.add("it", attr);
            return;
        }
        if (st4.impl.formalArguments == null) {
            this.errMgr.runTimeError(this, scope, ErrorType.ARGUMENT_COUNT_MISMATCH, 1, st4.impl.name, 0);
            return;
        }
        st4.locals[0] = attr;
    }

    protected void addToList(InstanceScope scope, List<Object> list2, Object o15) {
        if ((o15 = this.convertAnythingIteratableToIterator(scope, o15)) instanceof Iterator) {
            Iterator it = (Iterator)o15;
            while (it.hasNext()) {
                list2.add(it.next());
            }
        } else {
            list2.add(o15);
        }
    }

    public Object first(InstanceScope scope, Object v15) {
        Iterator it;
        if (v15 == null) {
            return null;
        }
        Object r15 = v15;
        if ((v15 = this.convertAnythingIteratableToIterator(scope, v15)) instanceof Iterator && (it = (Iterator)v15).hasNext()) {
            r15 = it.next();
        }
        return r15;
    }

    public Object last(InstanceScope scope, Object v15) {
        if (v15 == null) {
            return null;
        }
        if (v15 instanceof List) {
            return ((List)v15).get(((List)v15).size() - 1);
        }
        if (v15.getClass().isArray()) {
            return Array.get(v15, Array.getLength(v15) - 1);
        }
        Object last = v15;
        if ((v15 = this.convertAnythingIteratableToIterator(scope, v15)) instanceof Iterator) {
            Iterator it = (Iterator)v15;
            while (it.hasNext()) {
                last = it.next();
            }
        }
        return last;
    }

    public Object rest(InstanceScope scope, Object v15) {
        if (v15 == null) {
            return null;
        }
        if (v15 instanceof List) {
            List elems = (List)v15;
            if (elems.size() <= 1) {
                return null;
            }
            return elems.subList(1, elems.size());
        }
        if ((v15 = this.convertAnythingIteratableToIterator(scope, v15)) instanceof Iterator) {
            ArrayList a15 = new ArrayList();
            Iterator it = (Iterator)v15;
            if (!it.hasNext()) {
                return null;
            }
            it.next();
            while (it.hasNext()) {
                Object o15 = it.next();
                a15.add(o15);
            }
            return a15;
        }
        return null;
    }

    public Object trunc(InstanceScope scope, Object v15) {
        if (v15 == null) {
            return null;
        }
        if (v15 instanceof List) {
            List elems = (List)v15;
            if (elems.size() <= 1) {
                return null;
            }
            return elems.subList(0, elems.size() - 1);
        }
        if ((v15 = this.convertAnythingIteratableToIterator(scope, v15)) instanceof Iterator) {
            ArrayList a15 = new ArrayList();
            Iterator it = (Iterator)v15;
            while (it.hasNext()) {
                Object o15 = it.next();
                if (!it.hasNext()) continue;
                a15.add(o15);
            }
            return a15;
        }
        return null;
    }

    public Object strip(InstanceScope scope, Object v15) {
        if (v15 == null) {
            return null;
        }
        if ((v15 = this.convertAnythingIteratableToIterator(scope, v15)) instanceof Iterator) {
            ArrayList a15 = new ArrayList();
            Iterator it = (Iterator)v15;
            while (it.hasNext()) {
                Object o15 = it.next();
                if (o15 == null) continue;
                a15.add(o15);
            }
            return a15;
        }
        return v15;
    }

    public Object reverse(InstanceScope scope, Object v15) {
        if (v15 == null) {
            return null;
        }
        if ((v15 = this.convertAnythingIteratableToIterator(scope, v15)) instanceof Iterator) {
            LinkedList a15 = new LinkedList();
            Iterator it = (Iterator)v15;
            while (it.hasNext()) {
                a15.add(0, it.next());
            }
            return a15;
        }
        return v15;
    }

    public Object length(Object v15) {
        if (v15 == null) {
            return 0;
        }
        int i15 = 1;
        if (v15 instanceof Map) {
            i15 = ((Map)v15).size();
        } else if (v15 instanceof Collection) {
            i15 = ((Collection)v15).size();
        } else if (v15 instanceof Object[]) {
            i15 = ((Object[])v15).length;
        } else if (v15.getClass().isArray()) {
            i15 = Array.getLength(v15);
        } else if (v15 instanceof Iterator) {
            Iterator it = (Iterator)v15;
            i15 = 0;
            while (it.hasNext()) {
                it.next();
                ++i15;
            }
        }
        return i15;
    }

    protected String toString(STWriter out, InstanceScope scope, Object value) {
        if (value != null) {
            STWriter stw;
            if (value.getClass() == String.class) {
                return (String)value;
            }
            StringWriter sw4 = new StringWriter();
            try {
                Class<?> writerClass = out.getClass();
                Constructor<?> ctor = writerClass.getConstructor(Writer.class);
                stw = (STWriter)ctor.newInstance(sw4);
            }
            catch (Exception e15) {
                stw = new AutoIndentWriter(sw4);
                this.errMgr.runTimeError(this, scope, ErrorType.WRITER_CTOR_ISSUE, out.getClass().getSimpleName());
            }
            if (this.debug && !scope.earlyEval) {
                scope = new InstanceScope(scope, scope.st);
                scope.earlyEval = true;
            }
            this.writeObjectNoOptions(stw, scope, value);
            return sw4.toString();
        }
        return null;
    }

    public Object convertAnythingIteratableToIterator(InstanceScope scope, Object o15) {
        Iterator<Object> iter = null;
        if (o15 == null) {
            return null;
        }
        if (o15 instanceof Collection) {
            iter = ((Collection)o15).iterator();
        } else if (o15 instanceof Object[]) {
            iter = Arrays.asList((Object[])o15).iterator();
        } else if (o15.getClass().isArray()) {
            iter = new ArrayIterator(o15);
        } else if (o15 instanceof Map) {
            iter = scope.st.groupThatCreatedThisInstance.iterateAcrossValues ? ((Map)o15).values().iterator() : ((Map)o15).keySet().iterator();
        }
        if (iter == null) {
            return o15;
        }
        return iter;
    }

    public Iterator<?> convertAnythingToIterator(InstanceScope scope, Object o15) {
        if ((o15 = this.convertAnythingIteratableToIterator(scope, o15)) instanceof Iterator) {
            return (Iterator)o15;
        }
        ST.AttributeList singleton = new ST.AttributeList(1);
        singleton.add(o15);
        return singleton.iterator();
    }

    protected boolean testAttributeTrue(Object a15) {
        if (a15 == null) {
            return false;
        }
        if (a15 instanceof Boolean) {
            return (Boolean)a15;
        }
        if (a15 instanceof Collection) {
            return ((Collection)a15).size() > 0;
        }
        if (a15 instanceof Map) {
            return ((Map)a15).size() > 0;
        }
        if (a15 instanceof Iterator) {
            return ((Iterator)a15).hasNext();
        }
        return true;
    }

    protected Object getObjectProperty(STWriter out, InstanceScope scope, Object o15, Object property) {
        if (o15 == null) {
            this.errMgr.runTimeError(this, scope, ErrorType.NO_SUCH_PROPERTY, "null." + property);
            return null;
        }
        try {
            ST self = scope.st;
            ModelAdaptor adap = self.groupThatCreatedThisInstance.getModelAdaptor(o15.getClass());
            return adap.getProperty(this, self, o15, property, this.toString(out, scope, property));
        }
        catch (STNoSuchPropertyException e15) {
            this.errMgr.runTimeError(this, scope, ErrorType.NO_SUCH_PROPERTY, e15, (Object)(o15.getClass().getName() + "." + property));
            return null;
        }
    }

    public Object getAttribute(InstanceScope scope, String name) {
        InstanceScope current = scope;
        while (current != null) {
            ST p15 = current.st;
            FormalArgument localArg = null;
            if (p15.impl.formalArguments != null) {
                localArg = p15.impl.formalArguments.get(name);
            }
            if (localArg != null) {
                Object o15 = p15.locals[localArg.index];
                return o15;
            }
            current = current.parent;
        }
        ST self = scope.st;
        STGroup g15 = self.impl.nativeGroup;
        Object o16 = this.getDictionary(g15, name);
        if (o16 != null) {
            return o16;
        }
        throw new STNoSuchAttributeException(name, scope);
    }

    public Object getDictionary(STGroup g15, String name) {
        if (g15.isDictionary(name)) {
            return g15.rawGetDictionary(name);
        }
        if (g15.imports != null) {
            for (STGroup sup : g15.imports) {
                Object o15 = this.getDictionary(sup, name);
                if (o15 == null) continue;
                return o15;
            }
        }
        return null;
    }

    public void setDefaultArguments(STWriter out, InstanceScope scope) {
        ST invokedST = scope.st;
        if (invokedST.impl.formalArguments == null || invokedST.impl.numberOfArgsWithDefaultValues == 0) {
            return;
        }
        for (FormalArgument arg : invokedST.impl.formalArguments.values()) {
            if (invokedST.locals[arg.index] != ST.EMPTY_ATTR || arg.defaultValueToken == null) continue;
            if (arg.defaultValueToken.getType() == 4) {
                CompiledST code = arg.compiledDefaultValue;
                if (code == null) {
                    code = new CompiledST();
                }
                ST defaultArgST = this.group.createStringTemplateInternally(code);
                defaultArgST.groupThatCreatedThisInstance = this.group;
                String defArgTemplate = arg.defaultValueToken.getText();
                if (defArgTemplate.startsWith("{" + this.group.delimiterStartChar + "(") && defArgTemplate.endsWith(")" + this.group.delimiterStopChar + "}")) {
                    invokedST.rawSetAttribute(arg.name, this.toString(out, new InstanceScope(scope, invokedST), defaultArgST));
                    continue;
                }
                invokedST.rawSetAttribute(arg.name, defaultArgST);
                continue;
            }
            invokedST.rawSetAttribute(arg.name, arg.defaultValue);
        }
    }

    public static String getEnclosingInstanceStackString(InstanceScope scope) {
        List<ST> templates = Interpreter.getEnclosingInstanceStack(scope, true);
        StringBuilder buf = new StringBuilder();
        int i15 = 0;
        for (ST st4 : templates) {
            if (i15 > 0) {
                buf.append(" ");
            }
            buf.append(st4.getName());
            ++i15;
        }
        return buf.toString();
    }

    public static List<ST> getEnclosingInstanceStack(InstanceScope scope, boolean topdown) {
        LinkedList<ST> stack = new LinkedList<ST>();
        InstanceScope p15 = scope;
        while (p15 != null) {
            if (topdown) {
                stack.add(0, p15.st);
            } else {
                stack.add(p15.st);
            }
            p15 = p15.parent;
        }
        return stack;
    }

    public static List<InstanceScope> getScopeStack(InstanceScope scope, boolean topdown) {
        LinkedList<InstanceScope> stack = new LinkedList<InstanceScope>();
        InstanceScope p15 = scope;
        while (p15 != null) {
            if (topdown) {
                stack.add(0, p15);
            } else {
                stack.add(p15);
            }
            p15 = p15.parent;
        }
        return stack;
    }

    public static List<EvalTemplateEvent> getEvalTemplateEventStack(InstanceScope scope, boolean topdown) {
        LinkedList<EvalTemplateEvent> stack = new LinkedList<EvalTemplateEvent>();
        InstanceScope p15 = scope;
        while (p15 != null) {
            EvalTemplateEvent eval = (EvalTemplateEvent)p15.events.get(p15.events.size() - 1);
            if (topdown) {
                stack.add(0, eval);
            } else {
                stack.add(eval);
            }
            p15 = p15.parent;
        }
        return stack;
    }

    protected void trace(InstanceScope scope, int ip4) {
        ST self = scope.st;
        StringBuilder tr4 = new StringBuilder();
        BytecodeDisassembler dis = new BytecodeDisassembler(self.impl);
        StringBuilder buf = new StringBuilder();
        dis.disassembleInstruction(buf, ip4);
        String name = self.impl.name + ":";
        if (Misc.referenceEquals(self.impl.name, "anonymous")) {
            name = "";
        }
        tr4.append(String.format("%-40s", name + buf));
        tr4.append("\tstack=[");
        for (int i15 = 0; i15 <= this.sp; ++i15) {
            Object o15 = this.operands[i15];
            this.printForTrace(tr4, scope, o15);
        }
        tr4.append(" ], calls=");
        tr4.append(Interpreter.getEnclosingInstanceStackString(scope));
        tr4.append(", sp=" + this.sp + ", nw=" + this.nwline);
        String s15 = tr4.toString();
        if (this.debug) {
            this.executeTrace.add(s15);
        }
        if (trace) {
            System.out.println(s15);
        }
    }

    protected void printForTrace(StringBuilder tr4, InstanceScope scope, Object o15) {
        if (o15 instanceof ST) {
            if (((ST)o15).impl == null) {
                tr4.append("bad-template()");
            } else {
                tr4.append(" " + ((ST)o15).impl.name + "()");
            }
            return;
        }
        if ((o15 = this.convertAnythingIteratableToIterator(scope, o15)) instanceof Iterator) {
            Iterator it = (Iterator)o15;
            tr4.append(" [");
            while (it.hasNext()) {
                Object iterValue = it.next();
                this.printForTrace(tr4, scope, iterValue);
            }
            tr4.append(" ]");
        } else {
            tr4.append(" " + o15);
        }
    }

    public List<InterpEvent> getEvents() {
        return this.events;
    }

    protected void trackDebugEvent(InstanceScope scope, InterpEvent e15) {
        InstanceScope parent;
        this.events.add(e15);
        scope.events.add(e15);
        if (e15 instanceof EvalTemplateEvent && (parent = scope.parent) != null) {
            scope.parent.childEvalTemplateEvents.add((EvalTemplateEvent)e15);
        }
    }

    public List<String> getExecutionTrace() {
        return this.executeTrace;
    }

    public static int getShort(byte[] memory, int index) {
        int b15 = memory[index] & 0xFF;
        int b25 = memory[index + 1] & 0xFF;
        return b15 << 8 | b25;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ArgumentsMap
    extends HashMap<String, Object> {
        protected ArgumentsMap() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ObjectList
    extends ArrayList<Object> {
        protected ObjectList() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        ANCHOR,
        FORMAT,
        NULL,
        SEPARATOR,
        WRAP;

    }
}

