/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.Utilities;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.CaretStyle;
import org.fife.ui.rtextarea.ChangeableHighlightPainter;
import org.fife.ui.rtextarea.RTextArea;

public class ConfigurableCaret
extends DefaultCaret {
    private transient Segment seg = new Segment();
    private CaretStyle style;
    private ChangeableHighlightPainter selectionPainter;
    private boolean alwaysVisible;
    private boolean pasteOnMiddleMouseClick;
    private int selectionStart;
    private int selectionEnd;
    private SelectionType selectionType;

    public ConfigurableCaret() {
        this(CaretStyle.THICK_VERTICAL_LINE_STYLE);
    }

    public ConfigurableCaret(CaretStyle style) {
        this.setStyle(style);
        this.selectionPainter = new ChangeableHighlightPainter();
        this.pasteOnMiddleMouseClick = true;
    }

    private void adjustCaret(MouseEvent e15) {
        if ((e15.getModifiers() & 1) != 0 && this.getDot() != -1) {
            this.moveCaret(e15);
        } else {
            this.positionCaret(e15);
        }
    }

    private void adjustFocus(boolean inWindow) {
        RTextArea textArea = this.getTextArea();
        if (textArea != null && textArea.isEnabled() && textArea.isRequestFocusEnabled()) {
            if (inWindow) {
                textArea.requestFocusInWindow();
            } else {
                textArea.requestFocus();
            }
        }
    }

    @Override
    protected synchronized void damage(Rectangle r15) {
        if (r15 != null) {
            this.validateWidth(r15);
            this.x = r15.x - 1;
            this.y = r15.y;
            this.width = r15.width + 4;
            this.height = r15.height;
            this.repaint();
        }
    }

    @Override
    public void deinstall(JTextComponent c15) {
        if (!(c15 instanceof RTextArea)) {
            throw new IllegalArgumentException("c must be instance of RTextArea");
        }
        super.deinstall(c15);
        c15.setNavigationFilter(null);
    }

    public boolean getPasteOnMiddleMouseClick() {
        return this.pasteOnMiddleMouseClick;
    }

    protected RTextArea getTextArea() {
        return (RTextArea)this.getComponent();
    }

    public boolean getRoundedSelectionEdges() {
        return ((ChangeableHighlightPainter)this.getSelectionPainter()).getRoundedEdges();
    }

    @Override
    protected Highlighter.HighlightPainter getSelectionPainter() {
        return this.selectionPainter;
    }

    public CaretStyle getStyle() {
        return this.style;
    }

    @Override
    public void install(JTextComponent c15) {
        if (!(c15 instanceof RTextArea)) {
            throw new IllegalArgumentException("c must be instance of RTextArea");
        }
        super.install(c15);
        c15.setNavigationFilter(new FoldAwareNavigationFilter());
    }

    public boolean isAlwaysVisible() {
        return this.alwaysVisible;
    }

    @Override
    public void mouseClicked(MouseEvent e15) {
        if (!e15.isConsumed()) {
            RTextArea textArea = this.getTextArea();
            int clickCount = e15.getClickCount();
            if (SwingUtilities.isMiddleMouseButton(e15) && this.getPasteOnMiddleMouseClick() && clickCount == 1 && textArea.isEditable() && textArea.isEnabled()) {
                JTextComponent c15 = (JTextComponent)e15.getSource();
                try {
                    Toolkit tk4 = c15.getToolkit();
                    Clipboard buffer = tk4.getSystemSelection();
                    if (buffer != null) {
                        Transferable trans;
                        this.adjustCaret(e15);
                        TransferHandler th4 = c15.getTransferHandler();
                        if (th4 != null && (trans = buffer.getContents(null)) != null) {
                            th4.importData(c15, trans);
                        }
                        this.adjustFocus(true);
                    } else {
                        textArea.paste();
                    }
                }
                catch (HeadlessException headlessException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e15) {
        block7: {
            if (!e15.isConsumed() && SwingUtilities.isLeftMouseButton(e15) && (SelectionType.WORD == this.selectionType || SelectionType.LINE == this.selectionType)) {
                JTextComponent tc5 = this.getComponent();
                int offs = tc5.viewToModel(e15.getPoint());
                if (offs < 0) {
                    return;
                }
                boolean wordSelection = SelectionType.WORD == this.selectionType;
                try {
                    if (offs > this.selectionEnd) {
                        int endOffs = wordSelection ? Utilities.getWordEnd(tc5, offs) : Utilities.getRowEnd(tc5, offs);
                        this.select(this.selectionStart, endOffs);
                        break block7;
                    }
                    if (offs < this.selectionStart) {
                        int endOffs = wordSelection ? Utilities.getWordStart(tc5, offs) : Utilities.getRowStart(tc5, offs);
                        this.select(this.selectionEnd, endOffs);
                        break block7;
                    }
                    this.select(this.selectionStart, this.selectionEnd);
                }
                catch (BadLocationException ble) {
                    UIManager.getLookAndFeel().provideErrorFeedback(tc5);
                }
            } else {
                super.mouseDragged(e15);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e15) {
        JTextComponent c15;
        super.mousePressed(e15);
        if (SwingUtilities.isLeftMouseButton(e15)) {
            switch (e15.getClickCount()) {
                case 1: {
                    this.selectionType = SelectionType.CHAR;
                    break;
                }
                case 2: {
                    if (e15.isConsumed()) break;
                    this.selectionType = SelectionType.WORD;
                    break;
                }
                default: {
                    if (e15.isConsumed() && !this.getComponent().getDragEnabled()) break;
                    this.selectionType = SelectionType.LINE;
                }
            }
            if (SelectionType.LINE == this.selectionType) {
                JTextComponent tc5 = this.getComponent();
                Action a15 = tc5.getActionMap().get("select-line");
                a15.actionPerformed(new ActionEvent(tc5, 1001, null, e15.getWhen(), e15.getModifiers()));
            }
            if (SelectionType.WORD == this.selectionType || SelectionType.LINE == this.selectionType) {
                int dot = this.getDot();
                int mark = this.getMark();
                this.selectionStart = Math.min(dot, mark);
                this.selectionEnd = Math.max(dot, mark);
            }
        } else if (SwingUtilities.isRightMouseButton(e15) && !e15.isConsumed() && (c15 = this.getComponent()) != null && c15.isEnabled() && c15.isRequestFocusEnabled()) {
            c15.requestFocusInWindow();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e15) {
        this.selectionType = null;
        super.mouseReleased(e15);
    }

    @Override
    public void paint(Graphics g15) {
        if (this.isVisible() || this.alwaysVisible) {
            try {
                RTextArea textArea = this.getTextArea();
                g15.setColor(textArea.getCaretColor());
                TextUI mapper = textArea.getUI();
                Rectangle r15 = mapper.modelToView(textArea, this.getDot());
                this.validateWidth(r15);
                if (this.width > 0 && this.height > 0 && !this.contains(r15.x, r15.y, r15.width, r15.height)) {
                    Rectangle clip = g15.getClipBounds();
                    if (clip != null && !clip.contains(this)) {
                        this.repaint();
                    }
                    this.damage(r15);
                }
                r15.height -= 2;
                switch (this.style) {
                    case BLOCK_STYLE: {
                        Color textAreaBg = textArea.getBackground();
                        if (textAreaBg == null) {
                            textAreaBg = Color.white;
                        }
                        g15.setXORMode(textAreaBg);
                        g15.fillRect(r15.x, r15.y, r15.width, r15.height);
                        break;
                    }
                    case BLOCK_BORDER_STYLE: {
                        g15.drawRect(r15.x, r15.y, r15.width - 1, r15.height);
                        break;
                    }
                    case UNDERLINE_STYLE: {
                        Color textAreaBg = textArea.getBackground();
                        if (textAreaBg == null) {
                            textAreaBg = Color.white;
                        }
                        g15.setXORMode(textAreaBg);
                        int y15 = r15.y + r15.height;
                        g15.drawLine(r15.x, y15, r15.x + r15.width - 1, y15);
                        break;
                    }
                    default: {
                        int lineY = r15.y + 1;
                        g15.drawLine(r15.x, lineY, r15.x, lineY + r15.height);
                        break;
                    }
                    case THICK_VERTICAL_LINE_STYLE: {
                        int lineY = r15.y + 1;
                        g15.drawLine(r15.x, lineY, r15.x, lineY + r15.height);
                        ++r15.x;
                        g15.drawLine(r15.x, lineY, r15.x, lineY + r15.height);
                        break;
                    }
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
    }

    private void select(int mark, int dot) {
        if (mark != this.getMark()) {
            this.setDot(mark);
        }
        if (dot != this.getDot()) {
            this.moveDot(dot);
        }
    }

    public void setAlwaysVisible(boolean alwaysVisible) {
        if (alwaysVisible != this.alwaysVisible) {
            this.alwaysVisible = alwaysVisible;
            if (!this.isVisible()) {
                this.repaint();
            }
        }
    }

    public void setPasteOnMiddleMouseClick(boolean paste) {
        this.pasteOnMiddleMouseClick = paste;
    }

    public void setRoundedSelectionEdges(boolean rounded) {
        ((ChangeableHighlightPainter)this.getSelectionPainter()).setRoundedEdges(rounded);
    }

    @Override
    public void setSelectionVisible(boolean visible) {
        super.setSelectionVisible(true);
    }

    public void setStyle(CaretStyle style) {
        if (style == null) {
            style = CaretStyle.THICK_VERTICAL_LINE_STYLE;
        }
        if (style != this.style) {
            this.style = style;
            this.repaint();
        }
    }

    private void validateWidth(Rectangle rect) {
        if (rect != null && rect.width <= 1) {
            try {
                RTextArea textArea = this.getTextArea();
                textArea.getDocument().getText(this.getDot(), 1, this.seg);
                Font font = textArea.getFont();
                FontMetrics fm4 = textArea.getFontMetrics(font);
                rect.width = fm4.charWidth(this.seg.array[this.seg.offset]);
                if (rect.width == 0) {
                    rect.width = fm4.charWidth(' ');
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                rect.width = 8;
            }
        }
    }

    private final class FoldAwareNavigationFilter
    extends NavigationFilter {
        private FoldAwareNavigationFilter() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setDot(NavigationFilter.FilterBypass fb5, int dot, Position.Bias bias) {
            block11: {
                RSyntaxTextArea rsta;
                RTextArea textArea = ConfigurableCaret.this.getTextArea();
                if (textArea instanceof RSyntaxTextArea && (rsta = (RSyntaxTextArea)ConfigurableCaret.this.getTextArea()).isCodeFoldingEnabled()) {
                    int lastDot = ConfigurableCaret.this.getDot();
                    FoldManager fm4 = rsta.getFoldManager();
                    int line = 0;
                    try {
                        line = textArea.getLineOfOffset(dot);
                    }
                    catch (Exception e15) {
                        e15.printStackTrace();
                    }
                    if (fm4.isLineHidden(line)) {
                        try {
                            if (dot > lastDot) {
                                int lineCount = textArea.getLineCount();
                                while (++line < lineCount && fm4.isLineHidden(line)) {
                                }
                                if (line >= lineCount) {
                                    UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                                    return;
                                }
                                dot = textArea.getLineStartOffset(line);
                                break block11;
                            }
                            if (dot >= lastDot) break block11;
                            while (--line >= 0 && fm4.isLineHidden(line)) {
                            }
                            if (line >= 0) {
                                dot = textArea.getLineEndOffset(line) - 1;
                            }
                        }
                        catch (Exception e16) {
                            e16.printStackTrace();
                            return;
                        }
                    }
                }
            }
            super.setDot(fb5, dot, bias);
        }

        @Override
        public void moveDot(NavigationFilter.FilterBypass fb5, int dot, Position.Bias bias) {
            super.moveDot(fb5, dot, bias);
        }
    }

    public static enum SelectionType {
        CHAR,
        WORD,
        LINE;

    }
}

