/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import javax.swing.text.TabExpander;
import org.fife.ui.rsyntaxtextarea.HtmlUtil;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;

public final class TokenUtils {
    private TokenUtils() {
    }

    public static TokenSubList getSubTokenList(Token tokenList, int pos, TabExpander e15, RSyntaxTextArea textArea, float x05) {
        return TokenUtils.getSubTokenList(tokenList, pos, e15, textArea, x05, null);
    }

    public static TokenSubList getSubTokenList(Token tokenList, int pos, TabExpander e15, RSyntaxTextArea textArea, float x05, TokenImpl tempToken) {
        Token t15;
        if (tempToken == null) {
            tempToken = new TokenImpl();
        }
        for (t15 = tokenList; t15 != null && t15.isPaintable() && !t15.containsPosition(pos); t15 = t15.getNextToken()) {
            x05 += t15.getWidth(textArea, e15, x05);
        }
        if (t15 != null && t15.isPaintable()) {
            if (t15.getOffset() != pos) {
                int difference = pos - t15.getOffset();
                x05 += t15.getWidthUpTo(t15.length() - difference + 1, textArea, e15, x05);
                tempToken.copyFrom(t15);
                tempToken.makeStartAt(pos);
                return new TokenSubList(tempToken, x05);
            }
            return new TokenSubList(t15, x05);
        }
        return new TokenSubList(tokenList, x05);
    }

    public static int getWhiteSpaceTokenLength(Token t15, int tabSize, int curOffs) {
        int length = 0;
        for (int i15 = 0; i15 < t15.length(); ++i15) {
            char ch4 = t15.charAt(i15);
            if (ch4 == '\t') {
                int newCurOffs = (curOffs + tabSize) / tabSize * tabSize;
                length += newCurOffs - curOffs;
                curOffs = newCurOffs;
                continue;
            }
            ++length;
            ++curOffs;
        }
        return length;
    }

    public static boolean isBlankOrAllWhiteSpace(Token t15) {
        while (t15 != null && t15.isPaintable()) {
            if (!t15.isCommentOrWhitespace()) {
                return false;
            }
            t15 = t15.getNextToken();
        }
        return true;
    }

    public static boolean isBlankOrAllWhiteSpaceWithoutComments(Token t15) {
        while (t15 != null && t15.isPaintable()) {
            if (!t15.isWhitespace()) {
                return false;
            }
            t15 = t15.getNextToken();
        }
        return true;
    }

    public static String tokenToHtml(RSyntaxTextArea textArea, Token token) {
        StringBuilder style = new StringBuilder();
        Font font = textArea.getFontForToken(token);
        if (font.isBold()) {
            style.append("font-weight: bold;");
        }
        if (font.isItalic()) {
            style.append("font-style: italic;");
        }
        Color c15 = textArea.getForegroundForToken(token);
        style.append("color: ").append(HtmlUtil.getHexString(c15)).append(";");
        return "<span style=\"" + style + "\">" + HtmlUtil.escapeForHtml(token.getLexeme(), "\n", true) + "</span>";
    }

    public static class TokenSubList {
        public Token tokenList;
        public float x;

        public TokenSubList(Token tokenList, float x15) {
            this.tokenList = tokenList;
            this.x = x15;
        }
    }
}

