/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;
import org.fife.ui.rsyntaxtextarea.TokenOrientedView;
import org.fife.ui.rsyntaxtextarea.TokenUtils;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public final class RSyntaxUtilities
implements SwingConstants {
    public static final int OS_WINDOWS = 1;
    public static final int OS_MAC_OSX = 2;
    public static final int OS_LINUX = 4;
    public static final int OS_OTHER = 8;
    private static final Color LIGHT_HYPERLINK_FG = new Color(0xD8FFFF);
    private static final int OS = RSyntaxUtilities.getOSImpl();
    private static final int LETTER_MASK = 2;
    private static final int HEX_CHARACTER_MASK = 16;
    private static final int LETTER_OR_DIGIT_MASK = 32;
    private static final int BRACKET_MASK = 64;
    private static final int JAVA_OPERATOR_MASK = 128;
    private static final int[] DATA_TABLE = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 128, 0, 0, 0, 128, 128, 0, 64, 64, 128, 128, 0, 128, 0, 128, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 128, 0, 128, 128, 128, 128, 0, 58, 58, 58, 58, 58, 58, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 64, 0, 64, 128, 0, 0, 50, 50, 50, 50, 50, 50, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 64, 128, 64, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static Segment charSegment = new Segment();
    private static final TokenImpl TEMP_TOKEN = new TokenImpl();
    private static final char[] JS_KEYWORD_RETURN = new char[]{'r', 'e', 't', 'u', 'r', 'n'};
    private static final char[] JS_AND = new char[]{'&', '&'};
    private static final char[] JS_OR = new char[]{'|', '|'};
    private static final String BRACKETS = "{([})]";

    private RSyntaxUtilities() {
    }

    public static Map<?, ?> getBestPossibleAntiAliasHints() {
        Map<?, ?> hints = RSyntaxUtilities.getDesktopAntiAliasHints();
        if (hints == null) {
            HashMap temp = new HashMap();
            temp.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            hints = temp;
        }
        return hints;
    }

    public static Map<?, ?> getDesktopAntiAliasHints() {
        return (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
    }

    public static Color getFoldedLineBottomColor(RSyntaxTextArea textArea) {
        Color color = Color.GRAY;
        Gutter gutter = RSyntaxUtilities.getGutter(textArea);
        if (gutter != null) {
            color = gutter.getFoldIndicatorForeground();
        }
        return color;
    }

    public static Gutter getGutter(RTextArea textArea) {
        Gutter gutter = null;
        Container parent = textArea.getParent();
        if (parent instanceof JViewport && (parent = parent.getParent()) instanceof RTextScrollPane) {
            RTextScrollPane sp4 = (RTextScrollPane)parent;
            gutter = sp4.getGutter();
        }
        return gutter;
    }

    public static Color getHyperlinkForeground() {
        Color fg5 = UIManager.getColor("Label.foreground");
        if (fg5 == null) {
            fg5 = new JLabel().getForeground();
        }
        return RSyntaxUtilities.isLightForeground(fg5) ? LIGHT_HYPERLINK_FG : Color.blue;
    }

    public static String getLeadingWhitespace(String text) {
        return RSyntaxUtilities.getLeadingWhitespace(text, Integer.MAX_VALUE);
    }

    public static String getLeadingWhitespace(String text, int upTo) {
        int count;
        int len = Math.min(text.length(), upTo);
        for (count = 0; count < len && RSyntaxUtilities.isWhitespace(text.charAt(count)); ++count) {
        }
        return text.substring(0, count);
    }

    public static String getLeadingWhitespace(Document doc, int offs) throws BadLocationException {
        Element root = doc.getDefaultRootElement();
        int line = root.getElementIndex(offs);
        Element elem = root.getElement(line);
        int startOffs = elem.getStartOffset();
        int endOffs = elem.getEndOffset() - 1;
        String text = doc.getText(startOffs, endOffs - startOffs);
        return RSyntaxUtilities.getLeadingWhitespace(text);
    }

    private static Element getLineElem(Document doc, int offs) {
        int line;
        Element root = doc.getDefaultRootElement();
        Element elem = root.getElement(line = root.getElementIndex(offs));
        if (offs >= elem.getStartOffset() && offs < elem.getEndOffset()) {
            return elem;
        }
        return null;
    }

    public static Rectangle getLineWidthUpTo(RSyntaxTextArea textArea, Segment s15, int p05, int p15, TabExpander e15, Rectangle rect, int x05) throws BadLocationException {
        RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
        if (p05 < 0) {
            throw new BadLocationException("Invalid document position", p05);
        }
        if (p15 > doc.getLength()) {
            throw new BadLocationException("Invalid document position", p15);
        }
        Element map = doc.getDefaultRootElement();
        int lineNum = map.getElementIndex(p05);
        if (Math.abs(lineNum - map.getElementIndex(p15)) > 1) {
            throw new IllegalArgumentException("p0 and p1 are not on the same line (" + p05 + ", " + p15 + ").");
        }
        Token t15 = doc.getTokenListForLine(lineNum);
        TokenUtils.TokenSubList subList = TokenUtils.getSubTokenList(t15, p05, e15, textArea, 0.0f, TEMP_TOKEN);
        t15 = subList.tokenList;
        rect = t15.listOffsetToView(textArea, e15, p15, x05, rect);
        return rect;
    }

    public static Point getMatchingBracketPosition(RSyntaxTextArea textArea, Point input) {
        if (input == null) {
            input = new Point();
        }
        input.setLocation(-1, -1);
        try {
            char bracketMatch;
            boolean goForward;
            int index;
            int caretPosition = textArea.getCaretPosition() - 1;
            RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
            char bracket = '\u0000';
            if (caretPosition >= 0) {
                bracket = doc.charAt(caretPosition);
            }
            if ((index = BRACKETS.indexOf(bracket)) == -1 && caretPosition < doc.getLength() - 1) {
                bracket = doc.charAt(++caretPosition);
            }
            if (index == -1 && (index = BRACKETS.indexOf(bracket)) == -1) {
                return input;
            }
            Element map = doc.getDefaultRootElement();
            int curLine = map.getElementIndex(caretPosition);
            Element line = map.getElement(curLine);
            int start = line.getStartOffset();
            int end = line.getEndOffset();
            Token token = doc.getTokenListForLine(curLine);
            if ((token = RSyntaxUtilities.getTokenAtOffset(token, caretPosition)).getType() != 22) {
                return input;
            }
            int languageIndex = token.getLanguageIndex();
            if (index < 3) {
                goForward = true;
                bracketMatch = BRACKETS.charAt(index + 3);
            } else {
                goForward = false;
                bracketMatch = BRACKETS.charAt(index - 3);
            }
            if (goForward) {
                int lastLine = map.getElementCount();
                start = caretPosition + 1;
                int numEmbedded = 0;
                boolean haveTokenList = false;
                while (true) {
                    int segOffset;
                    doc.getText(start, end - start, charSegment);
                    for (int i15 = segOffset = RSyntaxUtilities.charSegment.offset; i15 < segOffset + RSyntaxUtilities.charSegment.count; ++i15) {
                        int offset;
                        char ch4 = RSyntaxUtilities.charSegment.array[i15];
                        if (ch4 == bracket) {
                            if (!haveTokenList) {
                                token = doc.getTokenListForLine(curLine);
                                haveTokenList = true;
                            }
                            if ((token = RSyntaxUtilities.getTokenAtOffset(token, offset = start + (i15 - segOffset))).getType() != 22 || token.getLanguageIndex() != languageIndex) continue;
                            ++numEmbedded;
                            continue;
                        }
                        if (ch4 != bracketMatch) continue;
                        if (!haveTokenList) {
                            token = doc.getTokenListForLine(curLine);
                            haveTokenList = true;
                        }
                        if ((token = RSyntaxUtilities.getTokenAtOffset(token, offset = start + (i15 - segOffset))).getType() != 22 || token.getLanguageIndex() != languageIndex) continue;
                        if (numEmbedded == 0) {
                            if (textArea.isCodeFoldingEnabled() && textArea.getFoldManager().isLineHidden(curLine)) {
                                return input;
                            }
                            input.setLocation(caretPosition, offset);
                            return input;
                        }
                        --numEmbedded;
                    }
                    if (++curLine == lastLine) {
                        return input;
                    }
                    haveTokenList = false;
                    line = map.getElement(curLine);
                    start = line.getStartOffset();
                    end = line.getEndOffset();
                }
            }
            end = caretPosition;
            int numEmbedded = 0;
            boolean haveTokenList = false;
            while (true) {
                int iStart;
                doc.getText(start, end - start, charSegment);
                int segOffset = RSyntaxUtilities.charSegment.offset;
                for (int i16 = iStart = segOffset + RSyntaxUtilities.charSegment.count - 1; i16 >= segOffset; --i16) {
                    int offset;
                    Token t25;
                    char ch5 = RSyntaxUtilities.charSegment.array[i16];
                    if (ch5 == bracket) {
                        if (!haveTokenList) {
                            token = doc.getTokenListForLine(curLine);
                            haveTokenList = true;
                        }
                        if ((t25 = RSyntaxUtilities.getTokenAtOffset(token, offset = start + (i16 - segOffset))).getType() != 22 || token.getLanguageIndex() != languageIndex) continue;
                        ++numEmbedded;
                        continue;
                    }
                    if (ch5 != bracketMatch) continue;
                    if (!haveTokenList) {
                        token = doc.getTokenListForLine(curLine);
                        haveTokenList = true;
                    }
                    if ((t25 = RSyntaxUtilities.getTokenAtOffset(token, offset = start + (i16 - segOffset))).getType() != 22 || token.getLanguageIndex() != languageIndex) continue;
                    if (numEmbedded == 0) {
                        input.setLocation(caretPosition, offset);
                        return input;
                    }
                    --numEmbedded;
                }
                if (--curLine == -1) {
                    return input;
                }
                haveTokenList = false;
                line = map.getElement(curLine);
                start = line.getStartOffset();
                end = line.getEndOffset();
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            return input;
        }
    }

    public static Token getNextImportantToken(Token t15, RSyntaxTextArea textArea, int line) {
        while (t15 != null && t15.isPaintable() && t15.isCommentOrWhitespace()) {
            t15 = t15.getNextToken();
        }
        if (!(t15 != null && t15.isPaintable() || line >= textArea.getLineCount() - 1)) {
            t15 = textArea.getTokenListForLine(++line);
            return RSyntaxUtilities.getNextImportantToken(t15, textArea, line);
        }
        return t15;
    }

    public static int getNextVisualPositionFrom(int pos, Position.Bias b15, Shape a15, int direction, Position.Bias[] biasRet, View view) throws BadLocationException {
        RSyntaxTextArea target = (RSyntaxTextArea)view.getContainer();
        biasRet[0] = Position.Bias.Forward;
        switch (direction) {
            case 1: 
            case 5: {
                Rectangle loc;
                if (pos == -1) {
                    pos = direction == 1 ? Math.max(0, view.getEndOffset() - 1) : view.getStartOffset();
                    break;
                }
                Caret c15 = target != null ? target.getCaret() : null;
                Point mcp = c15 != null ? c15.getMagicCaretPosition() : null;
                int x15 = mcp == null ? ((loc = target.modelToView(pos)) == null ? 0 : loc.x) : mcp.x;
                if (direction == 1) {
                    pos = RSyntaxUtilities.getPositionAbove(target, pos, x15, (TabExpander)((Object)view));
                    break;
                }
                pos = RSyntaxUtilities.getPositionBelow(target, pos, x15, (TabExpander)((Object)view));
                break;
            }
            case 7: {
                FoldManager fm4;
                int current;
                int last;
                int endOffs = view.getEndOffset();
                if (pos == -1) {
                    pos = Math.max(0, endOffs - 1);
                    break;
                }
                pos = Math.max(0, pos - 1);
                if (!target.isCodeFoldingEnabled() || (last = pos == endOffs - 1 ? target.getLineCount() - 1 : target.getLineOfOffset(pos + 1)) == (current = target.getLineOfOffset(pos)) || !(fm4 = target.getFoldManager()).isLineHidden(current)) break;
                while (--current > 0 && fm4.isLineHidden(current)) {
                }
                pos = target.getLineEndOffset(current) - 1;
                break;
            }
            case 3: {
                FoldManager fm5;
                int current;
                int last;
                if (pos == -1) {
                    pos = view.getStartOffset();
                    break;
                }
                pos = Math.min(pos + 1, view.getDocument().getLength());
                if (!target.isCodeFoldingEnabled() || (last = pos == 0 ? 0 : target.getLineOfOffset(pos - 1)) == (current = target.getLineOfOffset(pos)) || !(fm5 = target.getFoldManager()).isLineHidden(current)) break;
                int lineCount = target.getLineCount();
                while (++current < lineCount && fm5.isLineHidden(current)) {
                }
                pos = current == lineCount ? target.getLineEndOffset(last) - 1 : target.getLineStartOffset(current);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + direction);
            }
        }
        return pos;
    }

    public static int getOS() {
        return OS;
    }

    private static int getOSImpl() {
        int os4 = 8;
        String osName = System.getProperty("os.name");
        if (osName != null) {
            os4 = (osName = osName.toLowerCase()).contains("windows") ? 1 : (osName.contains("mac os x") ? 2 : (osName.contains("linux") ? 4 : 8));
        }
        return os4;
    }

    public static int getPatternFlags(boolean matchCase, int others) {
        if (!matchCase) {
            others |= 0x42;
        }
        return others;
    }

    public static int getPositionAbove(RSyntaxTextArea c15, int offs, float x15, TabExpander e15) throws BadLocationException {
        TokenOrientedView tov = (TokenOrientedView)((Object)e15);
        Token token = tov.getTokenListForPhysicalLineAbove(offs);
        if (token == null) {
            return 0;
        }
        if (token.getType() == 0) {
            int line = c15.getLineOfOffset(offs);
            return c15.getLineStartOffset(line - 1);
        }
        return token.getListOffset(c15, e15, c15.getMargin().left, x15);
    }

    public static int getPositionBelow(RSyntaxTextArea c15, int offs, float x15, TabExpander e15) throws BadLocationException {
        TokenOrientedView tov = (TokenOrientedView)((Object)e15);
        Token token = tov.getTokenListForPhysicalLineBelow(offs);
        if (token == null) {
            return c15.getDocument().getLength();
        }
        if (token.getType() == 0) {
            int line = c15.getLineOfOffset(offs);
            FoldManager fm4 = c15.getFoldManager();
            line = fm4.getVisibleLineBelow(line);
            return c15.getLineStartOffset(line);
        }
        return token.getListOffset(c15, e15, c15.getMargin().left, x15);
    }

    public static Token getPreviousImportantToken(RSyntaxDocument doc, int line) {
        if (line < 0) {
            return null;
        }
        Token t15 = doc.getTokenListForLine(line);
        if (t15 != null && (t15 = t15.getLastNonCommentNonWhitespaceToken()) != null) {
            return t15;
        }
        return RSyntaxUtilities.getPreviousImportantToken(doc, line - 1);
    }

    public static Token getPreviousImportantTokenFromOffs(RSyntaxDocument doc, int offs) {
        Element root = doc.getDefaultRootElement();
        int line = root.getElementIndex(offs);
        Token target = null;
        for (Token t15 = doc.getTokenListForLine(line); t15 != null && t15.isPaintable() && !t15.containsPosition(offs); t15 = t15.getNextToken()) {
            if (t15.isCommentOrWhitespace()) continue;
            target = t15;
        }
        if (target == null) {
            target = RSyntaxUtilities.getPreviousImportantToken(doc, line - 1);
        }
        return target;
    }

    public static Token getTokenAtOffset(RSyntaxTextArea textArea, int offset) {
        RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
        return RSyntaxUtilities.getTokenAtOffset(doc, offset);
    }

    public static Token getTokenAtOffsetOrLastTokenIfEndOfLine(RSyntaxTextArea textArea, int offset) {
        RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
        return RSyntaxUtilities.getTokenAtOffsetOrLastTokenIfEndOfLine(doc, offset);
    }

    public static Token getTokenAtOffset(RSyntaxDocument doc, int offset) {
        Element root = doc.getDefaultRootElement();
        int lineIndex = root.getElementIndex(offset);
        Token t15 = doc.getTokenListForLine(lineIndex);
        return RSyntaxUtilities.getTokenAtOffset(t15, offset);
    }

    public static Token getTokenAtOffsetOrLastTokenIfEndOfLine(RSyntaxDocument doc, int offset) {
        Element root = doc.getDefaultRootElement();
        int lineIndex = root.getElementIndex(offset);
        Token t15 = doc.getTokenListForLine(lineIndex);
        return RSyntaxUtilities.getTokenAtOffsetOrLastTokenIfEndOfLine(t15, offset);
    }

    public static Token getTokenAtOffset(Token tokenList, int offset) {
        for (Token t15 = tokenList; t15 != null && t15.isPaintable(); t15 = t15.getNextToken()) {
            if (!t15.containsPosition(offset)) continue;
            return t15;
        }
        return null;
    }

    public static Token getTokenAtOffsetOrLastTokenIfEndOfLine(Token tokenList, int offset) {
        for (Token t15 = tokenList; t15 != null && t15.isPaintable(); t15 = t15.getNextToken()) {
            if (!t15.containsPosition(offset) && (offset != t15.getEndOffset() || t15.getNextToken() != null && t15.getNextToken().isPaintable())) continue;
            return t15;
        }
        return null;
    }

    public static int getWordEnd(RSyntaxTextArea textArea, int offs) throws BadLocationException {
        Document doc = textArea.getDocument();
        int endOffs = textArea.getLineEndOffsetOfCurrentLine();
        int lineEnd = Math.min(endOffs, doc.getLength());
        if (offs == lineEnd) {
            return offs;
        }
        String s15 = doc.getText(offs, lineEnd - offs - 1);
        if (s15 != null && !s15.isEmpty()) {
            int i15 = 0;
            int count = s15.length();
            char ch4 = s15.charAt(i15);
            if (Character.isWhitespace(ch4)) {
                while (i15 < count && Character.isWhitespace(s15.charAt(i15++))) {
                }
            } else if (Character.isLetterOrDigit(ch4)) {
                while (i15 < count && Character.isLetterOrDigit(s15.charAt(i15++))) {
                }
            } else {
                i15 = 2;
            }
            offs += i15 - 1;
        }
        return offs;
    }

    public static int getWordStart(RSyntaxTextArea textArea, int offs) throws BadLocationException {
        Document doc = textArea.getDocument();
        Element line = RSyntaxUtilities.getLineElem(doc, offs);
        if (line == null) {
            throw new BadLocationException("No word at " + offs, offs);
        }
        int lineStart = line.getStartOffset();
        if (offs == lineStart) {
            return offs;
        }
        int endOffs = Math.min(offs + 1, doc.getLength());
        String s15 = doc.getText(lineStart, endOffs - lineStart);
        if (s15 != null && !s15.isEmpty()) {
            int i15 = s15.length() - 1;
            char ch4 = s15.charAt(i15);
            if (Character.isWhitespace(ch4)) {
                while (i15 > 0 && Character.isWhitespace(s15.charAt(i15 - 1))) {
                    --i15;
                }
                offs = lineStart + i15;
            } else if (Character.isLetterOrDigit(ch4)) {
                while (i15 > 0 && Character.isLetterOrDigit(s15.charAt(i15 - 1))) {
                    --i15;
                }
                offs = lineStart + i15;
            }
        }
        return offs;
    }

    public static float getTokenListWidth(Token tokenList, RSyntaxTextArea textArea, TabExpander e15) {
        return RSyntaxUtilities.getTokenListWidth(tokenList, textArea, e15, 0.0f);
    }

    public static float getTokenListWidth(Token tokenList, RSyntaxTextArea textArea, TabExpander e15, float x05) {
        float width = x05;
        for (Token t15 = tokenList; t15 != null && t15.isPaintable(); t15 = t15.getNextToken()) {
            width += t15.getWidth(textArea, e15, width);
        }
        return width - x05;
    }

    public static float getTokenListWidthUpTo(Token tokenList, RSyntaxTextArea textArea, TabExpander e15, float x05, int upTo) {
        float width = 0.0f;
        for (Token t15 = tokenList; t15 != null && t15.isPaintable(); t15 = t15.getNextToken()) {
            if (t15.containsPosition(upTo)) {
                return width + t15.getWidthUpTo(upTo - t15.getOffset(), textArea, e15, x05 + width);
            }
            width += t15.getWidth(textArea, e15, x05 + width);
        }
        return width;
    }

    public static boolean isBracket(char ch4) {
        return ch4 <= '}' && (DATA_TABLE[ch4] & 0x40) > 0;
    }

    public static boolean isDigit(char ch4) {
        return ch4 >= '0' && ch4 <= '9';
    }

    public static boolean isHexCharacter(char ch4) {
        return ch4 <= 'f' && (DATA_TABLE[ch4] & 0x10) > 0;
    }

    public static boolean isJavaOperator(char ch4) {
        return ch4 <= '~' && (DATA_TABLE[ch4] & 0x80) > 0;
    }

    public static boolean isLetter(char ch4) {
        return ch4 <= 'z' && (DATA_TABLE[ch4] & 2) > 0;
    }

    public static boolean isLetterOrDigit(char ch4) {
        return ch4 <= 'z' && (DATA_TABLE[ch4] & 0x20) > 0;
    }

    public static boolean isLightForeground(Color fg5) {
        return fg5.getRed() > 160 && fg5.getGreen() > 160 && fg5.getBlue() > 160;
    }

    public static boolean isNonWordChar(Token t15) {
        return t15.length() == 1 && !RSyntaxUtilities.isLetter(t15.charAt(0));
    }

    public static boolean isOsCaseSensitive() {
        return OS != 1 && OS != 2;
    }

    public static boolean isWhitespace(char ch4) {
        return ch4 == ' ' || ch4 == '\t';
    }

    public static void possiblyRepaintGutter(RTextArea textArea) {
        Gutter gutter = RSyntaxUtilities.getGutter(textArea);
        if (gutter != null) {
            gutter.repaint();
        }
    }

    public static boolean regexCanFollowInJavaScript(Token t15) {
        char ch4;
        return t15 == null || t15.length() == 1 && ((ch4 = t15.charAt(0)) == '=' || ch4 == '(' || ch4 == ',' || ch4 == '?' || ch4 == ':' || ch4 == '[' || ch4 == '!' || ch4 == '&') || t15.getType() == 23 && (t15.charAt(t15.length() - 1) == '=' || t15.is(JS_AND) || t15.is(JS_OR)) || t15.is(7, JS_KEYWORD_RETURN);
    }

    public static void selectAndPossiblyCenter(JTextArea textArea, DocumentRange range, boolean select) {
        Rectangle r15;
        RSyntaxTextArea rsta;
        FoldManager fm4;
        int start = range.getStartOffset();
        int end = range.getEndOffset();
        boolean foldsExpanded = false;
        if (textArea instanceof RSyntaxTextArea && (fm4 = (rsta = (RSyntaxTextArea)textArea).getFoldManager()).isCodeFoldingSupportedAndEnabled()) {
            foldsExpanded = fm4.ensureOffsetNotInClosedFold(start);
            foldsExpanded |= fm4.ensureOffsetNotInClosedFold(end);
        }
        if (select) {
            textArea.setSelectionStart(start);
            textArea.setSelectionEnd(end);
        }
        try {
            r15 = textArea.modelToView(start);
            if (r15 == null) {
                return;
            }
            if (end != start) {
                r15 = r15.union(textArea.modelToView(end));
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            if (select) {
                textArea.setSelectionStart(start);
                textArea.setSelectionEnd(end);
            }
            return;
        }
        Rectangle visible = textArea.getVisibleRect();
        if (!foldsExpanded && visible.contains(r15)) {
            if (select) {
                textArea.setSelectionStart(start);
                textArea.setSelectionEnd(end);
            }
            return;
        }
        visible.x = r15.x - (visible.width - r15.width) / 2;
        visible.y = r15.y - (visible.height - r15.height) / 2;
        Rectangle bounds = textArea.getBounds();
        Insets i15 = textArea.getInsets();
        bounds.x = i15.left;
        bounds.y = i15.top;
        bounds.width -= i15.left + i15.right;
        bounds.height -= i15.top + i15.bottom;
        if (visible.x < bounds.x) {
            visible.x = bounds.x;
        }
        if (visible.x + visible.width > bounds.x + bounds.width) {
            visible.x = bounds.x + bounds.width - visible.width;
        }
        if (visible.y < bounds.y) {
            visible.y = bounds.y;
        }
        if (visible.y + visible.height > bounds.y + bounds.height) {
            visible.y = bounds.y + bounds.height - visible.height;
        }
        textArea.scrollRectToVisible(visible);
    }

    public static char toLowerCase(char ch4) {
        if (ch4 >= 'A' && ch4 <= 'Z') {
            return (char)(ch4 | 0x20);
        }
        return ch4;
    }

    public static Pattern wildcardToPattern(String wildcard, boolean matchCase, boolean escapeStartChar) {
        Pattern p15;
        int flags = RSyntaxUtilities.getPatternFlags(matchCase, 0);
        StringBuilder sb5 = new StringBuilder();
        block8: for (int i15 = 0; i15 < wildcard.length(); ++i15) {
            char ch4 = wildcard.charAt(i15);
            switch (ch4) {
                case '*': {
                    sb5.append(".*");
                    continue block8;
                }
                case '?': {
                    sb5.append('.');
                    continue block8;
                }
                case '^': {
                    if (i15 > 0 || escapeStartChar) {
                        sb5.append('\\');
                    }
                    sb5.append('^');
                    continue block8;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '-': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '|': 
                case '}': {
                    sb5.append('\\').append(ch4);
                    continue block8;
                }
                default: {
                    sb5.append(ch4);
                }
            }
        }
        try {
            p15 = Pattern.compile(sb5.toString(), flags);
        }
        catch (PatternSyntaxException pse) {
            pse.printStackTrace();
            p15 = Pattern.compile(".+");
        }
        return p15;
    }
}

