/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.section.theme;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.section.theme.CodeAreaDecorationType;
import org.exbin.bined.section.theme.SectionBackgroundPaintMode;
import org.exbin.bined.swing.section.layout.SectionCodeAreaDecorations;

@ParametersAreNonnullByDefault
public class SectionCodeAreaThemeProfile {
    @Nonnull
    protected SectionBackgroundPaintMode borderPaintMode = SectionBackgroundPaintMode.STRIPED;
    protected boolean paintRowPosBackground = true;
    protected int verticalLineByteGroupSize = 0;
    protected final Set<CodeAreaDecorationType> decorations = new HashSet<CodeAreaDecorationType>();

    public SectionCodeAreaThemeProfile() {
        this.decorations.add(SectionCodeAreaDecorations.HEADER_LINE);
        this.decorations.add(SectionCodeAreaDecorations.ROW_POSITION_LINE);
        this.decorations.add(SectionCodeAreaDecorations.SPLIT_LINE);
    }

    @Nonnull
    public SectionCodeAreaThemeProfile createCopy() {
        SectionCodeAreaThemeProfile copy = new SectionCodeAreaThemeProfile();
        copy.borderPaintMode = this.borderPaintMode;
        copy.paintRowPosBackground = this.paintRowPosBackground;
        copy.verticalLineByteGroupSize = this.verticalLineByteGroupSize;
        copy.decorations.clear();
        copy.decorations.addAll(this.decorations);
        return copy;
    }

    @Nonnull
    public SectionBackgroundPaintMode getBackgroundPaintMode() {
        return this.borderPaintMode;
    }

    public void setBackgroundPaintMode(SectionBackgroundPaintMode borderPaintMode) {
        this.borderPaintMode = borderPaintMode;
    }

    public boolean isPaintRowPosBackground() {
        return this.paintRowPosBackground;
    }

    public void setPaintRowPosBackground(boolean paintRowPosBackground) {
        this.paintRowPosBackground = paintRowPosBackground;
    }

    public int getVerticalLineByteGroupSize() {
        return this.verticalLineByteGroupSize;
    }

    public void setVerticalLineByteGroupSize(int verticalLineByteGroupSize) {
        this.verticalLineByteGroupSize = verticalLineByteGroupSize;
    }

    public boolean hasDecoration(CodeAreaDecorationType decoration) {
        return this.decorations.contains(decoration);
    }

    public void setDecoration(CodeAreaDecorationType decoration, boolean value) {
        if (!value && this.hasDecoration(decoration)) {
            this.decorations.remove(decoration);
        } else if (value && !this.hasDecoration(decoration)) {
            this.decorations.add(decoration);
        }
    }

    public boolean showRowPositionLine() {
        return this.decorations.contains(SectionCodeAreaDecorations.ROW_POSITION_LINE);
    }

    public boolean showHeaderLine() {
        return this.decorations.contains(SectionCodeAreaDecorations.HEADER_LINE);
    }

    public boolean showSplitLine() {
        return this.decorations.contains(SectionCodeAreaDecorations.SPLIT_LINE);
    }

    public boolean showBoxLine() {
        return this.decorations.contains(SectionCodeAreaDecorations.BOX_LINES);
    }

    public boolean showGroupLines() {
        return this.decorations.contains(SectionCodeAreaDecorations.GROUP_LINES);
    }
}

