/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.GmtTimeZone;
import org.apache.commons.lang3.time.TimeZones;

public class FastTimeZone {
    private static final Pattern GMT_PATTERN = Pattern.compile("^(?:(?i)GMT)?([+-])?(\\d\\d?)?(:?(\\d\\d?))?$");
    private static final TimeZone GREENWICH = new GmtTimeZone(false, 0, 0);

    public static TimeZone getGmtTimeZone() {
        return GREENWICH;
    }

    public static TimeZone getGmtTimeZone(String pattern) {
        if ("Z".equals(pattern) || "UTC".equals(pattern)) {
            return GREENWICH;
        }
        Matcher m15 = GMT_PATTERN.matcher(pattern);
        if (m15.matches()) {
            int hours = FastTimeZone.parseInt(m15.group(2));
            int minutes = FastTimeZone.parseInt(m15.group(4));
            if (hours == 0 && minutes == 0) {
                return GREENWICH;
            }
            return new GmtTimeZone(FastTimeZone.parseSign(m15.group(1)), hours, minutes);
        }
        return null;
    }

    public static TimeZone getTimeZone(String id5) {
        TimeZone tz4 = FastTimeZone.getGmtTimeZone(id5);
        if (tz4 != null) {
            return tz4;
        }
        return TimeZones.getTimeZone(id5);
    }

    private static int parseInt(String group) {
        return group != null ? Integer.parseInt(group) : 0;
    }

    private static boolean parseSign(String group) {
        return group != null && group.charAt(0) == '-';
    }

    private FastTimeZone() {
    }
}

