/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.function;

import java.util.Objects;

@FunctionalInterface
public interface FailableIntPredicate<E extends Throwable> {
    public static final FailableIntPredicate FALSE = t15 -> false;
    public static final FailableIntPredicate TRUE = t15 -> true;

    public static <E extends Throwable> FailableIntPredicate<E> falsePredicate() {
        return FALSE;
    }

    public static <E extends Throwable> FailableIntPredicate<E> truePredicate() {
        return TRUE;
    }

    default public FailableIntPredicate<E> and(FailableIntPredicate<E> other) {
        Objects.requireNonNull(other);
        return t15 -> this.test(t15) && other.test(t15);
    }

    default public FailableIntPredicate<E> negate() {
        return t15 -> !this.test(t15);
    }

    default public FailableIntPredicate<E> or(FailableIntPredicate<E> other) {
        Objects.requireNonNull(other);
        return t15 -> this.test(t15) || other.test(t15);
    }

    public boolean test(int var1) throws E;
}

