/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.function;

import java.util.Objects;

@FunctionalInterface
public interface FailableDoublePredicate<E extends Throwable> {
    public static final FailableDoublePredicate FALSE = t15 -> false;
    public static final FailableDoublePredicate TRUE = t15 -> true;

    public static <E extends Throwable> FailableDoublePredicate<E> falsePredicate() {
        return FALSE;
    }

    public static <E extends Throwable> FailableDoublePredicate<E> truePredicate() {
        return TRUE;
    }

    default public FailableDoublePredicate<E> and(FailableDoublePredicate<E> other) {
        Objects.requireNonNull(other);
        return t15 -> this.test(t15) && other.test(t15);
    }

    default public FailableDoublePredicate<E> negate() {
        return t15 -> !this.test(t15);
    }

    default public FailableDoublePredicate<E> or(FailableDoublePredicate<E> other) {
        Objects.requireNonNull(other);
        return t15 -> this.test(t15) || other.test(t15);
    }

    public boolean test(double var1) throws E;
}

