/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.tree;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseTree
implements Tree {
    protected List<Object> children;

    public BaseTree() {
    }

    public BaseTree(Tree node) {
    }

    @Override
    public Tree getChild(int i15) {
        if (this.children == null || i15 >= this.children.size()) {
            return null;
        }
        return (Tree)this.children.get(i15);
    }

    public List<? extends Object> getChildren() {
        return this.children;
    }

    public Tree getFirstChildWithType(int type) {
        for (int i15 = 0; this.children != null && i15 < this.children.size(); ++i15) {
            Tree t15 = (Tree)this.children.get(i15);
            if (t15.getType() != type) continue;
            return t15;
        }
        return null;
    }

    @Override
    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public void addChild(Tree t15) {
        if (t15 == null) {
            return;
        }
        BaseTree childTree = (BaseTree)t15;
        if (childTree.isNil()) {
            if (this.children != null && this.children == childTree.children) {
                throw new RuntimeException("attempt to add child list to itself");
            }
            if (childTree.children != null) {
                if (this.children != null) {
                    int n15 = childTree.children.size();
                    for (int i15 = 0; i15 < n15; ++i15) {
                        Tree c15 = (Tree)childTree.children.get(i15);
                        this.children.add(c15);
                        c15.setParent(this);
                        c15.setChildIndex(this.children.size() - 1);
                    }
                } else {
                    this.children = childTree.children;
                    this.freshenParentAndChildIndexes();
                }
            }
        } else {
            if (this.children == null) {
                this.children = this.createChildrenList();
            }
            this.children.add(t15);
            childTree.setParent(this);
            childTree.setChildIndex(this.children.size() - 1);
        }
    }

    public void addChildren(List<? extends Tree> kids) {
        for (int i15 = 0; i15 < kids.size(); ++i15) {
            Tree t15 = kids.get(i15);
            this.addChild(t15);
        }
    }

    @Override
    public void setChild(int i15, Tree t15) {
        if (t15 == null) {
            return;
        }
        if (t15.isNil()) {
            throw new IllegalArgumentException("Can't set single child to a list");
        }
        if (this.children == null) {
            this.children = this.createChildrenList();
        }
        this.children.set(i15, t15);
        t15.setParent(this);
        t15.setChildIndex(i15);
    }

    public void insertChild(int i15, Object t15) {
        if (i15 < 0 || i15 > this.getChildCount()) {
            throw new IndexOutOfBoundsException(i15 + " out or range");
        }
        if (this.children == null) {
            this.children = this.createChildrenList();
        }
        this.children.add(i15, t15);
        this.freshenParentAndChildIndexes(i15);
    }

    @Override
    public Object deleteChild(int i15) {
        if (this.children == null) {
            return null;
        }
        Tree killed = (Tree)this.children.remove(i15);
        this.freshenParentAndChildIndexes(i15);
        return killed;
    }

    @Override
    public void replaceChildren(int startChildIndex, int stopChildIndex, Object t15) {
        List<Object> newChildren;
        if (this.children == null) {
            throw new IllegalArgumentException("indexes invalid; no children in list");
        }
        int replacingHowMany = stopChildIndex - startChildIndex + 1;
        BaseTree newTree = (BaseTree)t15;
        if (newTree.isNil()) {
            newChildren = newTree.children;
        } else {
            newChildren = new ArrayList<Object>(1);
            newChildren.add(newTree);
        }
        int replacingWithHowMany = newChildren.size();
        int numNewChildren = newChildren.size();
        int delta = replacingHowMany - replacingWithHowMany;
        if (delta == 0) {
            int j15 = 0;
            for (int i15 = startChildIndex; i15 <= stopChildIndex; ++i15) {
                BaseTree child = (BaseTree)newChildren.get(j15);
                this.children.set(i15, child);
                child.setParent(this);
                child.setChildIndex(i15);
                ++j15;
            }
        } else if (delta > 0) {
            int indexToDelete;
            for (int j16 = 0; j16 < numNewChildren; ++j16) {
                this.children.set(startChildIndex + j16, newChildren.get(j16));
            }
            for (int c15 = indexToDelete = startChildIndex + numNewChildren; c15 <= stopChildIndex; ++c15) {
                this.children.remove(indexToDelete);
            }
            this.freshenParentAndChildIndexes(startChildIndex);
        } else {
            for (int j17 = 0; j17 < replacingHowMany; ++j17) {
                this.children.set(startChildIndex + j17, newChildren.get(j17));
            }
            int numToInsert = replacingWithHowMany - replacingHowMany;
            for (int j18 = replacingHowMany; j18 < replacingWithHowMany; ++j18) {
                this.children.add(startChildIndex + j18, newChildren.get(j18));
            }
            this.freshenParentAndChildIndexes(startChildIndex);
        }
    }

    protected List<Object> createChildrenList() {
        return new ArrayList<Object>();
    }

    @Override
    public boolean isNil() {
        return false;
    }

    @Override
    public void freshenParentAndChildIndexes() {
        this.freshenParentAndChildIndexes(0);
    }

    public void freshenParentAndChildIndexes(int offset) {
        int n15 = this.getChildCount();
        for (int c15 = offset; c15 < n15; ++c15) {
            Tree child = this.getChild(c15);
            child.setChildIndex(c15);
            child.setParent(this);
        }
    }

    public void freshenParentAndChildIndexesDeeply() {
        this.freshenParentAndChildIndexesDeeply(0);
    }

    public void freshenParentAndChildIndexesDeeply(int offset) {
        int n15 = this.getChildCount();
        for (int c15 = offset; c15 < n15; ++c15) {
            BaseTree child = (BaseTree)this.getChild(c15);
            child.setChildIndex(c15);
            child.setParent(this);
            child.freshenParentAndChildIndexesDeeply();
        }
    }

    public void sanityCheckParentAndChildIndexes() {
        this.sanityCheckParentAndChildIndexes(null, -1);
    }

    public void sanityCheckParentAndChildIndexes(Tree parent, int i15) {
        if (parent != this.getParent()) {
            throw new IllegalStateException("parents don't match; expected " + parent + " found " + this.getParent());
        }
        if (i15 != this.getChildIndex()) {
            throw new IllegalStateException("child indexes don't match; expected " + i15 + " found " + this.getChildIndex());
        }
        int n15 = this.getChildCount();
        for (int c15 = 0; c15 < n15; ++c15) {
            CommonTree child = (CommonTree)this.getChild(c15);
            child.sanityCheckParentAndChildIndexes(this, c15);
        }
    }

    @Override
    public int getChildIndex() {
        return 0;
    }

    @Override
    public void setChildIndex(int index) {
    }

    @Override
    public Tree getParent() {
        return null;
    }

    @Override
    public void setParent(Tree t15) {
    }

    @Override
    public boolean hasAncestor(int ttype) {
        return this.getAncestor(ttype) != null;
    }

    @Override
    public Tree getAncestor(int ttype) {
        Tree t15 = this;
        for (t15 = t15.getParent(); t15 != null; t15 = t15.getParent()) {
            if (t15.getType() != ttype) continue;
            return t15;
        }
        return null;
    }

    public List<? extends Tree> getAncestors() {
        if (this.getParent() == null) {
            return null;
        }
        ArrayList<Tree> ancestors = new ArrayList<Tree>();
        Tree t15 = this;
        for (t15 = t15.getParent(); t15 != null; t15 = t15.getParent()) {
            ancestors.add(0, t15);
        }
        return ancestors;
    }

    @Override
    public String toStringTree() {
        if (this.children == null || this.children.isEmpty()) {
            return this.toString();
        }
        StringBuilder buf = new StringBuilder();
        if (!this.isNil()) {
            buf.append("(");
            buf.append(this.toString());
            buf.append(' ');
        }
        for (int i15 = 0; this.children != null && i15 < this.children.size(); ++i15) {
            Tree t15 = (Tree)this.children.get(i15);
            if (i15 > 0) {
                buf.append(' ');
            }
            buf.append(t15.toStringTree());
        }
        if (!this.isNil()) {
            buf.append(")");
        }
        return buf.toString();
    }

    @Override
    public int getLine() {
        return 0;
    }

    @Override
    public int getCharPositionInLine() {
        return 0;
    }

    @Override
    public abstract String toString();
}

