/*
 * Decompiled with CFR 0.152.
 */
package kotlin.metadata.internal.protobuf;

import java.util.NoSuchElementException;
import kotlin.metadata.internal.protobuf.ByteString;
import kotlin.metadata.internal.protobuf.LiteralByteString;

class BoundedByteString
extends LiteralByteString {
    private final int bytesOffset;
    private final int bytesLength;

    BoundedByteString(byte[] bytes, int offset, int length) {
        super(bytes);
        if (offset < 0) {
            int n15 = offset;
            throw new IllegalArgumentException(new StringBuilder(29).append("Offset too small: ").append(n15).toString());
        }
        if (length < 0) {
            int n16 = offset;
            throw new IllegalArgumentException(new StringBuilder(29).append("Length too small: ").append(n16).toString());
        }
        if ((long)offset + (long)length > (long)bytes.length) {
            int n17 = offset;
            int n18 = length;
            throw new IllegalArgumentException(new StringBuilder(48).append("Offset+Length too large: ").append(n17).append("+").append(n18).toString());
        }
        this.bytesOffset = offset;
        this.bytesLength = length;
    }

    @Override
    public byte byteAt(int index) {
        if (index < 0) {
            int n15 = index;
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(28).append("Index too small: ").append(n15).toString());
        }
        if (index >= this.size()) {
            int n16 = index;
            int n17 = this.size();
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(41).append("Index too large: ").append(n16).append(", ").append(n17).toString());
        }
        return this.bytes[this.bytesOffset + index];
    }

    @Override
    public int size() {
        return this.bytesLength;
    }

    @Override
    protected int getOffsetIntoBytes() {
        return this.bytesOffset;
    }

    @Override
    protected void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
        System.arraycopy(this.bytes, this.getOffsetIntoBytes() + sourceOffset, target, targetOffset, numberToCopy);
    }

    @Override
    public ByteString.ByteIterator iterator() {
        return new BoundedByteIterator();
    }

    private class BoundedByteIterator
    implements ByteString.ByteIterator {
        private int position;
        private final int limit;

        private BoundedByteIterator() {
            this.position = BoundedByteString.this.getOffsetIntoBytes();
            this.limit = this.position + BoundedByteString.this.size();
        }

        @Override
        public boolean hasNext() {
            return this.position < this.limit;
        }

        @Override
        public Byte next() {
            return this.nextByte();
        }

        @Override
        public byte nextByte() {
            if (this.position >= this.limit) {
                throw new NoSuchElementException();
            }
            return BoundedByteString.this.bytes[this.position++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

