/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.tools.resolvers.file;

import jadx.plugins.tools.data.JadxPluginMetadata;
import jadx.plugins.tools.resolvers.IJadxPluginResolver;
import jadx.plugins.tools.utils.PluginUtils;
import java.io.File;
import java.util.List;
import java.util.Optional;

public class LocalFileResolver
implements IJadxPluginResolver {
    @Override
    public String id() {
        return "file";
    }

    @Override
    public boolean isUpdateSupported() {
        return false;
    }

    private static boolean isValidFileLocation(String locationId) {
        return locationId.startsWith("file:") && (locationId.endsWith(".jar") || locationId.endsWith(".zip"));
    }

    @Override
    public Optional<JadxPluginMetadata> resolve(String locationId) {
        if (!LocalFileResolver.isValidFileLocation(locationId)) {
            return Optional.empty();
        }
        File pluginFile = new File(PluginUtils.removePrefix(locationId, "file:"));
        if (!pluginFile.isFile()) {
            throw new RuntimeException("File not found: " + pluginFile.getAbsolutePath());
        }
        JadxPluginMetadata metadata = new JadxPluginMetadata();
        metadata.setLocationId(locationId);
        metadata.setPath(pluginFile.getAbsolutePath());
        return Optional.of(metadata);
    }

    @Override
    public List<JadxPluginMetadata> resolveVersions(String locationId, int page, int perPage) {
        if (page > 1) {
            return List.of();
        }
        return this.resolve(locationId).map(List::of).orElseGet(List::of);
    }

    @Override
    public boolean hasVersion(String locationId) {
        return false;
    }
}

