/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.mappings.load;

import jadx.api.plugins.pass.JadxPassInfo;
import jadx.api.plugins.pass.impl.OrderedJadxPassInfo;
import jadx.api.plugins.pass.types.JadxPreparePass;
import jadx.core.codegen.TypeGen;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.plugins.mappings.RenameMappingsData;
import net.fabricmc.mappingio.tree.MappingTreeView;

public class ApplyMappingsPass
implements JadxPreparePass {
    @Override
    public JadxPassInfo getInfo() {
        return new OrderedJadxPassInfo("ApplyMappings", "Apply mappings to classes, fields and methods").after("LoadMappings").before("RenameVisitor");
    }

    @Override
    public void init(RootNode root) {
        RenameMappingsData data = RenameMappingsData.getData(root);
        if (data == null) {
            return;
        }
        MappingTreeView mappingTree = data.getMappings();
        this.process(root, mappingTree);
        root.registerCodeDataUpdateListener(codeData -> this.process(root, mappingTree));
    }

    private void process(RootNode root, MappingTreeView mappingTree) {
        for (ClassNode cls : root.getClasses()) {
            String clsRawName = cls.getClassInfo().getRawName().replace('.', '/');
            MappingTreeView.ClassMappingView mapping = mappingTree.getClass(clsRawName);
            if (mapping == null) continue;
            ApplyMappingsPass.processClass(cls, mapping);
        }
    }

    private static void processClass(ClassNode cls, MappingTreeView.ClassMappingView classMapping) {
        String alias = classMapping.getDstName(0);
        if (alias != null) {
            cls.rename(alias.replace('/', '.'));
        }
        if (classMapping.getComment() != null) {
            cls.addCodeComment(classMapping.getComment());
        }
        for (FieldNode field : cls.getFields()) {
            FieldInfo fieldInfo = field.getFieldInfo();
            String signature = TypeGen.signature(fieldInfo.getType());
            MappingTreeView.FieldMappingView fieldMapping = classMapping.getField(fieldInfo.getName(), signature);
            if (fieldMapping == null) continue;
            ApplyMappingsPass.processField(field, fieldMapping);
        }
        for (MethodNode method : cls.getMethods()) {
            String methodDesc;
            MethodInfo methodInfo = method.getMethodInfo();
            String methodName = methodInfo.getName();
            MappingTreeView.MethodMappingView methodMapping = classMapping.getMethod(methodName, methodDesc = methodInfo.getShortId().substring(methodName.length()));
            if (methodMapping == null) continue;
            ApplyMappingsPass.processMethod(method, methodMapping);
        }
    }

    private static void processField(FieldNode field, MappingTreeView.FieldMappingView fieldMapping) {
        String comment;
        String alias = fieldMapping.getDstName(0);
        if (alias != null) {
            field.rename(alias);
        }
        if ((comment = fieldMapping.getComment()) != null) {
            field.addCodeComment(comment);
        }
    }

    private static void processMethod(MethodNode method, MappingTreeView.MethodMappingView methodMapping) {
        String comment;
        String alias = methodMapping.getDstName(0);
        if (alias != null) {
            method.rename(alias);
        }
        if ((comment = methodMapping.getComment()) != null) {
            method.addCodeComment(comment);
        }
    }
}

