/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.ui;

import jadx.api.ResourceFile;
import jadx.api.ResourcesLoader;
import jadx.core.plugins.files.TempFilesGetter;
import jadx.gui.treemodel.JResource;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.awt.Desktop;
import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileOpenerHelper {
    private static final Logger LOG = LoggerFactory.getLogger(FileOpenerHelper.class);

    public static void exportBinary(JResource resource, Path savePath) {
        try (BufferedOutputStream os4 = new BufferedOutputStream(new FileOutputStream(savePath.toFile()));){
            byte[] bytes = ResourcesLoader.decodeStream(resource.getResFile(), (size, is4) -> is4.readAllBytes());
            if (bytes == null) {
                bytes = new byte[]{};
            }
            os4.write(bytes);
        }
        catch (Exception e15) {
            throw new RuntimeException("Error saving file " + resource.getName(), e15);
        }
    }

    public static void openFile(Frame frame, JResource res) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            Path tempDir = TempFilesGetter.INSTANCE.getTempDir();
            ResourceFile resFile = res.getResFile();
            Path path = Paths.get(resFile.getDeobfName(), new String[0]);
            Path fileNamePath = path.getFileName();
            Path filePath = tempDir.resolve(fileNamePath);
            FileOpenerHelper.exportBinary(res, filePath);
            if (!Files.exists(filePath, new LinkOption[0])) {
                UiUtils.errorMessage(frame, NLS.str("error_dialog.not_found_file", filePath));
                return;
            }
            if (Files.isDirectory(filePath, new LinkOption[0])) {
                UiUtils.errorMessage(frame, NLS.str("error_dialog.path_is_directory", filePath));
                return;
            }
            if (!Files.isReadable(filePath)) {
                UiUtils.errorMessage(frame, NLS.str("error_dialog.cannot_read", filePath));
                return;
            }
            try {
                desktop.open(filePath.toFile());
            }
            catch (IOException ex4) {
                UiUtils.errorMessage(frame, NLS.str("error_dialog.open_failed", ex4.getMessage()));
                LOG.error("Unable to open file: {0}", ex4);
            }
            catch (IllegalArgumentException ex5) {
                UiUtils.errorMessage(frame, NLS.str("error_dialog.invalid_path_format", ex5.getMessage()));
                LOG.error("Invalid file path: {0}", ex5);
            }
        } else {
            UiUtils.errorMessage(frame, NLS.str("error_dialog.desktop_unsupported"));
        }
    }
}

