/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.dialog;

import jadx.api.data.CommentStyle;
import jadx.api.data.ICodeComment;
import jadx.api.data.impl.JadxCodeComment;
import jadx.api.data.impl.JadxCodeData;
import jadx.gui.settings.JadxProject;
import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.ui.dialog.CommonDialog;
import jadx.gui.utils.NLS;
import jadx.gui.utils.TextStandardActions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentDialog
extends CommonDialog {
    private static final long serialVersionUID = -1865682124935757528L;
    private static final Logger LOG = LoggerFactory.getLogger(CommentDialog.class);
    private final transient CodeArea codeArea;
    private final transient ICodeComment comment;
    private final transient boolean updateComment;
    private transient JTextArea commentArea;
    private transient JComboBox<CommentStyle> styleCombo;

    public static void show(CodeArea codeArea, ICodeComment comment, boolean updateComment) {
        CommentDialog dialog = new CommentDialog(codeArea, comment, updateComment);
        dialog.setVisible(true);
    }

    private static void updateCommentsData(CodeArea codeArea, Consumer<List<ICodeComment>> updater) {
        try {
            JadxProject project = codeArea.getProject();
            JadxCodeData codeData = project.getCodeData();
            if (codeData == null) {
                codeData = new JadxCodeData();
            }
            ArrayList<ICodeComment> list2 = new ArrayList<ICodeComment>(codeData.getComments());
            updater.accept(list2);
            Collections.sort(list2);
            codeData.setComments(list2);
            project.setCodeData(codeData);
            codeArea.getMainWindow().getWrapper().reloadCodeData();
        }
        catch (Exception e15) {
            LOG.error("Comment action failed", e15);
        }
        try {
            codeArea.refreshClass();
        }
        catch (Exception e16) {
            LOG.error("Failed to reload code", e16);
        }
    }

    public CommentDialog(CodeArea codeArea, ICodeComment comment, boolean updateComment) {
        super(codeArea.getMainWindow());
        this.codeArea = codeArea;
        this.comment = comment;
        this.updateComment = updateComment;
        this.initUI();
    }

    private void apply() {
        String newCommentStr = this.commentArea.getText().trim();
        if (newCommentStr.isEmpty()) {
            if (this.updateComment) {
                this.remove();
            } else {
                this.cancel();
            }
            return;
        }
        CommentStyle style = (CommentStyle)((Object)this.styleCombo.getSelectedItem());
        JadxCodeComment newComment = new JadxCodeComment(this.comment.getNodeRef(), this.comment.getCodeRef(), newCommentStr, style);
        if (this.updateComment) {
            CommentDialog.updateCommentsData(this.codeArea, list2 -> {
                list2.remove(this.comment);
                list2.add(newComment);
            });
        } else {
            CommentDialog.updateCommentsData(this.codeArea, list2 -> list2.add(newComment));
        }
        this.dispose();
    }

    private void remove() {
        CommentDialog.updateCommentsData(this.codeArea, list2 -> list2.removeIf(c15 -> c15 == this.comment));
        this.dispose();
    }

    private void cancel() {
        this.dispose();
    }

    private void initUI() {
        this.commentArea = new JTextArea();
        TextStandardActions.attach(this.commentArea);
        this.commentArea.setEditable(true);
        this.commentArea.setFont(this.mainWindow.getSettings().getCodeFont());
        this.commentArea.setAlignmentX(0.0f);
        this.commentArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e15) {
                switch (e15.getKeyCode()) {
                    case 10: {
                        if (e15.isShiftDown() || e15.isControlDown()) {
                            CommentDialog.this.commentArea.insert("\n", CommentDialog.this.commentArea.getCaretPosition());
                            break;
                        }
                        CommentDialog.this.apply();
                        break;
                    }
                    case 27: {
                        CommentDialog.this.cancel();
                    }
                }
            }
        });
        if (this.updateComment) {
            this.commentArea.setText(this.comment.getComment());
        }
        JScrollPane textAreaScrollPane = new JScrollPane(this.commentArea);
        textAreaScrollPane.setAlignmentX(0.0f);
        this.styleCombo = new JComboBox<CommentStyle>(CommentStyle.values());
        this.styleCombo.setSelectedItem((Object)this.comment.getStyle());
        JLabel commentLabel = new JLabel(NLS.str("comment_dialog.label"), 2);
        JLabel styleLabel = new JLabel(NLS.str("comment_dialog.style"), 2);
        JLabel usageLabel = new JLabel(NLS.str("comment_dialog.usage"), 2);
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new BoxLayout(inputPanel, 3));
        inputPanel.add(commentLabel);
        inputPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        inputPanel.add(textAreaScrollPane);
        inputPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        inputPanel.add(usageLabel);
        JPanel stylePanel = new JPanel();
        stylePanel.setLayout(new BoxLayout(stylePanel, 2));
        stylePanel.setAlignmentX(0.0f);
        stylePanel.add(styleLabel);
        stylePanel.add(Box.createRigidArea(new Dimension(5, 0)));
        stylePanel.add(this.styleCombo);
        JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
        mainPanel.add((Component)inputPanel, "Center");
        mainPanel.add((Component)stylePanel, "Last");
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel buttonPane = this.initButtonsPanel();
        Container contentPane = this.getContentPane();
        contentPane.add((Component)mainPanel, "Center");
        contentPane.add((Component)buttonPane, "Last");
        if (this.updateComment) {
            this.setTitle(NLS.str("comment_dialog.title.update"));
        } else {
            this.setTitle(NLS.str("comment_dialog.title.add"));
        }
        this.commonWindowInit();
    }

    protected JPanel initButtonsPanel() {
        JButton removeBtn;
        JButton cancelButton = new JButton(NLS.str("common_dialog.cancel"));
        cancelButton.addActionListener(event -> this.cancel());
        String applyStr = this.updateComment ? NLS.str("common_dialog.update") : NLS.str("common_dialog.add");
        JButton renameBtn = new JButton(applyStr);
        renameBtn.addActionListener(event -> this.apply());
        this.getRootPane().setDefaultButton(renameBtn);
        if (this.updateComment) {
            removeBtn = new JButton(NLS.str("common_dialog.remove"));
            removeBtn.addActionListener(event -> this.remove());
        } else {
            removeBtn = null;
        }
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(renameBtn);
        if (removeBtn != null) {
            buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
            buttonPane.add(removeBtn);
        }
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(cancelButton);
        return buttonPane;
    }
}

