/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.api.data.ICodeRename;
import jadx.api.data.impl.JadxCodeRename;
import jadx.api.data.impl.JadxNodeRef;
import jadx.api.metadata.ICodeNodeRef;
import jadx.core.deobf.NameMapper;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.args.ArgType;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JRenameNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.cellrenders.MethodRenderHelper;
import jadx.gui.ui.dialog.RenameDialog;
import jadx.gui.utils.UiUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import org.jetbrains.annotations.NotNull;

public class JMethod
extends JNode
implements JRenameNode {
    private static final long serialVersionUID = 3834526867464663751L;
    private final transient JavaMethod mth;
    private final transient JClass jParent;
    private static final Comparator<JMethod> COMPARATOR = Comparator.comparing(JMethod::getJParent).thenComparing(jMethod -> jMethod.mth.getMethodNode().getMethodInfo().getShortId()).thenComparingInt(JMethod::getPos);

    public JMethod(JavaMethod javaMethod, JClass jClass) {
        this.mth = javaMethod;
        this.jParent = jClass;
    }

    @Override
    public JavaNode getJavaNode() {
        return this.mth;
    }

    public JavaMethod getJavaMethod() {
        return this.mth;
    }

    @Override
    public ICodeNodeRef getCodeNodeRef() {
        return this.mth.getMethodNode();
    }

    @Override
    public JClass getJParent() {
        return this.jParent;
    }

    public ArgType getReturnType() {
        return this.mth.getReturnType();
    }

    @Override
    public JClass getRootClass() {
        return this.jParent.getRootClass();
    }

    @Override
    public Icon getIcon() {
        return MethodRenderHelper.getIcon(this.mth);
    }

    @Override
    public String getSyntaxName() {
        return "text/java";
    }

    @Override
    public JPopupMenu onTreePopupMenu(MainWindow mainWindow) {
        return RenameDialog.buildRenamePopup(mainWindow, this);
    }

    String makeBaseString() {
        return MethodRenderHelper.makeBaseString(this.mth);
    }

    @Override
    public String getName() {
        return this.mth.getName();
    }

    @Override
    public String getTitle() {
        return this.makeLongStringHtml();
    }

    @Override
    public boolean canRename() {
        if (this.mth.isClassInit()) {
            return false;
        }
        return !this.mth.getMethodNode().contains(AFlag.DONT_RENAME);
    }

    @Override
    public JRenameNode replace() {
        if (this.mth.isConstructor()) {
            return this.jParent;
        }
        return this;
    }

    @Override
    public ICodeRename buildCodeRename(String newName, Set<ICodeRename> renames) {
        List<JavaMethod> relatedMethods = this.mth.getOverrideRelatedMethods();
        if (!relatedMethods.isEmpty()) {
            for (JavaMethod relatedMethod : relatedMethods) {
                renames.remove(new JadxCodeRename(JadxNodeRef.forMth(relatedMethod), ""));
            }
        }
        return new JadxCodeRename(JadxNodeRef.forMth(this.mth), newName);
    }

    @Override
    public boolean isValidName(String newName) {
        return NameMapper.isValidIdentifier(newName);
    }

    @Override
    public void removeAlias() {
        this.mth.removeAlias();
    }

    @Override
    public void addUpdateNodes(List<JavaNode> toUpdate) {
        toUpdate.add(this.mth);
        toUpdate.addAll(this.mth.getUseIn());
        List<JavaMethod> overrideRelatedMethods = this.mth.getOverrideRelatedMethods();
        toUpdate.addAll(overrideRelatedMethods);
        for (JavaMethod ovrdMth : overrideRelatedMethods) {
            toUpdate.addAll(ovrdMth.getUseIn());
        }
    }

    @Override
    public void reload(MainWindow mainWindow) {
        mainWindow.reloadTreePreservingState();
    }

    @Override
    public String makeString() {
        return UiUtils.typeFormat(this.makeBaseString(), this.getReturnType());
    }

    @Override
    public String makeStringHtml() {
        return UiUtils.typeFormatHtml(this.makeBaseString(), this.getReturnType());
    }

    @Override
    public String makeLongString() {
        String name = this.mth.getDeclaringClass().getFullName() + "." + this.makeBaseString();
        return UiUtils.typeFormat(name, this.getReturnType());
    }

    @Override
    public String makeLongStringHtml() {
        String name = this.mth.getDeclaringClass().getFullName() + "." + this.makeBaseString();
        return UiUtils.typeFormatHtml(name, this.getReturnType());
    }

    @Override
    public boolean disableHtml() {
        return false;
    }

    @Override
    public String makeDescString() {
        return UiUtils.typeStr(this.getReturnType()) + " " + this.makeBaseString();
    }

    @Override
    public boolean hasDescString() {
        return false;
    }

    @Override
    public int getPos() {
        return this.mth.getDefPos();
    }

    public int hashCode() {
        return this.mth.hashCode();
    }

    public boolean equals(Object o15) {
        return this == o15 || o15 instanceof JMethod && this.mth.equals(((JMethod)o15).mth);
    }

    public int compareToMth(@NotNull JMethod other) {
        return COMPARATOR.compare(this, other);
    }

    @Override
    public int compareTo(@NotNull JNode other) {
        if (other instanceof JMethod) {
            return this.compareToMth((JMethod)other);
        }
        if (other instanceof JClass) {
            JClass cls = (JClass)other;
            int cmp = this.jParent.compareToCls(cls);
            if (cmp != 0) {
                return cmp;
            }
            return 1;
        }
        return super.compareTo(other);
    }
}

