/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.settings.ui.plugins;

import jadx.api.plugins.gui.ISettingsGroup;
import jadx.core.plugins.PluginContext;
import jadx.core.utils.StringUtils;
import jadx.core.utils.Utils;
import jadx.gui.settings.ui.plugins.AvailablePluginNode;
import jadx.gui.settings.ui.plugins.BasePluginListNode;
import jadx.gui.settings.ui.plugins.InstalledPluginNode;
import jadx.gui.settings.ui.plugins.LoadedPluginNode;
import jadx.gui.settings.ui.plugins.PluginAction;
import jadx.gui.settings.ui.plugins.PluginSettings;
import jadx.gui.settings.ui.plugins.TitleNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.Link;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.plugins.CloseablePlugins;
import jadx.plugins.tools.JadxPluginsList;
import jadx.plugins.tools.JadxPluginsTools;
import jadx.plugins.tools.data.JadxPluginMetadata;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PluginSettingsGroup
implements ISettingsGroup {
    private static final Logger LOG = LoggerFactory.getLogger(PluginSettingsGroup.class);
    private final PluginSettings pluginsSettings;
    private final MainWindow mainWindow;
    private final String title;
    private final List<ISettingsGroup> subGroups = new ArrayList<ISettingsGroup>();
    private final CloseablePlugins collectedPlugins;
    private JPanel detailsPanel;

    public PluginSettingsGroup(PluginSettings pluginSettings, MainWindow mainWindow, CloseablePlugins collectedPlugins) {
        this.pluginsSettings = pluginSettings;
        this.mainWindow = mainWindow;
        this.title = NLS.str("preferences.plugins");
        this.collectedPlugins = collectedPlugins;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public List<ISettingsGroup> getSubGroups() {
        return this.subGroups;
    }

    @Override
    public JComponent buildComponent() {
        return this.buildMainSettingsPage();
    }

    @Override
    public void close(boolean save) {
        this.subGroups.forEach(subGroup -> subGroup.close(save));
        this.collectedPlugins.close();
    }

    private JPanel buildMainSettingsPage() {
        JButton installPluginBtn = new JButton(NLS.str("preferences.plugins.install"));
        installPluginBtn.addActionListener(ev4 -> this.pluginsSettings.addPlugin());
        JButton updateAllBtn = new JButton(NLS.str("preferences.plugins.update_all"));
        updateAllBtn.addActionListener(ev4 -> this.pluginsSettings.updateAll());
        JPanel actionsPanel = new JPanel();
        actionsPanel.setLayout(new BoxLayout(actionsPanel, 2));
        actionsPanel.add(installPluginBtn);
        actionsPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        actionsPanel.add(updateAllBtn);
        DefaultListModel<BasePluginListNode> listModel = new DefaultListModel<BasePluginListNode>();
        JList<BasePluginListNode> pluginList = new JList<BasePluginListNode>(listModel);
        pluginList.setSelectionMode(0);
        pluginList.setCellRenderer(new PluginsListCellRenderer());
        pluginList.addListSelectionListener(ev4 -> this.onSelection((BasePluginListNode)pluginList.getSelectedValue()));
        pluginList.setFocusable(true);
        JScrollPane scrollPane = new JScrollPane(pluginList);
        scrollPane.setMinimumSize(new Dimension(80, 120));
        this.detailsPanel = new JPanel(new BorderLayout(5, 5));
        this.detailsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(NLS.str("preferences.plugins.details")), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.detailsPanel.setLayout(new BoxLayout(this.detailsPanel, 3));
        JSplitPane splitPanel = new JSplitPane();
        splitPanel.setBorder(BorderFactory.createEmptyBorder(10, 2, 2, 2));
        splitPanel.setLeftComponent(scrollPane);
        splitPanel.setRightComponent(this.detailsPanel);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(5, 5));
        mainPanel.setBorder(BorderFactory.createTitledBorder(this.title));
        mainPanel.add((Component)actionsPanel, "First");
        mainPanel.add((Component)splitPanel, "Center");
        this.applyData(listModel);
        return mainPanel;
    }

    private void applyData(DefaultListModel<BasePluginListNode> listModel) {
        List<JadxPluginMetadata> installed = JadxPluginsTools.getInstance().getInstalled();
        ArrayList<BasePluginListNode> nodes = new ArrayList<BasePluginListNode>(installed.size() + this.collectedPlugins.getList().size());
        HashSet<String> installedSet = new HashSet<String>(installed.size());
        for (JadxPluginMetadata pluginMetadata : installed) {
            installedSet.add(pluginMetadata.getPluginId());
            nodes.add(new InstalledPluginNode(pluginMetadata));
        }
        for (PluginContext plugin : this.collectedPlugins.getList()) {
            if (installedSet.contains(plugin.getPluginId())) continue;
            nodes.add(new LoadedPluginNode(plugin));
        }
        nodes.sort(Comparator.comparing(BasePluginListNode::getTitle));
        PluginSettingsGroup.fillListModel(listModel, nodes, Collections.emptyList());
        this.loadAvailablePlugins(listModel, nodes, installedSet);
    }

    private static void fillListModel(DefaultListModel<BasePluginListNode> listModel, List<BasePluginListNode> nodes, List<AvailablePluginNode> available) {
        listModel.clear();
        listModel.addElement(new TitleNode("Installed"));
        nodes.stream().filter(n15 -> n15.getAction() == PluginAction.UNINSTALL).forEach(listModel::addElement);
        listModel.addElement(new TitleNode("Available"));
        listModel.addAll(available);
        listModel.addElement(new TitleNode("Bundled"));
        nodes.stream().filter(n15 -> n15.getAction() == PluginAction.NONE).forEach(listModel::addElement);
    }

    private void loadAvailablePlugins(DefaultListModel<BasePluginListNode> listModel, List<BasePluginListNode> nodes, Set<String> installedSet) {
        this.mainWindow.getBackgroundExecutor().execute(NLS.str("preferences.plugins.task.downloading_list"), () -> {
            try {
                JadxPluginsList.getInstance().get(availablePlugins -> {
                    List availableNodes = availablePlugins.stream().filter(availablePlugin -> !installedSet.contains(availablePlugin.getPluginId())).map(AvailablePluginNode::new).collect(Collectors.toList());
                    UiUtils.uiRunAndWait(() -> PluginSettingsGroup.fillListModel(listModel, nodes, availableNodes));
                });
            }
            catch (Exception e15) {
                LOG.warn("Failed to load available plugins list", e15);
            }
        });
    }

    private void onSelection(BasePluginListNode node) {
        this.detailsPanel.removeAll();
        if (node.hasDetails()) {
            JLabel nameLbl = new JLabel(node.getTitle());
            Font baseFont = nameLbl.getFont();
            nameLbl.setFont(baseFont.deriveFont(1, baseFont.getSize2D() + 2.0f));
            Link homeLink = null;
            String homepage = node.getHomepage();
            if (StringUtils.notBlank(homepage)) {
                homeLink = new Link("Homepage: " + homepage, homepage);
                homeLink.setHorizontalAlignment(2);
            }
            JTextPane descArea = new JTextPane();
            descArea.setText(node.getDescription());
            descArea.setFont(baseFont.deriveFont(baseFont.getSize2D() + 1.0f));
            descArea.setEditable(false);
            descArea.setBorder(BorderFactory.createEmptyBorder());
            descArea.setOpaque(true);
            JPanel top = new JPanel();
            top.setLayout(new BoxLayout(top, 2));
            top.setBorder(BorderFactory.createEmptyBorder(10, 2, 10, 2));
            top.add(nameLbl);
            top.add(Box.createHorizontalGlue());
            JButton actionBtn = this.makeActionButton(node);
            if (actionBtn != null) {
                top.add(actionBtn);
            }
            if (node.getAction() == PluginAction.UNINSTALL) {
                boolean disabled = node.isDisabled();
                String statusChangeLabel = disabled ? NLS.str("preferences.plugins.enable_btn") : NLS.str("preferences.plugins.disable_btn");
                JButton statusBtn = new JButton(statusChangeLabel);
                statusBtn.addActionListener(ev4 -> this.pluginsSettings.changeDisableStatus(node.getPluginId(), !disabled));
                top.add(Box.createHorizontalStrut(10));
                top.add(statusBtn);
            }
            JPanel center = new JPanel();
            center.setLayout(new BoxLayout(center, 3));
            center.setBorder(BorderFactory.createEmptyBorder(10, 2, 10, 2));
            center.add(descArea);
            if (homeLink != null) {
                JPanel link = new JPanel();
                link.setLayout(new BoxLayout(link, 2));
                link.add(homeLink);
                link.add(Box.createHorizontalGlue());
                center.add(link);
            }
            center.add(Box.createVerticalGlue());
            this.detailsPanel.add((Component)top, "First");
            this.detailsPanel.add((Component)center, "Center");
        }
        this.detailsPanel.updateUI();
    }

    @Nullable
    private JButton makeActionButton(BasePluginListNode node) {
        switch (node.getAction()) {
            case NONE: {
                return null;
            }
            case INSTALL: {
                JButton installBtn = new JButton(NLS.str("preferences.plugins.install_btn"));
                installBtn.addActionListener(ev4 -> this.pluginsSettings.install(node.getLocationId()));
                return installBtn;
            }
            case UNINSTALL: {
                JButton uninstallBtn = new JButton(NLS.str("preferences.plugins.uninstall_btn"));
                uninstallBtn.addActionListener(ev4 -> this.pluginsSettings.uninstall(node.getPluginId()));
                return uninstallBtn;
            }
        }
        return null;
    }

    private static class PluginsListCellRenderer
    implements ListCellRenderer<BasePluginListNode> {
        private final JPanel panel = new JPanel();
        private final JLabel nameLbl;
        private final JLabel versionLbl;
        private final JLabel titleLbl;

        public PluginsListCellRenderer() {
            this.panel.setOpaque(true);
            this.panel.setLayout(new BoxLayout(this.panel, 2));
            this.panel.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 10));
            this.nameLbl = new JLabel("");
            this.nameLbl.setFont(this.nameLbl.getFont().deriveFont(1));
            this.nameLbl.setOpaque(true);
            this.versionLbl = new JLabel("");
            this.versionLbl.setOpaque(true);
            this.versionLbl.setPreferredSize(new Dimension(40, 10));
            this.panel.add(this.nameLbl);
            this.panel.add(Box.createHorizontalStrut(20));
            this.panel.add(Box.createHorizontalGlue());
            this.panel.add(this.versionLbl);
            this.panel.add(Box.createHorizontalStrut(10));
            this.titleLbl = new JLabel();
            this.titleLbl.setHorizontalAlignment(0);
            this.titleLbl.setPreferredSize(new Dimension(40, 10));
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends BasePluginListNode> list2, BasePluginListNode plugin, int index, boolean isSelected, boolean cellHasFocus) {
            if (!plugin.hasDetails()) {
                this.titleLbl.setText(plugin.getTitle());
                return this.titleLbl;
            }
            this.nameLbl.setText(plugin.getTitle());
            this.nameLbl.setToolTipText(plugin.getLocationId());
            this.versionLbl.setText(Utils.getOrElse(plugin.getVersion(), ""));
            this.panel.getAccessibleContext().setAccessibleName(plugin.getTitle());
            boolean enabled = !plugin.isDisabled();
            this.nameLbl.setEnabled(enabled);
            this.versionLbl.setEnabled(enabled);
            if (isSelected) {
                this.panel.setBackground(list2.getSelectionBackground());
                this.nameLbl.setBackground(list2.getSelectionBackground());
                this.nameLbl.setForeground(list2.getSelectionForeground());
                this.versionLbl.setBackground(list2.getSelectionBackground());
            } else {
                this.panel.setBackground(list2.getBackground());
                this.nameLbl.setBackground(list2.getBackground());
                this.nameLbl.setForeground(list2.getForeground());
                this.versionLbl.setBackground(list2.getBackground());
            }
            return this.panel;
        }
    }
}

