/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.report;

import jadx.api.JadxDecompiler;
import jadx.cli.config.JadxConfigAdapter;
import jadx.commons.app.JadxSystemInfo;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.report.ExceptionData;
import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.JadxSettingsData;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.LafManager;
import jadx.gui.utils.Link;
import jadx.gui.utils.TextStandardActions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionDialog
extends JDialog {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionDialog.class);
    private static final String FMT_DETAIL_LENGTH = "-13";

    ExceptionDialog(MainWindow mainWindow, ExceptionData data) {
        super((Frame)mainWindow, "Jadx Error");
        String issueBody;
        String issueTitle;
        this.getContentPane().setLayout(new BorderLayout());
        JPanel titlePanel = new JPanel(new GridBagLayout());
        GridBagConstraints c15 = new GridBagConstraints();
        c15.fill = 10;
        c15.gridx = 0;
        c15.weightx = 1.0;
        c15.insets = new Insets(2, 5, 5, 5);
        JLabel titleLabel = new JLabel("<html><h1>An error occurred</h1><p>Jadx encountered an unexpected error.</p></html>");
        LinkedHashMap<String, String> details = new LinkedHashMap<String, String>();
        details.put("Jadx version", JadxDecompiler.getVersion());
        details.put("Java version", JadxSystemInfo.JAVA_VER);
        details.put("Java VM", String.format("%s %s", System.getProperty("java.vm.vendor", "?"), System.getProperty("java.vm.name", "?")));
        details.put("Platform", String.format("%s (%s %s)", JadxSystemInfo.OS_NAME, JadxSystemInfo.OS_VERSION, JadxSystemInfo.OS_ARCH));
        Runtime runtime = Runtime.getRuntime();
        details.put("Max heap size", String.format("%d MB", runtime.maxMemory() / 0x100000L));
        try {
            List<String> args = ManagementFactory.getRuntimeMXBean().getInputArguments();
            details.put("Program args", String.join((CharSequence)" ", args));
        }
        catch (Throwable t15) {
            LOG.error("failed to get program arguments", t15);
        }
        Throwable ex4 = data.getException();
        StringWriter stackTraceWriter = new StringWriter(1024);
        ex4.printStackTrace(new PrintWriter(stackTraceWriter));
        String stackTrace = stackTraceWriter.toString();
        try {
            issueTitle = URLEncoder.encode(ex4.toString(), StandardCharsets.UTF_8);
        }
        catch (Exception e15) {
            LOG.error("URL encoding of title failed", e15);
            issueTitle = ex4.getClass().getSimpleName();
        }
        Object message2 = "Please describe what you did before the error occurred.\n\n";
        message2 = (String)message2 + "**IMPORTANT!** If the error occurs with a specific APK file please attach or provide link to apk file!\n\n";
        StringBuilder detailsIssueBuilder = new StringBuilder();
        details.forEach((key, value) -> detailsIssueBuilder.append(String.format("* %s: %s\n", key, value)));
        String body = String.format("%s%s\n```\n%s\n```", message2, detailsIssueBuilder, stackTrace);
        try {
            issueBody = URLEncoder.encode(body, StandardCharsets.UTF_8);
        }
        catch (Exception e16) {
            LOG.error("URL encoding of body failed", e16);
            issueBody = "Please copy the displayed text in the Jadx error dialog and paste it here";
        }
        c15.gridy = 0;
        titlePanel.add((Component)titleLabel, c15);
        String project = data.getGithubProject();
        if (!project.isEmpty()) {
            String url = String.format("https://github.com/%s/issues/new?labels=bug&title=%s&body=%s", project, issueTitle, issueBody);
            Link issueLink = new Link("<html><u><b>Create a new issue at GitHub</b></u></html>", url);
            c15.gridy = 1;
            titlePanel.add((Component)issueLink, c15);
        }
        JTextArea messageArea = new JTextArea();
        TextStandardActions.attach(messageArea);
        messageArea.setEditable(false);
        messageArea.setFont(mainWindow.getSettings().getCodeFont().deriveFont(12.0f));
        messageArea.setForeground(Color.BLACK);
        messageArea.setBackground(Color.WHITE);
        StringBuilder detailsTextBuilder = new StringBuilder();
        details.forEach((key, value) -> detailsTextBuilder.append(String.format("%-13s: %s\n", key, value)));
        messageArea.setText(String.valueOf(detailsTextBuilder) + "\n" + stackTrace);
        JPanel buttonPanel = new JPanel();
        JButton exitButton = new JButton("Terminate Jadx");
        exitButton.addActionListener(event -> System.exit(1));
        buttonPanel.add(exitButton);
        JButton closeButton = new JButton("Go back to Jadx");
        closeButton.addActionListener(event -> this.setVisible(false));
        buttonPanel.add(closeButton);
        JScrollPane messageAreaScroller = new JScrollPane(messageArea);
        messageAreaScroller.setMinimumSize(new Dimension(600, 400));
        messageAreaScroller.setPreferredSize(new Dimension(600, 400));
        this.add((Component)titlePanel, "North");
        this.add((Component)messageAreaScroller, "Center");
        this.add((Component)buttonPanel, "South");
        this.pack();
        SwingUtilities.invokeLater(() -> messageAreaScroller.getVerticalScrollBar().setValue(0));
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int x15 = (screenSize.width - this.getWidth()) / 2;
        int y15 = (screenSize.height - this.getHeight()) / 2;
        this.setLocation(x15, y15);
        this.getRootPane().registerKeyboardAction(event -> this.setVisible(false), KeyStroke.getKeyStroke(27, 0), 2);
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    public static void throwTestException() {
        try {
            throw new RuntimeException("Inner exception message");
        }
        catch (Exception e15) {
            throw new JadxRuntimeException("Outer exception message", e15);
        }
    }

    public static void showTestExceptionDialog() {
        try {
            ExceptionDialog.throwTestException();
        }
        catch (Exception e15) {
            new ExceptionDialog(null, new ExceptionData(e15, "skylot/jadx"));
        }
    }

    public static void main(String[] args) {
        JadxConfigAdapter<JadxSettingsData> configAdapter = JadxSettings.buildConfigAdapter();
        configAdapter.useConfigRef("");
        JadxSettingsData settingsData = configAdapter.load();
        if (settingsData != null) {
            JadxSettings settings = new JadxSettings(configAdapter);
            settings.loadSettingsData(settingsData);
            LafManager.init(settings);
        }
        ExceptionDialog.showTestExceptionDialog();
    }
}

