/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.plugins.quark;

import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import jadx.core.utils.Utils;
import java.util.List;
import java.util.Map;

public class QuarkReportData {
    String apk_filename;
    String threat_level;
    int total_score;
    List<Crime> crimes;

    public void validate() {
        if (this.crimes == null) {
            throw new RuntimeException("Invalid data: \"crimes\" list missing");
        }
        for (Crime crime : this.crimes) {
            if (crime.confidence == null) {
                throw new RuntimeException("Confidence value missing: " + String.valueOf(crime));
            }
            try {
                crime.parseConfidence();
            }
            catch (Exception e15) {
                throw new RuntimeException("Invalid crime entry: " + String.valueOf(crime));
            }
        }
    }

    public static class Crime {
        public String crime;
        public String confidence;
        public List<String> permissions;
        List<Method> native_api;
        List<JsonElement> combination;
        List<Map<String, InvokePlace>> register;

        public int parseConfidence() {
            return Integer.parseInt(this.confidence.replace("%", ""));
        }

        public String toString() {
            StringBuffer sb5 = new StringBuffer("Crime{");
            sb5.append("crime='").append(this.crime).append('\'');
            sb5.append(", confidence='").append(this.confidence).append('\'');
            sb5.append(", permissions=").append(this.permissions);
            sb5.append(", native_api=").append(this.native_api);
            sb5.append(", combination=").append(this.combination);
            sb5.append(", register=").append(this.register);
            sb5.append('}');
            return sb5.toString();
        }
    }

    public static class InvokePlace {
        List<String> first;
        List<String> second;
    }

    public static class Method {
        @SerializedName(value="class")
        String cls;
        String method;
        String descriptor;

        public String toString() {
            StringBuilder sb5 = new StringBuilder();
            sb5.append(Utils.cleanObjectName(this.cls)).append(".").append(this.method);
            if (this.descriptor != null) {
                sb5.append(this.descriptor);
            }
            return sb5.toString();
        }
    }
}

