/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.cache.usage;

import jadx.api.usage.IUsageInfoData;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.utils.files.FileUtils;
import jadx.gui.cache.code.disk.adapters.DataAdapterHelper;
import jadx.gui.cache.usage.ClsUsageData;
import jadx.gui.cache.usage.CollectUsageData;
import jadx.gui.cache.usage.FldRef;
import jadx.gui.cache.usage.FldUsageData;
import jadx.gui.cache.usage.MthRef;
import jadx.gui.cache.usage.MthUsageData;
import jadx.gui.cache.usage.RawUsageData;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsageFileAdapter
extends DataAdapterHelper {
    private static final Logger LOG = LoggerFactory.getLogger(UsageFileAdapter.class);
    private static final int USAGE_DATA_VERSION = 1;
    private static final byte[] JADX_USAGE_HEADER = "jadx.usage".getBytes(StandardCharsets.US_ASCII);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static synchronized RawUsageData load(Path usageFile, List<File> inputs) {
        if (!Files.isRegularFile(usageFile, new LinkOption[0])) {
            return null;
        }
        long start = System.currentTimeMillis();
        try (DataInputStream in4 = new DataInputStream(new BufferedInputStream(Files.newInputStream(usageFile, new OpenOption[0])));){
            String fileInputsHash;
            in4.skipBytes(JADX_USAGE_HEADER.length);
            int dataVersion = in4.readInt();
            if (dataVersion != 1) {
                LOG.debug("Found old usage data format");
                FileUtils.deleteFileIfExists(usageFile);
                RawUsageData rawUsageData = null;
                return rawUsageData;
            }
            String inputsHash = UsageFileAdapter.buildInputsHash(inputs);
            if (!inputsHash.equals(fileInputsHash = in4.readUTF())) {
                LOG.debug("Found usage data with different inputs hash");
                FileUtils.deleteFileIfExists(usageFile);
                RawUsageData rawUsageData = null;
                return rawUsageData;
            }
            RawUsageData data = UsageFileAdapter.readData(in4);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loaded usage data from disk cache, classes count: {}, time: {}ms, file: {}", data.getClsMap().size(), System.currentTimeMillis() - start, usageFile);
            }
            RawUsageData rawUsageData = data;
            return rawUsageData;
        }
        catch (Exception e15) {
            try {
                FileUtils.deleteFileIfExists(usageFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            LOG.error("Failed to load usage data file", e15);
            return null;
        }
    }

    public static synchronized void save(IUsageInfoData data, Path usageFile, List<File> inputs) {
        long start = System.currentTimeMillis();
        FileUtils.makeDirsForFile(usageFile);
        String inputsHash = UsageFileAdapter.buildInputsHash(inputs);
        RawUsageData usageData = new RawUsageData();
        data.visitUsageData(new CollectUsageData(usageData));
        try (OutputStream fileOutput = Files.newOutputStream(usageFile, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
             DataOutputStream out = new DataOutputStream(new BufferedOutputStream(fileOutput));){
            out.write(JADX_USAGE_HEADER);
            out.writeInt(1);
            out.writeUTF(inputsHash);
            UsageFileAdapter.writeData(out, usageData);
        }
        catch (Exception e15) {
            LOG.error("Failed to save usage data file", e15);
            try {
                FileUtils.deleteFileIfExists(usageFile);
            }
            catch (IOException ex4) {
                LOG.error("Failed to delete usage data file: {}", (Object)usageFile, (Object)ex4);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Usage data saved, time: {}ms, file: {}", (Object)(System.currentTimeMillis() - start), (Object)usageFile);
        }
    }

    private static RawUsageData readData(DataInputStream in4) throws IOException {
        int i15;
        int i16;
        RawUsageData data = new RawUsageData();
        int clsCount = UsageFileAdapter.readUVInt(in4);
        int clsWithoutDataCount = UsageFileAdapter.readUVInt(in4);
        String[] clsNames = new String[clsCount + clsWithoutDataCount];
        ClsUsageData[] classes = new ClsUsageData[clsCount];
        int c15 = 0;
        for (i16 = 0; i16 < clsCount; ++i16) {
            String clsRawName = in4.readUTF();
            classes[i16] = data.getClassData(clsRawName);
            clsNames[c15++] = clsRawName;
        }
        for (i16 = 0; i16 < clsWithoutDataCount; ++i16) {
            clsNames[c15++] = in4.readUTF();
        }
        int mthCount = UsageFileAdapter.readUVInt(in4);
        MthRef[] methods2 = new MthRef[mthCount];
        for (i15 = 0; i15 < mthCount; ++i15) {
            int clsId = UsageFileAdapter.readUVInt(in4);
            String mthShortId = in4.readUTF();
            ClsUsageData cls = classes[clsId];
            MthRef mthRef = new MthRef(cls.getRawName(), mthShortId);
            cls.getMthUsage().put(mthShortId, new MthUsageData(mthRef));
            methods2[i15] = mthRef;
        }
        for (i15 = 0; i15 < clsCount; ++i15) {
            ClsUsageData cls = data.getClassData(clsNames[i15]);
            cls.setClsDeps(UsageFileAdapter.readClsList(in4, clsNames));
            cls.setClsUsage(UsageFileAdapter.readClsList(in4, clsNames));
            cls.setClsUseInMth(UsageFileAdapter.readMthList(in4, methods2));
            int mCount = UsageFileAdapter.readUVInt(in4);
            for (int m15 = 0; m15 < mCount; ++m15) {
                MthRef mthRef = methods2[UsageFileAdapter.readUVInt(in4)];
                cls.getMthUsage().get(mthRef.getShortId()).setUsage(UsageFileAdapter.readMthList(in4, methods2));
            }
            int fCount = UsageFileAdapter.readUVInt(in4);
            for (int f15 = 0; f15 < fCount; ++f15) {
                String fldShortId = in4.readUTF();
                cls.getFldUsage().computeIfAbsent(fldShortId, fldId -> new FldUsageData(new FldRef(cls.getRawName(), (String)fldId))).setUsage(UsageFileAdapter.readMthList(in4, methods2));
            }
        }
        return data;
    }

    private static void writeData(DataOutputStream out, RawUsageData usageData) throws IOException {
        HashMap<String, Integer> clsMap = new HashMap<String, Integer>();
        HashMap<MthRef, Integer> mthMap = new HashMap<MthRef, Integer>();
        Map<String, ClsUsageData> clsDataMap = usageData.getClsMap();
        ArrayList<String> classes = new ArrayList<String>(clsDataMap.keySet());
        Collections.sort(classes);
        List<String> classesWithoutData = usageData.getClassesWithoutData();
        UsageFileAdapter.writeUVInt(out, classes.size());
        UsageFileAdapter.writeUVInt(out, classesWithoutData.size());
        int i15 = 0;
        for (String cls : classes) {
            out.writeUTF(cls);
            clsMap.put(cls, i15++);
        }
        for (String cls : classesWithoutData) {
            out.writeUTF(cls);
            clsMap.put(cls, i15++);
        }
        List methods2 = clsDataMap.values().stream().flatMap(c15 -> c15.getMthUsage().values().stream()).map(MthUsageData::getMthRef).collect(Collectors.toList());
        UsageFileAdapter.writeUVInt(out, methods2.size());
        int j15 = 0;
        for (MthRef mth : methods2) {
            UsageFileAdapter.writeUVInt(out, (Integer)clsMap.get(mth.getCls()));
            out.writeUTF(mth.getShortId());
            mthMap.put(mth, j15++);
        }
        for (String cls : classes) {
            ClsUsageData clsData = clsDataMap.get(cls);
            UsageFileAdapter.writeClsList(out, clsMap, clsData.getClsDeps());
            UsageFileAdapter.writeClsList(out, clsMap, clsData.getClsUsage());
            UsageFileAdapter.writeMthList(out, mthMap, clsData.getClsUseInMth());
            UsageFileAdapter.writeUVInt(out, clsData.getMthUsage().size());
            for (MthUsageData mthData : clsData.getMthUsage().values()) {
                UsageFileAdapter.writeUVInt(out, (Integer)mthMap.get(mthData.getMthRef()));
                UsageFileAdapter.writeMthList(out, mthMap, mthData.getUsage());
            }
            UsageFileAdapter.writeUVInt(out, clsData.getFldUsage().size());
            for (FldUsageData fldData : clsData.getFldUsage().values()) {
                out.writeUTF(fldData.getFldRef().getShortId());
                UsageFileAdapter.writeMthList(out, mthMap, fldData.getUsage());
            }
        }
    }

    private static List<String> readClsList(DataInputStream in4, String[] classes) throws IOException {
        int count = UsageFileAdapter.readUVInt(in4);
        if (count == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> list2 = new ArrayList<String>(count);
        for (int i15 = 0; i15 < count; ++i15) {
            list2.add(classes[UsageFileAdapter.readUVInt(in4)]);
        }
        return list2;
    }

    private static void writeClsList(DataOutputStream out, Map<String, Integer> clsMap, List<String> clsList) throws IOException {
        if (Utils.isEmpty(clsList)) {
            UsageFileAdapter.writeUVInt(out, 0);
            return;
        }
        UsageFileAdapter.writeUVInt(out, clsList.size());
        for (String cls : clsList) {
            Integer clsId = clsMap.get(cls);
            if (clsId == null) {
                throw new JadxRuntimeException("Unknown class in usage: " + cls);
            }
            UsageFileAdapter.writeUVInt(out, clsId);
        }
    }

    private static List<MthRef> readMthList(DataInputStream in4, MthRef[] methods2) throws IOException {
        int count = UsageFileAdapter.readUVInt(in4);
        if (count == 0) {
            return Collections.emptyList();
        }
        ArrayList<MthRef> list2 = new ArrayList<MthRef>(count);
        for (int i15 = 0; i15 < count; ++i15) {
            list2.add(methods2[UsageFileAdapter.readUVInt(in4)]);
        }
        return list2;
    }

    private static void writeMthList(DataOutputStream out, Map<MthRef, Integer> mthMap, List<MthRef> mthList) throws IOException {
        if (Utils.isEmpty(mthList)) {
            UsageFileAdapter.writeUVInt(out, 0);
            return;
        }
        UsageFileAdapter.writeUVInt(out, mthList.size());
        for (MthRef mth : mthList) {
            UsageFileAdapter.writeUVInt(out, mthMap.get(mth));
        }
    }

    private static String buildInputsHash(List<File> inputs) {
        List<Path> paths = inputs.stream().filter(f15 -> !f15.getName().endsWith(".jadx.kts")).map(File::toPath).collect(Collectors.toList());
        return FileUtils.buildInputsHash(paths);
    }
}

